/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.dtk.dt.partial;

import it.uniroma2.dtk.common.Spectrum;
import it.uniroma2.dtk.dt.DefaultAbstractDT;
import it.uniroma2.util.math.ArrayMath;
import it.uniroma2.util.tree.Tree;
import it.uniroma2.util.vector.VectorComposer;

public abstract class AbstractPartialDT
extends DefaultAbstractDT {
    double lambda = 1.0;
    double muSq = 1.0;

    public AbstractPartialDT(int randomOffset, int vectorsSize, boolean usePos, boolean lexicalized) throws Exception {
        super(randomOffset, vectorsSize, usePos, lexicalized);
    }

    public void setLambda(double lambda) {
        super.setLambda(lambda);
        this.lambda = lambda;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setMu(double mu) {
        this.muSq = Math.sqrt(mu);
    }

    public double getMu() {
        return this.muSq * this.muSq;
    }

    protected double[] sRecursive(Tree node, Spectrum sum) throws Exception {
        double[] result = ArrayMath.scalardot(this.lambda, this.getLabelVector(node));
        if (!node.isTerminal()) {
            int i;
            double[][] sums = new double[(int)(Math.pow(2.0, node.getChildren().size()) - 1.0)][this.vectorSize];
            for (i = 0; i < sums.length; ++i) {
                sums[i] = null;
            }
            for (i = 0; i < node.getChildren().size(); ++i) {
                Tree child = node.getChildren().get(i);
                double[] childVector = this.sRecursive(child, sum);
                for (int j = 0; j < sums.length; ++j) {
                    if ((j + 1) % (int)Math.pow(2.0, i + 1) / (int)Math.pow(2.0, i) != 1) continue;
                    sums[j] = sums[j] == null ? childVector : this.op(sums[j], childVector);
                }
            }
            for (int j = 0; j < sums.length; ++j) {
                result = VectorComposer.sum(result, ArrayMath.scalardot(Math.pow(this.lambda, this.d(j + 1)), sums[j]));
            }
            sum.setVector(VectorComposer.sum(sum.getVector(), result));
        }
        return result;
    }

    private int d(int i) {
        int max = 0;
        int min = 0;
        int c = 0;
        while (i > 0) {
            ++c;
            if (i % 2 == 1) {
                if (min == 0) {
                    min = c;
                }
                max = c;
            }
            i /= 2;
        }
        return max - min;
    }
}

