/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.dtk.op.product;

import it.uniroma2.dtk.op.TransformAndCompose;
import it.uniroma2.util.math.ArrayMath;
import it.uniroma2.util.vector.RandomVectorGenerator;
import it.uniroma2.util.vector.VectorProvider;

public class GammaProduct
extends TransformAndCompose {
    protected double gamma = 0.0;

    public double[] op(double[] x, double[] y) {
        return ArrayMath.scalardot(1.0 / this.gamma, this.product(x, y));
    }

    public double[] product(double[] firstVector, double[] secondVector) {
        if (firstVector == null) {
            return secondVector;
        }
        if (secondVector == null) {
            return firstVector;
        }
        int size = firstVector.length;
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            result[i] = firstVector[i] * secondVector[i];
        }
        return result;
    }

    public void initialize(VectorProvider vp) throws Exception {
        super.initialize(vp);
        RandomVectorGenerator rvg = null;
        rvg = vp instanceof RandomVectorGenerator ? (RandomVectorGenerator)vp : new RandomVectorGenerator(vp.getVectorSize());
        for (int i = 0; i < 1000; ++i) {
            this.gamma += ArrayMath.norm(this.product(rvg.generateRandomVector(), rvg.generateRandomVector()));
        }
        this.gamma /= 1000.0;
    }
}

