/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.exp;

import it.uniroma2.dtk.op.convolution.ShuffledCircularConvolution;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExperiment {
    private ArrayList<Parameters> parameters = new ArrayList();
    private int[][] customParameterValues = new int[0][0];
    private boolean verbose = false;
    private boolean silent = false;
    protected PrintStream out = System.out;
    private int[] vectorSizeArray = new int[]{8192};
    private boolean[] usePosArray = new boolean[]{true};
    private boolean[] lexicalizedArray = new boolean[]{true};
    private Class<?>[] compositionTypeArray = new Class[]{ShuffledCircularConvolution.class};
    private int[] randomOffsetArray = new int[]{0};
    private double[] lambdaArray = new double[]{1.0};
    private int[] randomTreeLabelsArray = new int[]{6};
    private int[] randomTreeMaxDegreeArray = new int[]{3};
    private int[] randomTreeNodesArray = new int[]{15};
    protected int vectorSize;
    protected boolean usePos;
    protected boolean lexicalized;
    protected Class<?> compositionType;
    protected int randomOffset;
    protected double lambda;
    protected int randomTreeLabels;
    protected int randomTreeMaxDegree;
    protected int randomTreeNodes;
    protected int[] currentCustomParameters = null;
    protected int[] currentCustomParametersIndexes = null;

    public void runAll() {
        int[] arr$ = this.vectorSizeArray;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int a;
            this.vectorSize = a = arr$[i$];
            boolean[] arr$2 = this.usePosArray;
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                boolean b;
                this.usePos = b = arr$2[i$2];
                boolean[] arr$3 = this.lexicalizedArray;
                int len$3 = arr$3.length;
                for (int i$3 = 0; i$3 < len$3; ++i$3) {
                    boolean c;
                    this.lexicalized = c = arr$3[i$3];
                    for (Class<?> d : this.compositionTypeArray) {
                        this.compositionType = d;
                        int[] arr$4 = this.randomOffsetArray;
                        int len$4 = arr$4.length;
                        for (int i$4 = 0; i$4 < len$4; ++i$4) {
                            int e;
                            this.randomOffset = e = arr$4[i$4];
                            double[] arr$5 = this.lambdaArray;
                            int len$5 = arr$5.length;
                            for (int i$5 = 0; i$5 < len$5; ++i$5) {
                                double f;
                                this.lambda = f = arr$5[i$5];
                                int[] arr$6 = this.randomTreeLabelsArray;
                                int len$6 = arr$6.length;
                                for (int i$6 = 0; i$6 < len$6; ++i$6) {
                                    int g;
                                    this.randomTreeLabels = g = arr$6[i$6];
                                    int[] arr$7 = this.randomTreeMaxDegreeArray;
                                    int len$7 = arr$7.length;
                                    for (int i$7 = 0; i$7 < len$7; ++i$7) {
                                        int h;
                                        this.randomTreeMaxDegree = h = arr$7[i$7];
                                        int[] arr$8 = this.randomTreeNodesArray;
                                        int len$8 = arr$8.length;
                                        for (int i$8 = 0; i$8 < len$8; ++i$8) {
                                            int i;
                                            this.randomTreeNodes = i = arr$8[i$8];
                                            while (this.generateNextCustomParameterCombination()) {
                                                this.runPresentCombination();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void runPresentCombination() {
        if (this.verbose) {
            this.out.println();
            this.out.println("\t***** Executing experiment with following parameters *****");
            for (Parameters par : this.parameters) {
                if (par.equals((Object)Parameters.VECTOR_SIZE)) {
                    this.out.println("\t*Vector size = " + this.vectorSize);
                    continue;
                }
                if (par.equals((Object)Parameters.USE_POS)) {
                    this.out.println("\t*Use pos = " + this.usePos);
                    continue;
                }
                if (par.equals((Object)Parameters.LEXICALIZED)) {
                    this.out.println("\t*Lexicalized = " + this.lexicalized);
                    continue;
                }
                if (par.equals((Object)Parameters.COMPOSITION_TYPE)) {
                    this.out.println("\t*Composition type = " + this.compositionType);
                    continue;
                }
                if (par.equals((Object)Parameters.RANDOM_OFFSET)) {
                    this.out.println("\t*Random offset = " + this.randomOffset);
                    continue;
                }
                if (par.equals((Object)Parameters.LAMBDA)) {
                    this.out.println("\t*Lambda = " + this.lambda);
                    continue;
                }
                if (par.equals((Object)Parameters.RANDOM_LABELS)) {
                    this.out.println("\t*Random tree labels = " + this.randomTreeLabels);
                    continue;
                }
                if (par.equals((Object)Parameters.RANDOM_DEGREE)) {
                    this.out.println("\t*Random tree max degree = " + this.randomTreeMaxDegree);
                    continue;
                }
                if (par.equals((Object)Parameters.RANDOM_NODES)) {
                    this.out.println("\t*Random tree nodes = " + this.randomTreeNodes);
                    continue;
                }
                if (!par.equals((Object)Parameters.CUSTOM)) continue;
                this.out.println("\t*Custom parameters = " + Arrays.toString(this.currentCustomParameters));
            }
            this.out.println("\t**********************************************************");
            this.out.println();
        } else if (!this.silent) {
            this.out.print("\t*****");
            for (Parameters par : this.parameters) {
                if (par.equals((Object)Parameters.VECTOR_SIZE)) {
                    this.out.print("\t" + this.vectorSize);
                    continue;
                }
                if (par.equals((Object)Parameters.USE_POS)) {
                    this.out.print("\t" + this.usePos);
                    continue;
                }
                if (par.equals((Object)Parameters.LEXICALIZED)) {
                    this.out.print("\t" + this.lexicalized);
                    continue;
                }
                if (par.equals((Object)Parameters.COMPOSITION_TYPE)) {
                    this.out.print("\t" + this.compositionType);
                    continue;
                }
                if (par.equals((Object)Parameters.RANDOM_OFFSET)) {
                    this.out.print("\t" + this.randomOffset);
                    continue;
                }
                if (par.equals((Object)Parameters.LAMBDA)) {
                    this.out.print("\t" + this.lambda);
                    continue;
                }
                if (par.equals((Object)Parameters.RANDOM_LABELS)) {
                    this.out.print("\t" + this.randomTreeLabels);
                    continue;
                }
                if (par.equals((Object)Parameters.RANDOM_DEGREE)) {
                    this.out.print("\t" + this.randomTreeMaxDegree);
                    continue;
                }
                if (par.equals((Object)Parameters.RANDOM_NODES)) {
                    this.out.print("\t" + this.randomTreeNodes);
                    continue;
                }
                if (!par.equals((Object)Parameters.CUSTOM)) continue;
                this.out.print("\t" + Arrays.toString(this.currentCustomParameters));
            }
            this.out.println("\t*****");
        }
        try {
            this.runExperiment();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract void runExperiment() throws Exception;

    public void setVerbose() {
        this.verbose = true;
        this.silent = false;
    }

    public void setSilent() {
        this.verbose = false;
        this.silent = true;
    }

    public void setVectorSizeArray(int[] vectorSizeArray) {
        this.parameters.add(Parameters.VECTOR_SIZE);
        this.vectorSizeArray = vectorSizeArray;
    }

    public void setVectorSize(int value) {
        this.setVectorSizeArray(new int[]{value});
    }

    public void setUsePosArray(boolean[] usePosArray) {
        this.parameters.add(Parameters.USE_POS);
        this.usePosArray = usePosArray;
    }

    public void setUsePos(boolean value) {
        this.setUsePosArray(new boolean[]{value});
    }

    public void setLexicalizedArray(boolean[] lexicalizedArray) {
        this.parameters.add(Parameters.LEXICALIZED);
        this.lexicalizedArray = lexicalizedArray;
    }

    public void setLexicalized(boolean value) {
        this.setLexicalizedArray(new boolean[]{value});
    }

    public void setCompositionTypeArray(Class<?>[] compositionTypeArray) {
        this.parameters.add(Parameters.COMPOSITION_TYPE);
        this.compositionTypeArray = compositionTypeArray;
    }

    public void setCompositionType(Class<?> value) {
        this.setCompositionTypeArray(new Class[]{value});
    }

    public void setRandomOffsetArray(int[] randomOffsetArray) {
        this.parameters.add(Parameters.RANDOM_OFFSET);
        this.randomOffsetArray = randomOffsetArray;
    }

    public void setRandomOffset(int value) {
        this.setRandomOffsetArray(new int[]{value});
    }

    public void setRandomOffsetRange(int minValue, int numValues, int step) {
        if (numValues < 1) {
            numValues = 1;
        }
        int[] values = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = minValue + step * i;
        }
        this.setRandomOffsetArray(values);
    }

    public void setLambdaArray(double[] lambdaArray) {
        this.parameters.add(Parameters.LAMBDA);
        this.lambdaArray = lambdaArray;
    }

    public void setLambda(double value) {
        this.setLambdaArray(new double[]{value});
    }

    public void setLambdaRange(double minValue, int numValues, double step) {
        if (numValues < 1) {
            numValues = 1;
        }
        double[] values = new double[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = minValue + step * (double)i;
        }
        this.setLambdaArray(values);
    }

    public void setRandomTreeLabelsArray(int[] randomTreeLabelsArray) {
        this.parameters.add(Parameters.RANDOM_LABELS);
        this.randomTreeLabelsArray = randomTreeLabelsArray;
    }

    public void setRandomTreeLabels(int value) {
        this.setRandomTreeLabelsArray(new int[]{value});
    }

    public void setRandomTreeLabelsRange(int minValue, int numValues, int step) {
        if (numValues < 1) {
            numValues = 1;
        }
        int[] values = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = minValue + step * i;
        }
        this.setRandomTreeLabelsArray(values);
    }

    public void setRandomTreeMaxDegreeArray(int[] randomTreeMaxDegreeArray) {
        this.parameters.add(Parameters.RANDOM_DEGREE);
        this.randomTreeMaxDegreeArray = randomTreeMaxDegreeArray;
    }

    public void setRandomTreeMaxDegree(int value) {
        this.setRandomTreeMaxDegreeArray(new int[]{value});
    }

    public void setRandomTreeMaxDegreeRange(int minValue, int numValues, int step) {
        if (numValues < 1) {
            numValues = 1;
        }
        int[] values = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = minValue + step * i;
        }
        this.setRandomTreeMaxDegreeArray(values);
    }

    public void setRandomTreeNodesArray(int[] randomTreeNodesArray) {
        this.parameters.add(Parameters.RANDOM_NODES);
        this.randomTreeNodesArray = randomTreeNodesArray;
    }

    public void setRandomTreeNodes(int value) {
        this.setRandomTreeNodesArray(new int[]{value});
    }

    public void setRandomTreeNodesRange(int minValue, int numValues, int step) {
        if (numValues < 1) {
            numValues = 1;
        }
        int[] values = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = minValue + step * i;
        }
        this.setRandomTreeNodesArray(values);
    }

    public void setCustomParameters(int[][] values) {
        this.parameters.add(Parameters.CUSTOM);
        this.customParameterValues = values;
    }

    private boolean generateNextCustomParameterCombination() {
        int i;
        int[] customParameterLenghts = new int[this.customParameterValues.length];
        for (i = 0; i < this.customParameterValues.length; ++i) {
            customParameterLenghts[i] = this.customParameterValues[i].length;
        }
        if (this.currentCustomParametersIndexes == null) {
            this.currentCustomParametersIndexes = new int[customParameterLenghts.length];
            Arrays.fill(this.currentCustomParametersIndexes, 0);
            this.currentCustomParameters = new int[customParameterLenghts.length];
            for (i = 0; i < this.currentCustomParametersIndexes.length; ++i) {
                this.currentCustomParameters[i] = this.customParameterValues[i][this.currentCustomParametersIndexes[i]];
            }
            return true;
        }
        for (i = 0; i < this.currentCustomParametersIndexes.length; ++i) {
            if (this.currentCustomParametersIndexes[i] < customParameterLenghts[i] - 1) {
                int n = i;
                this.currentCustomParametersIndexes[n] = this.currentCustomParametersIndexes[n] + 1;
                for (int k = 0; k < this.currentCustomParametersIndexes.length; ++k) {
                    this.currentCustomParameters[k] = this.customParameterValues[k][this.currentCustomParametersIndexes[k]];
                }
                return true;
            }
            this.currentCustomParametersIndexes[i] = 0;
        }
        this.currentCustomParametersIndexes = null;
        this.currentCustomParameters = null;
        return false;
    }

    public void setOutputStream(PrintStream out) {
        this.out = out;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parameters {
        VECTOR_SIZE,
        USE_POS,
        LEXICALIZED,
        COMPOSITION_TYPE,
        RANDOM_OFFSET,
        LAMBDA,
        RANDOM_LABELS,
        RANDOM_DEGREE,
        RANDOM_NODES,
        CUSTOM;

    }
}

