/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.exp.dtk;

import it.uniroma2.dtk.op.IdealOperation;
import it.uniroma2.dtk.op.convolution.ReverseCircularConvolution;
import it.uniroma2.dtk.op.convolution.ShiftedCircularConvolution;
import it.uniroma2.dtk.op.convolution.ShuffledCircularConvolution;
import it.uniroma2.dtk.op.product.ReverseGammaProduct;
import it.uniroma2.dtk.op.product.ShiftedGammaProduct;
import it.uniroma2.dtk.op.product.ShuffledGammaProduct;
import it.uniroma2.exp.AbstractExperiment;
import it.uniroma2.exp.tools.AvgVarCalculator;
import it.uniroma2.util.math.ArrayMath;
import it.uniroma2.util.vector.RandomVectorGenerator;
import it.uniroma2.util.vector.VectorComposer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;

public class FunctionTester
extends AbstractExperiment {
    public static final int TRIALS = 100;
    public static final int MAX_COMP = 20;
    public static final int BASE_SIZE = 100;
    public static final double THRESHOLD = 0.05;
    public RandomVectorGenerator vp;
    public IdealOperation op;
    public double[] x;
    public double[] y;
    public double[] z;

    public static void main(String[] args) {
        FunctionTester ft = new FunctionTester();
        try {
            ft.setOutputStream(new PrintStream(new File("function_tester.dat")));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(0);
        }
        ft.setVectorSizeArray(new int[]{1024, 2048, 4096, 8192});
        ft.setCompositionTypeArray(new Class[]{ShuffledGammaProduct.class, ShuffledCircularConvolution.class, ShiftedGammaProduct.class, ShiftedCircularConvolution.class, ReverseGammaProduct.class, ReverseCircularConvolution.class});
        ft.runAll();
    }

    protected void runExperiment() throws Exception {
        this.vp = new RandomVectorGenerator(this.vectorSize);
        this.op = (IdealOperation)this.compositionType.newInstance();
        this.op.initialize(this.vp);
        this.x = this.rand();
        this.y = this.rand();
        this.z = this.rand();
        this.testCommutativity();
        this.testDistributivity();
        this.testAssociativity();
        this.testBilinearity();
        this.testNorm();
        this.testSimilarity();
        this.testOrthogonality();
    }

    public double[] op(double[] v1, double[] v2) throws Exception {
        return this.op.op(v1, v2);
    }

    public void testCommutativity() throws Exception {
        this.out.println("Non commutativity");
        this.out.println("x#y = " + this.printVector(this.op(this.x, this.y)));
        this.out.println("y#x = " + this.printVector(this.op(this.y, this.x)));
    }

    public void testDistributivity() throws Exception {
        this.out.println("Distributivity (1)");
        this.out.println("(x+y)#z = \t" + this.printVector(this.op(VectorComposer.sum(this.x, this.y), this.z)));
        this.out.println("x#z + y#z = \t" + this.printVector(VectorComposer.sum(this.op(this.x, this.z), this.op(this.y, this.z))));
        this.out.println("Distributivity (2)");
        this.out.println("z#(x+y) = \t" + this.printVector(this.op(this.z, VectorComposer.sum(this.x, this.y))));
        this.out.println("z#x + z#y = \t" + this.printVector(VectorComposer.sum(this.op(this.z, this.x), this.op(this.z, this.y))));
        this.out.println("Distributivity (3)");
        double[] w = this.rand();
        this.out.println("(x+y)#(z+w) = \t\t" + this.printVector(this.op(VectorComposer.sum(this.x, this.y), VectorComposer.sum(this.z, w))));
        this.out.println("x#z+x#w+y#z+y#w = \t" + this.printVector(VectorComposer.sum(this.op(this.x, this.z), VectorComposer.sum(this.op(this.x, w), VectorComposer.sum(this.op(this.y, this.z), this.op(this.y, w))))));
    }

    public void testAssociativity() throws Exception {
        this.out.println("Non Associativity");
        this.out.println("(x#y)#z = \t" + this.printVector(this.op(this.op(this.x, this.y), this.z)));
        this.out.println("x#(y#z) = \t" + this.printVector(this.op(this.x, this.op(this.y, this.z))));
    }

    public void testBilinearity() throws Exception {
        this.out.println("Bilinearity");
        double c = Math.random();
        this.out.println("c(x#y) = \t" + this.printVector(ArrayMath.scalardot(c, this.op(this.x, this.y))));
        this.out.println("cx#y = \t\t" + this.printVector(this.op(ArrayMath.scalardot(c, this.x), this.y)));
        this.out.println("x#cy = \t\t" + this.printVector(this.op(this.x, ArrayMath.scalardot(c, this.y))));
    }

    public void testNorm() throws Exception {
        int i;
        int i2;
        AvgVarCalculator[] norms1 = new AvgVarCalculator[20];
        AvgVarCalculator[] norms2 = new AvgVarCalculator[20];
        AvgVarCalculator[] norms3 = new AvgVarCalculator[20];
        for (i2 = 0; i2 < 20; ++i2) {
            norms1[i2] = new AvgVarCalculator();
            norms2[i2] = new AvgVarCalculator();
            norms3[i2] = new AvgVarCalculator();
        }
        this.out.println("Norm");
        for (i2 = 0; i2 < 100; ++i2) {
            double[] v1 = new double[this.vectorSize];
            double[] v2 = new double[this.vectorSize];
            double[] v3 = new double[this.vectorSize];
            for (int j = 0; j < 20; ++j) {
                v1 = j == 0 ? this.rand() : this.op(v1, this.rand());
                v2 = j == 0 ? VectorComposer.sum(this.rand(), this.rand()) : this.op(v2, VectorComposer.sum(this.rand(), this.rand()));
                v3 = j == 0 ? VectorComposer.sum(this.rand(), VectorComposer.sum(this.rand(), this.rand())) : this.op(v3, VectorComposer.sum(this.rand(), VectorComposer.sum(this.rand(), this.rand())));
                norms1[j].addSample(ArrayMath.norm(v1));
                norms2[j].addSample(ArrayMath.norm(v2));
                norms3[j].addSample(ArrayMath.norm(v3));
            }
        }
        this.out.println("||x#y#z#...||");
        for (i2 = 0; i2 < 20; ++i2) {
            this.out.println(i2 + 1 + " vectors \t" + norms1[i2].getFormattedResult(3));
        }
        this.out.println("||(x+y)#(z+w)#...||");
        for (i2 = 0; i2 < 20; ++i2) {
            this.out.println(i2 + 1 + " couples \t" + String.format("%7.3f\t%9.3f\t%.3f", norms2[i2].getAvg(), norms2[i2].getVar(), norms2[i2].getAvg() / Math.pow(Math.sqrt(2.0), i2 + 1)));
        }
        this.out.println("||(x+y+z)#(w+v+u)#...||");
        for (i2 = 0; i2 < 20; ++i2) {
            this.out.println(i2 + 1 + " triplets \t" + String.format("%8.3f\t%11.3f\t%6.3f", norms3[i2].getAvg(), norms3[i2].getVar(), norms3[i2].getAvg() / Math.pow(Math.sqrt(3.0), i2 + 1)));
        }
        AvgVarCalculator norm = new AvgVarCalculator();
        for (i = 0; i < 100; ++i) {
            this.x = this.rand();
            this.y = this.rand();
            this.z = this.rand();
            norm.addSample(ArrayMath.norm(this.op(VectorComposer.sum(this.x, this.y), this.z)));
        }
        this.out.println("||(x+y)#z|| \t" + String.format("%.3f\t%.3f", norm.getAvg(), norm.getVar()));
        norm.reset();
        for (i = 0; i < 100; ++i) {
            this.x = this.rand();
            this.y = this.rand();
            this.z = this.rand();
            norm.addSample(ArrayMath.norm(this.op(VectorComposer.sum(this.x, this.y), VectorComposer.sum(this.x, this.z))));
        }
        this.out.println("||(x+y)#(x+z)|| \t" + String.format("%.3f\t%.3f", norm.getAvg(), norm.getVar()));
        norm.reset();
        for (i = 0; i < 100; ++i) {
            this.x = this.rand();
            this.y = this.rand();
            this.z = this.rand();
            norm.addSample(ArrayMath.norm(VectorComposer.sum(this.op(this.x, this.y), this.op(this.x, this.z))));
        }
        this.out.println("||x#y + x#z|| \t" + String.format("%.3f\t%.3f", norm.getAvg(), norm.getVar()));
        norm.reset();
        for (i = 0; i < 100; ++i) {
            this.x = this.rand();
            this.y = this.rand();
            this.z = this.rand();
            norm.addSample(ArrayMath.norm(this.op(this.x, this.op(this.y, this.x))));
        }
    }

    public void testSimilarity() throws Exception {
        int i;
        int j;
        double normx;
        int i2;
        this.out.println("Similarity");
        AvgVarCalculator simx = new AvgVarCalculator();
        AvgVarCalculator simy = new AvgVarCalculator();
        for (int i3 = 0; i3 < 100; ++i3) {
            this.x = this.rand();
            this.y = this.rand();
            simx.addSample(ArrayMath.dot(this.x, this.op(this.x, this.y)));
            simy.addSample(ArrayMath.dot(this.y, this.op(this.x, this.y)));
        }
        this.out.println("x \u00b0 x#y \t" + simx.getFormattedResult(5));
        this.out.println("y \u00b0 x#y \t" + simy.getFormattedResult(5));
        AvgVarCalculator[] sims = new AvgVarCalculator[20];
        for (i2 = 0; i2 < 20; ++i2) {
            sims[i2] = new AvgVarCalculator();
        }
        for (i2 = 0; i2 < 100; ++i2) {
            this.x = this.rand();
            this.y = this.rand();
            normx = ArrayMath.norm(this.x);
            for (j = 0; j < 20; ++j) {
                this.y = this.op(this.y, this.rand());
                sims[j].addSample(ArrayMath.dot(this.x, this.y) / (normx * ArrayMath.norm(this.y)));
            }
        }
        this.out.println("x \u00b0 y#z#w#... (normalized)");
        for (i2 = 0; i2 < 20; ++i2) {
            this.out.println(i2 + 1 + " compositions \t" + sims[i2].getFormattedResult(5));
        }
        for (i2 = 0; i2 < 20; ++i2) {
            sims[i2] = new AvgVarCalculator();
        }
        for (i2 = 0; i2 < 100; ++i2) {
            this.x = this.rand();
            this.y = Arrays.copyOf(this.x, this.x.length);
            normx = ArrayMath.norm(this.x);
            for (j = 0; j < 20; ++j) {
                this.y = this.op(this.y, this.rand());
                sims[j].addSample(ArrayMath.dot(this.x, this.y) / (normx * ArrayMath.norm(this.y)));
            }
        }
        this.out.println("x \u00b0 x#y#z#... (normalized)");
        for (i2 = 0; i2 < 20; ++i2) {
            this.out.println(i2 + 1 + " compositions \t" + sims[i2].getFormattedResult(5));
        }
        for (i2 = 0; i2 < 20; ++i2) {
            sims[i2] = new AvgVarCalculator();
        }
        for (i2 = 0; i2 < 100; ++i2) {
            this.x = this.rand();
            this.y = this.rand();
            for (int j2 = 0; j2 < 20; ++j2) {
                this.z = this.rand();
                this.x = this.op(this.x, this.z);
                this.y = this.op(this.y, this.z);
                sims[j2].addSample(ArrayMath.dot(this.x, this.y) / (ArrayMath.norm(this.x) * ArrayMath.norm(this.y)));
            }
        }
        this.out.println("x#z#w#... \u00b0 y#z#w#... (normalized)");
        for (i2 = 0; i2 < 20; ++i2) {
            this.out.println(i2 + 1 + " compositions \t" + sims[i2].getFormattedResult(5));
        }
        for (i2 = 0; i2 < 20; ++i2) {
            sims[i2] = new AvgVarCalculator();
        }
        for (i2 = 0; i2 < 100; ++i2) {
            this.x = this.rand();
            this.y = this.rand();
            this.z = this.rand();
            for (int j3 = 0; j3 < 20; ++j3) {
                double[] v = this.op(this.z, this.x);
                double[] w = this.op(this.z, this.y);
                sims[j3].addSample(ArrayMath.dot(v, w) / (ArrayMath.norm(v) * ArrayMath.norm(w)));
                this.z = this.op(this.z, this.rand());
            }
        }
        this.out.println("z#w#...#x \u00b0 z#w#...#y (normalized)");
        for (i2 = 0; i2 < 20; ++i2) {
            this.out.println(i2 + 1 + " compositions \t" + sims[i2].getFormattedResult(5));
        }
        AvgVarCalculator sim = new AvgVarCalculator();
        for (i = 0; i < 100; ++i) {
            this.x = this.rand();
            this.y = this.rand();
            this.z = this.rand();
            sim.addSample(ArrayMath.dot(this.op(this.x, this.op(this.y, this.z)), this.op(this.z, this.op(this.y, this.x))));
        }
        this.out.println("x#y#z \u00b0 z#y#x \t" + String.format("%.5f (%.5f)", sim.getAvg(), sim.getVar()));
        sim.reset();
        for (i = 0; i < 100; ++i) {
            this.x = this.rand();
            this.y = this.rand();
            this.z = this.rand();
            sim.addSample(ArrayMath.dot(this.op(this.x, this.op(this.y, this.z)), this.op(this.op(this.x, this.y), this.z)));
        }
        this.out.println("x#(y#z) \u00b0 (x#y)#z \t" + String.format("%.5f (%.5f)", sim.getAvg(), sim.getVar()));
        sim.reset();
        for (i = 0; i < 100; ++i) {
            this.x = this.rand();
            this.y = this.rand();
            this.z = this.rand();
            sim.addSample(ArrayMath.dot(this.op(this.x, this.op(this.y, this.z)), this.op(this.x, this.y)));
        }
        this.out.println("x#(y#z) \u00b0 x#y \t" + String.format("%.5f (%.5f)", sim.getAvg(), sim.getVar()));
        sim.reset();
        for (i = 0; i < 100; ++i) {
            this.x = this.rand();
            this.y = this.rand();
            this.z = this.rand();
            sim.addSample(ArrayMath.dot(this.op(this.x, this.y), this.op(this.x, this.z)));
        }
        this.out.println("x#y \u00b0 x#z \t" + String.format("%.5f (%.5f)", sim.getAvg(), sim.getVar()));
        sim.reset();
        for (i = 0; i < 100; ++i) {
            this.x = this.rand();
            this.y = this.rand();
            sim.addSample(ArrayMath.dot(this.x, this.y));
        }
        this.out.println("x \u00b0 y \t" + String.format("%.5f (%.5f)", sim.getAvg(), sim.getVar()));
    }

    public void testOrthogonality() throws Exception {
        boolean isGood;
        this.out.println("Orthogonality");
        Random r = new Random(this.randomOffset);
        Vector<double[]> vectors = new Vector<double[]>();
        for (int i = 0; i < 100; ++i) {
            int retries = 0;
            isGood = false;
            double[] newVector = null;
            block1: while (!isGood) {
                if (retries >= this.vectorSize / 8) {
                    throw new Exception("Could not build a set of 100 nearly orthogonal vectors!");
                }
                newVector = this.rand();
                isGood = true;
                for (double[] vec : vectors) {
                    if (!(ArrayMath.cosine(newVector, vec) > 0.05)) continue;
                    isGood = false;
                    ++retries;
                    continue block1;
                }
            }
            vectors.add(newVector);
        }
        this.out.println("A set of 100 nearly orthogonal vectors has been built...");
        int retries = 0;
        int errors = 0;
        while (retries < this.vectorSize / 8) {
            int id1 = (int)(r.nextDouble() * (double)vectors.size());
            int id2 = (int)(r.nextDouble() * (double)vectors.size());
            while (id1 == id2) {
                id2 = (int)(r.nextDouble() * (double)vectors.size());
            }
            double[] newVector = this.op((double[])vectors.get(id1), (double[])vectors.get(id2));
            isGood = true;
            for (double[] vec : vectors) {
                if (!(ArrayMath.cosine(newVector, vec) > 0.05)) continue;
                isGood = false;
                break;
            }
            if (isGood) {
                vectors.add(newVector);
                errors += retries;
                retries = 0;
                if (vectors.size() % 50 == 0) {
                    this.out.print(vectors.size() + "...");
                }
                if (vectors.size() % 1000 != 0) continue;
                this.out.println();
                continue;
            }
            ++retries;
        }
        this.out.println("\n" + (vectors.size() - 100) + " more valid vectors generated with " + (errors + retries) + " discarded");
    }

    public String printVector(double[] vec) {
        String res = "";
        for (double d : vec) {
            if (res.length() > 100) {
                res = res + "...";
                break;
            }
            res = res + d + "\t";
        }
        return res;
    }

    public double[] rand() {
        return this.vp.generateRandomVector();
    }
}

