/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.exp.task;

import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameter;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameterPoint;
import edu.berkeley.compbio.jlibsvm.binary.BinaryClassificationProblem;
import edu.berkeley.compbio.jlibsvm.binary.BinaryClassificationProblemImpl;
import edu.berkeley.compbio.jlibsvm.binary.BinaryModel;
import edu.berkeley.compbio.jlibsvm.binary.C_SVC;
import it.uniroma2.tk.TreeKernel;
import it.uniroma2.util.tree.ArtificialTreeGenerator;
import it.uniroma2.util.tree.Tree;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTETaskTester {
    private ArtificialTreeGenerator atg = new ArtificialTreeGenerator(0);

    public static void main(String[] args) throws Exception {
        RTETaskTester att = new RTETaskTester();
        att.run();
    }

    public void run() throws Exception {
        System.out.println("Generating training and testing set...");
        HashMap<Tree, Boolean> trainExamples = this.generateExamples(100);
        HashMap<Tree, Integer> exampleIds = new HashMap<Tree, Integer>(trainExamples.size());
        int i = 0;
        double positive = 0.0;
        for (Tree t : trainExamples.keySet()) {
            exampleIds.put(t, i);
            ++i;
            if (!trainExamples.get(t).booleanValue()) continue;
            positive += 1.0;
        }
        System.out.println("Positive examples in training set: " + positive / (double)trainExamples.size() * 100.0 + "%");
        positive = 0.0;
        HashMap<Tree, Boolean> testExamples = this.generateExamples(100);
        for (Tree t : testExamples.keySet()) {
            if (!testExamples.get(t).booleanValue()) continue;
            positive += 1.0;
        }
        System.out.println("Positive examples in testing set: " + positive / (double)testExamples.size() * 100.0 + "%");
        System.out.println("Building parameters...");
        C_SVC<Boolean, Tree> svm = new C_SVC<Boolean, Tree>();
        BinaryClassificationProblemImpl<Boolean, Tree> artificialProblem = new BinaryClassificationProblemImpl<Boolean, Tree>(Boolean.class, trainExamples, exampleIds);
        ImmutableSvmParameterPoint.Builder svmParamBuilder = new ImmutableSvmParameterPoint.Builder();
        svmParamBuilder.kernel = new TreeKernel();
        svmParamBuilder.eps = 0.001f;
        svmParamBuilder.cache_size = 128.0f;
        System.out.println("Training...");
        long time = System.currentTimeMillis();
        BinaryModel<Boolean, Tree> model = svm.train((BinaryClassificationProblem<Boolean, Tree>)artificialProblem, (ImmutableSvmParameter<Boolean, Tree>)svmParamBuilder.build());
        System.out.println((double)(System.currentTimeMillis() - time) / 1000.0 + " seconds");
        System.out.println("Testing...");
        double acc = 0.0;
        for (Tree t : testExamples.keySet()) {
            if (!((Boolean)model.predictLabel((Object)t)).equals(testExamples.get(t))) continue;
            acc += 1.0;
        }
        System.out.println("Accuracy: " + acc / (double)testExamples.size() + "%");
    }

    private HashMap<Tree, Boolean> generateExamples(int number) throws Exception {
        HashMap<Tree, Boolean> examples = new HashMap<Tree, Boolean>();
        while (examples.size() < number) {
            Tree t = this.atg.generateRandomTree();
            examples.put(t, this.isPositiveExample(t));
        }
        return examples;
    }

    private boolean isPositiveExample(Tree t) {
        if (t.getRootLabel().equals("C") && t.getChildren().size() == 2 && t.getChildren().get(0).getRootLabel().equals("A") && t.getChildren().get(1).getRootLabel().equals("B")) {
            return true;
        }
        for (Tree c : t.getChildren()) {
            if (!this.isPositiveExample(c)) continue;
            return true;
        }
        return false;
    }
}

