/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.exp.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiClassSVMWrapperForCDS {
    public static void main(String[] argv) throws Exception {
        String bin_dir = argv[0];
        String command = argv[1];
        String file_to_treat = argv[2];
        if (command.equals("prepare")) {
            String testing_set = argv[3];
            MultiClassSVMWrapperForCDS.generateDifferentTrainingSets(file_to_treat, MultiClassSVMWrapperForCDS.getClassesFromInstanceFile(file_to_treat));
            MultiClassSVMWrapperForCDS.generateLearnersAndClassifierCommand(bin_dir, file_to_treat, testing_set, MultiClassSVMWrapperForCDS.getClassesFromInstanceFile(file_to_treat));
        } else if (command.equals("analyze")) {
            String classes = argv[3];
            MultiClassSVMWrapperForCDS.generateFinalDecisions(file_to_treat, classes);
            MultiClassSVMWrapperForCDS.computePerformances(MultiClassSVMWrapperForCDS.loadClassifiedElements(file_to_treat + ".svm"), MultiClassSVMWrapperForCDS.loadClassifiedElements(file_to_treat + ".out"), MultiClassSVMWrapperForCDS.getClassesFromInstanceFile(file_to_treat));
        } else if (command.equals("class")) {
            String classes = argv[3];
            MultiClassSVMWrapperForCDS.generateFinalDecisions(file_to_treat, classes);
        } else if (command.equals("perf")) {
            MultiClassSVMWrapperForCDS.computePerformances(MultiClassSVMWrapperForCDS.loadClassifiedElements(file_to_treat + ".svm"), MultiClassSVMWrapperForCDS.loadClassifiedElements(file_to_treat + ".out"), MultiClassSVMWrapperForCDS.getClassesFromInstanceFile(file_to_treat));
        }
    }

    public static Vector<String> getClassesFromInstanceFile(String instance_set) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(instance_set + ".svm"));
        String line = in.readLine();
        Vector<String> classes = new Vector<String>();
        while (line != null && !line.trim().equals("")) {
            if (!classes.contains(line = line.substring(0, line.indexOf(9)).trim())) {
                classes.add(line);
            }
            line = in.readLine();
        }
        in.close();
        return classes;
    }

    public static void generateDifferentTrainingSets(String training_set, Vector<String> classes) throws Exception {
        BufferedWriter[] out = new BufferedWriter[classes.size()];
        int i = 0;
        for (String c : classes) {
            out[i] = new BufferedWriter(new FileWriter(training_set + "_" + c + ".svm"));
            ++i;
        }
        BufferedReader in = new BufferedReader(new FileReader(training_set + ".svm"));
        String line = in.readLine();
        String c = null;
        String instance = null;
        while (line != null && !line.trim().equals("")) {
            c = line.substring(0, line.indexOf(9)).trim();
            instance = line.substring(line.indexOf(9) + 1, line.length()).trim();
            i = 0;
            for (String cc : classes) {
                if (cc.equals(c)) {
                    out[i].write("1\t" + instance + "\n");
                } else {
                    out[i].write("-1\t" + instance + "\n");
                }
                ++i;
            }
            line = in.readLine();
        }
        in.close();
        for (i = 0; i < out.length; ++i) {
            out[i].close();
        }
    }

    public static void generateLearnersAndClassifierCommand(String bin_dir, String training_set, String testing_set, Vector<String> classes) throws Exception {
        File svm_learn = new File(bin_dir, "svm_learn");
        File svm_classify = new File(bin_dir, "svm_classify");
        OS os = File.separatorChar == '/' ? OS.LINUX : OS.WIN;
        String name = new File(training_set).getName();
        String p_left = os == OS.WIN ? "%" : "$";
        String p_right = os == OS.WIN ? "%" : "";
        String set = os == OS.WIN ? "SET " : "";
        BufferedWriter command = new BufferedWriter(new FileWriter("svm_multi_learner" + (os == OS.WIN ? ".bat" : "")));
        command.write((os == OS.WIN ? "@echo off" : "#!/bin/bash") + "\n\n");
        command.write(set + "SVM_PARAMETERS=" + (os == OS.WIN ? "%" : "$") + "*\n\n");
        for (String c : classes) {
            command.write("echo ---------------\necho Learning model for " + c + " class\necho ---------------\n");
            command.write(svm_learn + " " + p_left + "SVM_PARAMETERS" + p_right + " " + training_set + "_" + c + ".svm " + training_set + "_" + c + "_model.svm\n");
        }
        command.close();
        command = new BufferedWriter(new FileWriter("svm_multi_classifier" + (os == OS.WIN ? ".bat" : "")));
        command.write((os == OS.WIN ? "@echo off" : "#!/bin/bash") + "\n\n");
        for (String c : classes) {
            command.write("echo ---------------\necho Classifying for " + c + " class\necho ---------------\n");
            command.write(svm_classify + " " + testing_set + ".svm " + training_set + "_" + c + "_model.svm " + testing_set + "_" + c + ".out" + "\n");
        }
        command.close();
        command = new BufferedWriter(new FileWriter(new File(new File(training_set).getParentFile(), name + "_classes.txt")));
        for (String c : classes) {
            command.write(c + ":");
        }
        command.write("\n");
        command.close();
    }

    public static void generateFinalDecisions(String testing_set, String classes_file) throws Exception {
        int i;
        BufferedReader classes_in = new BufferedReader(new FileReader(classes_file));
        String[] classes = classes_in.readLine().split(":");
        classes_in.close();
        BufferedReader[] in = new BufferedReader[classes.length];
        for (int i2 = 0; i2 < classes.length; ++i2) {
            in[i2] = new BufferedReader(new FileReader(testing_set + "_" + classes[i2] + ".out"));
        }
        BufferedReader testing = new BufferedReader(new FileReader(testing_set + ".svm"));
        BufferedWriter testing_decisions = new BufferedWriter(new FileWriter(testing_set + ".out"));
        String line = testing.readLine();
        double max = 0.0;
        int max_class = 0;
        while (line != null) {
            max = Double.NEGATIVE_INFINITY;
            max_class = 0;
            for (i = 0; i < classes.length; ++i) {
                double act = new Double(in[i].readLine().trim());
                if (!(act > max)) continue;
                max = act;
                max_class = i;
            }
            testing_decisions.write(classes[max_class] + "\t" + max + "\n");
            line = testing.readLine();
        }
        testing.close();
        testing_decisions.close();
        for (i = 0; i < in.length; ++i) {
            in[i].close();
        }
    }

    public static void computePerformances(Vector<String> oracle, Vector<String> system_decisions, Vector<String> classes) throws Exception {
        int i;
        int i2;
        System.out.println("--- Computing performances ---");
        int[][] confusion_matrix = new int[classes.size()][classes.size()];
        for (i2 = 0; i2 < classes.size(); ++i2) {
            for (int j = 0; j < classes.size(); ++j) {
                confusion_matrix[i2][j] = 0;
            }
        }
        for (i2 = 0; i2 < oracle.size(); ++i2) {
            int[] nArray = confusion_matrix[classes.indexOf(oracle.elementAt(i2))];
            int n = classes.indexOf(system_decisions.elementAt(i2));
            nArray[n] = nArray[n] + 1;
        }
        int good_decisions = 0;
        for (int i3 = 0; i3 < classes.size(); ++i3) {
            good_decisions += confusion_matrix[i3][i3];
        }
        double accuracy = (double)good_decisions / (double)oracle.size();
        System.out.print("\t");
        for (i = 0; i < classes.size(); ++i) {
            System.out.print(classes.elementAt(i) + "\t");
        }
        System.out.println();
        for (i = 0; i < classes.size(); ++i) {
            System.out.print(classes.elementAt(i) + "\t");
            for (int j = 0; j < classes.size(); ++j) {
                System.out.print("" + confusion_matrix[i][j] + "\t");
            }
            System.out.println();
        }
        System.out.println("Accuracy: " + accuracy * 100.0 + "%");
    }

    public static Vector<String> loadClassifiedElements(String instance_set) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(instance_set));
        String line = in.readLine();
        Vector<String> decisions = new Vector<String>();
        while (line != null) {
            if ((line = line.trim()).indexOf(9) > 0) {
                line = line.substring(0, line.indexOf(9)).trim();
            }
            decisions.add(line);
            line = in.readLine();
        }
        in.close();
        return decisions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        LINUX,
        WIN;

    }
}

