/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.svd.writer;

import it.uniroma2.svd.DataInterface;
import it.uniroma2.svd.writer.DataPlusInputStream;
import it.uniroma2.svd.writer.DataPlusOutputStream;
import it.uniroma2.svd.writer.FileTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Hashtable;

public class FileToolsBin
implements FileTools {
    DataPlusOutputStream out = null;

    public void initHandle(String PathOutput) throws Exception {
        this.out = new DataPlusOutputStream(new FileOutputStream(PathOutput));
    }

    public void closeHandle() throws Exception {
        this.out.flush();
        this.out.close();
    }

    public Object[] loadToken(String PathInput) throws Exception {
        System.out.println("Loading " + PathInput + " (every '.' correspond to 1000 lines loaded ");
        Hashtable<String, Integer> dataHash = new Hashtable<String, Integer>();
        DataPlusInputStream in = new DataPlusInputStream(new File(PathInput));
        int row = in.readInt();
        int column = in.readInt();
        Object[][] data = new Object[row][4];
        byte[] buffer = new byte[column * 4 + 8];
        for (int i = 0; i < row; ++i) {
            short lungStr = in.readShort();
            String feature = in.readString(lungStr);
            data[i][0] = feature;
            in.read(buffer);
            ByteArrayInputStream b = new ByteArrayInputStream(buffer);
            DataInputStream inn = new DataInputStream(b);
            data[i][1] = new Float(inn.readFloat());
            data[i][2] = new Float(inn.readFloat());
            float[] matrixData = new float[column];
            for (int j = 0; j < column; ++j) {
                matrixData[j] = inn.readFloat();
            }
            data[i][3] = matrixData;
            inn.close();
            b.close();
            feature = feature.replaceAll("[(),.;!?\"%'\\/{}~^]", "");
            dataHash.put(feature, new Integer(i));
            if (i % 1000 != 0) continue;
            System.out.print(".");
        }
        in.close();
        Object[] ritorni = new Object[]{data, dataHash};
        System.out.println(" ... Loaded");
        return ritorni;
    }

    public void writeTokenLine(float[] matrixData, int index, DataInterface data, FileTools.type type2) throws Exception {
        int column = matrixData.length;
        int row = 0;
        String feature = null;
        switch (type2) {
            case DOC: {
                row = data.documentSize();
                try {
                    feature = data.getDoc(index);
                    if (feature != null) break;
                    System.err.println("Error accessing DATA: Search doc by id " + index);
                    feature = "ERROR";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Error accessing DATA: Search doc by id " + index);
                    feature = "ERROR";
                }
                break;
            }
            case WORD: {
                row = data.termSize();
                try {
                    feature = data.getWord(index);
                    if (feature != null) break;
                    System.err.println("Error accessing DATA: Search word by id " + index);
                    feature = "ERROR";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Error accessing DATA: Search word by id " + index);
                    feature = "ERROR";
                }
                break;
            }
        }
        if (index == 0) {
            this.out.writeInt(row);
            this.out.writeInt(column);
        }
        Float weight = type2 == FileTools.type.DOC ? Float.valueOf(0.0f) : Float.valueOf(data.getWordWeight(index) != null ? new Float(data.getWordWeight(index)).floatValue() : 0.0f);
        try {
            this.out.writeShort((short)feature.length());
            this.out.writeString(feature, feature.length());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error writing DATA: feature " + feature + " -- out " + (this.out == null ? "null" : "not null"));
            return;
        }
        ByteArrayOutputStream b = new ByteArrayOutputStream(column * 4 + 8);
        DataOutputStream outt = new DataOutputStream(b);
        outt.writeFloat(weight.floatValue());
        outt.writeFloat(0.0f);
        for (int n = 0; n < column; ++n) {
            outt.writeFloat(matrixData[n]);
        }
        this.out.write(b.toByteArray());
        outt.close();
        b.close();
        if (index % 1000 == 0) {
            System.out.print(".");
        }
    }

    public void writeToken(float[][] matrixData, String pathOut, DataInterface data, FileTools.type type2) throws Exception {
        this.out = new DataPlusOutputStream(new FileOutputStream(pathOut));
        int row = matrixData.length;
        int column = matrixData[0].length;
        System.out.println("row: " + row + " column: " + column);
        System.out.println("path Out writing in progress (One dot every 1000 lines): " + pathOut);
        for (int index = 0; index < row; ++index) {
            String feature = null;
            switch (type2) {
                case DOC: {
                    try {
                        feature = data.getDoc(index);
                        if (feature != null) break;
                        System.err.println("Error accessing DATA: Search doc by id " + index);
                        feature = "ERROR";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Error accessing DATA: Search doc by id " + index);
                        feature = "ERROR";
                    }
                    break;
                }
                case WORD: {
                    try {
                        feature = data.getWord(index);
                        if (feature != null) break;
                        System.err.println("Error accessing DATA: Search word by id " + index);
                        feature = "ERROR";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Error accessing DATA: Search word by id " + index);
                        feature = "ERROR";
                    }
                    break;
                }
            }
            if (index == 0) {
                this.out.writeInt(row);
                this.out.writeInt(column);
            }
            Float weight = type2 == FileTools.type.DOC ? Float.valueOf(0.0f) : Float.valueOf(data.getWordWeight(index) != null ? new Float(data.getWordWeight(index)).floatValue() : 0.0f);
            try {
                this.out.writeShort((short)feature.length());
                this.out.writeString(feature, feature.length());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Error writing DATA: feature " + feature + " -- out " + (this.out == null ? "null" : "not null"));
                return;
            }
            this.out.writeFloat(weight.floatValue());
            this.out.writeFloat(0.0f);
            for (int n = 0; n < column; ++n) {
                this.out.writeFloat(matrixData[index][n]);
            }
            if (index % 1000 != 0) continue;
            System.out.print(".");
        }
        this.out.close();
    }
}

