/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.svd.writer;

import it.uniroma2.svd.DataInterface;
import it.uniroma2.svd.writer.FileTools;
import it.uniroma2.svd.writer.LittleEndianInputStream;
import it.uniroma2.svd.writer.LittleEndianOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Hashtable;

public class FileToolsBinLE
implements FileTools {
    LittleEndianOutputStream out = null;

    public void initHandle(String PathOutput) throws Exception {
        this.out = new LittleEndianOutputStream(new FileOutputStream(PathOutput));
    }

    public void closeHandle() throws Exception {
        this.out.flush();
        this.out.close();
    }

    public Object[] loadToken(String PathInput) throws Exception {
        Hashtable<String, Integer> dataHash = new Hashtable<String, Integer>();
        LittleEndianInputStream in = new LittleEndianInputStream(new FileInputStream(PathInput));
        int row = in.readLEInt();
        int column = in.readLEInt();
        Object[][] data = new Object[row][4];
        for (int i = 0; i < row; ++i) {
            short lungStr = in.readLEShort();
            String feature = in.readString(lungStr);
            data[i][0] = feature;
            data[i][1] = new Float(in.readLEFloat());
            data[i][2] = new Float(in.readLEFloat());
            float[] matrixData = new float[column];
            for (int j = 0; j < column; ++j) {
                matrixData[j] = in.readLEFloat();
            }
            data[i][3] = matrixData;
            dataHash.put(feature.trim(), new Integer(i));
        }
        in.close();
        Object[] ritorni = new Object[]{data, dataHash};
        return ritorni;
    }

    public void writeTokenLine(float[] matrixData, int index, DataInterface data, FileTools.type type2) throws Exception {
        int column = matrixData.length;
        int row = 0;
        String feature = null;
        switch (type2) {
            case DOC: {
                row = data.documentSize();
                feature = data.getDoc(index);
                break;
            }
            case WORD: {
                row = data.termSize();
                feature = data.getWord(index);
                break;
            }
        }
        if (index == 0) {
            this.out.writeLEInt(row);
            this.out.writeLEInt(column);
        }
        Float weight = Float.valueOf(data.getWordWeight(index) != null ? new Float(data.getWordWeight(index)).floatValue() : 0.0f);
        this.out.writeLEShort((short)feature.length());
        this.out.writeString(feature, feature.length());
        this.out.writeLEFloat(weight.floatValue());
        this.out.writeLEFloat(0.0f);
        for (int n = 0; n < column; ++n) {
            this.out.writeLEFloat(matrixData[n]);
        }
        if (index % 1000 == 0) {
            System.out.print(".");
        }
    }

    public void writeToken(float[][] matrixData, String pathOutput, DataInterface data, FileTools.type type2) throws Exception {
        this.out = new LittleEndianOutputStream(new FileOutputStream(pathOutput));
        int row = matrixData.length;
        int column = matrixData[0].length;
        this.out.writeLEInt(row);
        this.out.writeLEInt(column);
        System.out.println("path Out writing in progress (One dot every 1000 lines): " + pathOutput);
        for (int index = 0; index < row; ++index) {
            String feature = null;
            switch (type2) {
                case DOC: {
                    feature = data.getDoc(index);
                    break;
                }
                case WORD: {
                    feature = data.getWord(index);
                    break;
                }
            }
            Float weight = Float.valueOf(data.getWordWeight(index) != null ? new Float(data.getWordWeight(index)).floatValue() : 0.0f);
            this.out.writeLEShort((short)feature.length());
            this.out.writeString(feature, feature.length());
            this.out.writeLEFloat(weight.floatValue());
            this.out.writeLEFloat(0.0f);
            for (int n = 0; n < column; ++n) {
                this.out.writeLEFloat(matrixData[index][n]);
            }
            if (index % 1000 != 0) continue;
            System.out.print(".");
        }
        this.out.close();
    }
}

