/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.svd.writer;

import it.uniroma2.svd.DataInterface;
import it.uniroma2.svd.writer.BinaryMatrix;
import it.uniroma2.svd.writer.FileTools;
import it.uniroma2.svd.writer.ReadFileLSA;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileToolsTxt
implements FileTools {
    PrintWriter output_ = null;

    @Override
    public void initHandle(String PathOutput) throws Exception {
        this.output_ = new PrintWriter((Writer)new FileWriter(PathOutput), true);
    }

    @Override
    public void closeHandle() throws Exception {
        this.output_.flush();
        this.output_.close();
    }

    @Override
    public Object[] loadToken(String PathInput) throws Exception {
        System.out.println("Loading " + PathInput);
        Hashtable<String, Integer> dataHash = new Hashtable<String, Integer>();
        ReadFileLSA read = new ReadFileLSA(PathInput, "\t");
        Vector<String> Info2 = read.getInfo();
        Vector<Float> TF = read.getTF();
        Vector<Object> Data = read.getData();
        String feature = "";
        int row = Info2.size();
        Object[][] data = new Object[row][4];
        for (int i = 0; i < row; ++i) {
            feature = Info2.elementAt(i);
            data[i][0] = feature;
            data[i][1] = TF.elementAt(i);
            data[i][2] = Float.valueOf(0.0f);
            StringTokenizer st1 = new StringTokenizer((String)Data.elementAt(i), ",");
            boolean zero = true;
            float[] matrixData = new float[st1.countTokens()];
            int j = 0;
            while (st1.hasMoreTokens()) {
                matrixData[j] = Float.parseFloat(st1.nextToken());
                if (zero && matrixData[j] != 0.0f) {
                    zero = false;
                }
                ++j;
            }
            if (zero) {
                System.out.println("***Loaded zero row at " + i);
            }
            data[i][3] = matrixData;
            dataHash.put(feature.trim(), new Integer(i));
            if (i % 1000 != 0) continue;
            System.out.print(".");
        }
        Object[] ritorni = new Object[]{data, dataHash};
        System.out.println(" ... Loaded");
        return ritorni;
    }

    protected static Float WeigthW(BinaryMatrix<Float> weight, int indexRow) throws Exception {
        TreeMap<Integer, Float> WeightWord = weight.getSparseRow(indexRow);
        float weigthW = 0.0f;
        for (Integer id_d : WeightWord.keySet()) {
            weigthW += WeightWord.get(id_d).floatValue();
        }
        weigthW = WeightWord.size() != 0 ? (weigthW /= (float)WeightWord.keySet().size()) : 0.0f;
        return Float.valueOf(weigthW);
    }

    @Override
    public void writeTokenLine(float[] matrixData, int index, DataInterface data, FileTools.type type2) throws Exception {
        int column = matrixData.length;
        String line = "";
        String lineData = "";
        switch (type2) {
            case DOC: {
                line = data.getDoc(index);
                break;
            }
            case WORD: {
                line = data.getWord(index);
                break;
            }
        }
        for (int n = 0; n < column; ++n) {
            lineData = n == column - 1 ? lineData + matrixData[n] : lineData + matrixData[n] + ",";
        }
        Float weight = type2 == FileTools.type.DOC ? Float.valueOf(0.0f) : Float.valueOf(data.getWordWeight(index) != null ? new Float(data.getWordWeight(index)).floatValue() : 0.0f);
        line = line + "\t" + weight + "\t" + 0 + "\t" + lineData;
        this.output_.println(line);
        if (index % 1000 == 0) {
            System.out.print(".");
        }
    }

    @Override
    public void writeToken(float[][] matrixData, String pathOut, DataInterface data, FileTools.type type2) throws Exception {
        PrintWriter output_ = new PrintWriter((Writer)new FileWriter(pathOut), true);
        int row = matrixData.length;
        int column = matrixData[0].length;
        System.out.println("path Out writing in progress (One dot every 1000 lines): " + pathOut);
        for (int index = 0; index < row; ++index) {
            String line = "";
            String lineData = "";
            switch (type2) {
                case DOC: {
                    line = data.getDoc(index);
                    break;
                }
                case WORD: {
                    line = data.getWord(index);
                    break;
                }
            }
            for (int n = 0; n < column; ++n) {
                lineData = n == column - 1 ? lineData + matrixData[index][n] : lineData + matrixData[index][n] + ",";
            }
            Float weight = type2 == FileTools.type.DOC ? Float.valueOf(0.0f) : Float.valueOf(data.getWordWeight(index) != null ? new Float(data.getWordWeight(index)).floatValue() : 0.0f);
            line = line + "\t" + weight + "\t" + 0 + "\t" + lineData;
            output_.println(line);
            if (index % 1000 != 0) continue;
            System.out.print(".");
        }
        output_.close();
    }
}

