/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.util.math.statistical;

public class PearsonCorrelation {
    private double xTot = 0.0;
    private double yTot = 0.0;
    private double sqrXTot = 0.0;
    private double sqrYTot = 0.0;
    private double xYTot = 0.0;
    private double totalN = 0.0;

    public void addPairsToCorrelate(float[] x, float[] y) {
        double N = x.length;
        int i = 0;
        while ((double)i < N) {
            this.xTot += (double)x[i];
            this.yTot += (double)y[i];
            this.sqrXTot += Math.pow(x[i], 2.0);
            this.sqrYTot += Math.pow(y[i], 2.0);
            this.xYTot += (double)(x[i] * y[i]);
            ++i;
        }
        this.totalN += N;
    }

    public Double calculateAdditivePairCorrelation() {
        double botRight;
        double top = this.totalN * this.xYTot - this.xTot * this.yTot;
        double botLeft = Math.sqrt(this.totalN * this.sqrXTot - Math.pow(this.xTot, 2.0));
        double bot = botLeft * (botRight = Math.sqrt(this.totalN * this.sqrYTot - Math.pow(this.yTot, 2.0)));
        if (bot == 0.0) {
            return null;
        }
        return new Double(top / bot);
    }

    public static double correlationCoefficient(float[] x, float[] y) {
        double botRight;
        double N = x.length;
        double xTot = 0.0;
        double yTot = 0.0;
        double sqrXTot = 0.0;
        double sqrYTot = 0.0;
        double xYTot = 0.0;
        int i = 0;
        while ((double)i < N) {
            xTot += (double)x[i];
            yTot += (double)y[i];
            sqrXTot += Math.pow(x[i], 2.0);
            sqrYTot += Math.pow(y[i], 2.0);
            xYTot += (double)(x[i] * y[i]);
            ++i;
        }
        double top = N * xYTot - xTot * yTot;
        double botLeft = Math.sqrt(N * sqrXTot - Math.pow(xTot, 2.0));
        double bot = botLeft * (botRight = Math.sqrt(N * sqrYTot - Math.pow(yTot, 2.0)));
        if (bot == 0.0) {
            String message = "Warning: calc of corr coef error, Num.java";
            System.out.println(message);
            return -2.0;
        }
        return top / bot;
    }

    public static double correlationCoefficient(double[] x, double[] y) {
        double N = x.length;
        double xTot = 0.0;
        double yTot = 0.0;
        double sqrXTot = 0.0;
        double sqrYTot = 0.0;
        double xYTot = 0.0;
        int i = 0;
        while ((double)i < N) {
            xTot += x[i];
            yTot += y[i];
            sqrXTot += Math.pow(x[i], 2.0);
            sqrYTot += Math.pow(y[i], 2.0);
            xYTot += x[i] * y[i];
            ++i;
        }
        double top = N * xYTot - xTot * yTot;
        double botLeft = Math.sqrt(N * sqrXTot - Math.pow(xTot, 2.0));
        double botRight = Math.sqrt(N * sqrYTot - Math.pow(yTot, 2.0));
        return top / (botLeft * botRight);
    }
}

