/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.util.math.statistical;

import it.uniroma2.util.math.statistical.Num;
import it.uniroma2.util.math.statistical.PearsonCorrelation;
import it.uniroma2.util.math.statistical.RankSample;
import it.uniroma2.util.math.statistical.RankSampleIndexComparator;
import it.uniroma2.util.math.statistical.RankSampleValueComparator;
import it.uniroma2.util.math.statistical.RankedFloatArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Arrays;

public class SpearmanCorrelation {
    private RankSampleIndexComparator indexComp = new RankSampleIndexComparator();
    private RankSampleValueComparator valueComp = new RankSampleValueComparator();
    private RankedFloatArray aRFA;
    private RankedFloatArray bRFA;

    public double spearmanCorrelationCoefficient(float[] a, float[] b) {
        this.aRFA = this.rank(a);
        this.bRFA = this.rank(b);
        if (this.aRFA.tiesFound || this.bRFA.tiesFound) {
            return PearsonCorrelation.correlationCoefficient(this.aRFA.ranks, this.bRFA.ranks);
        }
        return this.corrCoeff(this.aRFA.ranks, this.bRFA.ranks);
    }

    public double spearmanCorrelationCoefficient(RankedFloatArray aRFA, RankedFloatArray bRFA) {
        if (aRFA.tiesFound || bRFA.tiesFound) {
            return PearsonCorrelation.correlationCoefficient(aRFA.ranks, bRFA.ranks);
        }
        return this.corrCoeff(aRFA.ranks, bRFA.ranks);
    }

    public double corrCoeff(float[] a, float[] b) {
        double sumSqrDiffs = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double diff = a[i] - b[i];
            sumSqrDiffs += diff * diff;
        }
        double numer = 6.0 * sumSqrDiffs;
        double n = a.length;
        double sqrN = n * n;
        double denom = n * (sqrN - 1.0);
        return 1.0 - numer / denom;
    }

    public RankedFloatArray rank(float[] f) {
        RankSample[] rs = new RankSample[f.length];
        for (int i = 0; i < f.length; ++i) {
            rs[i] = new RankSample(i, f[i]);
        }
        Arrays.sort(rs, this.valueComp);
        return this.rankSamples(rs);
    }

    public RankedFloatArray rankSamples(RankSample[] rs) {
        int num = rs.length;
        boolean tiesFound = false;
        for (int i = 0; i < num; ++i) {
            rs[i].rank = i + 1;
        }
        for (int i = 0; i < num; ++i) {
            int start = i;
            int end = i;
            while (++end < num && rs[start].value == rs[end].value) {
            }
            if (end - start == 1) continue;
            tiesFound = true;
            float ave = Num.getAverageInts((int)rs[start].rank, (int)rs[end - 1].rank);
            for (int x = start; x < end; ++x) {
                rs[x].rank = ave;
            }
            i = end - 1;
        }
        Arrays.sort(rs, this.indexComp);
        float[] ranks = new float[rs.length];
        for (int i = 0; i < rs.length; ++i) {
            ranks[i] = rs[i].rank;
        }
        rs = null;
        return new RankedFloatArray(tiesFound, ranks);
    }

    public static void main(String[] argv) throws Exception {
        BufferedReader a_file = new BufferedReader(new FileReader(argv[0]));
        int lines = 0;
        String line = a_file.readLine();
        while (line != null) {
            line = a_file.readLine();
            ++lines;
        }
        a_file.close();
        float[] a = new float[--lines];
        float[] b = new float[lines];
        a_file = new BufferedReader(new FileReader(argv[0]));
        BufferedReader b_file = new BufferedReader(new FileReader(argv[1]));
        String a_line = a_file.readLine();
        a_line = a_file.readLine();
        String b_line = b_file.readLine();
        b_line = b_file.readLine();
        lines = 0;
        while (a_line != null) {
            a[lines] = new Float(a_line.split("\t")[5]).floatValue();
            b[lines] = new Float(b_line.split("\t")[5]).floatValue();
            ++lines;
            a_line = a_file.readLine();
            b_line = b_file.readLine();
        }
        a_file.close();
        b_file.close();
        SpearmanCorrelation sp = new SpearmanCorrelation();
        System.out.print(sp.spearmanCorrelationCoefficient(a, b));
        a = SpearmanCorrelation.normalize(a);
        b = SpearmanCorrelation.normalize(b);
        BufferedWriter out_for_statistical_significance = new BufferedWriter(new FileWriter(argv[0] + "_4statsig"));
        for (int i = 0; i < a.length; ++i) {
            out_for_statistical_significance.write("" + a[i] + " " + b[i] + "\n");
        }
        out_for_statistical_significance.close();
    }

    private static float[] normalize(float[] a) {
        int i;
        float[] a_new = new float[a.length];
        float max = 0.0f;
        float min = 1.0f;
        for (i = 0; i < a.length; ++i) {
            if (a[i] > max) {
                max = a[i];
            }
            if (!(a[i] < min)) continue;
            min = a[i];
        }
        for (i = 0; i < a.length; ++i) {
            a_new[i] = (a[i] - min) / (max - min);
        }
        return a_new;
    }

    public RankedFloatArray getARFA() {
        return this.aRFA;
    }

    public void setARFA(RankedFloatArray arfa) {
        this.aRFA = arfa;
    }

    public RankedFloatArray getBRFA() {
        return this.bRFA;
    }

    public void setBRFA(RankedFloatArray brfa) {
        this.bRFA = brfa;
    }
}

