/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.util.tree;

import it.uniroma2.util.tree.Tree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeDecomposition {
    public List<Tree> getSubtrees(Tree tree) throws Exception {
        ArrayList<Tree> treeList = new ArrayList<Tree>();
        this.getSubtrees(tree, treeList);
        return treeList;
    }

    private List<Tree> getSubtrees(Tree tree, List<Tree> fullList) {
        ArrayList<Tree> list = new ArrayList<Tree>();
        Tree rootNode = tree.cloneNode();
        if (tree.getChildren().size() > 0) {
            ArrayList<List<Tree>> childTrees = new ArrayList<List<Tree>>();
            for (Tree child : tree.getChildren()) {
                childTrees.add(this.getSubtrees(child, fullList));
            }
            list.addAll(this.appendTrees(tree, childTrees));
        }
        fullList.addAll(list);
        list.add(rootNode);
        return list;
    }

    private List<Tree> appendTrees(Tree rootNode, List<List<Tree>> childAlternatives) {
        ArrayList<Tree> results = new ArrayList<Tree>();
        int[] maxIndices = new int[childAlternatives.size()];
        for (int i = 0; i < maxIndices.length; ++i) {
            maxIndices[i] = childAlternatives.get(i).size();
        }
        int[] indices = this.nextCombination(null, maxIndices);
        while (indices != null) {
            Tree tree = rootNode.cloneNode();
            for (int i = 0; i < indices.length; ++i) {
                tree.getChildren().add(childAlternatives.get(i).get(indices[i]));
            }
            results.add(tree);
            indices = this.nextCombination(indices, maxIndices);
        }
        return results;
    }

    private int[] nextCombination(int[] oldIndices, int[] maxIndices) {
        int[] newIndices = oldIndices;
        if (oldIndices == null) {
            newIndices = new int[maxIndices.length];
            Arrays.fill(newIndices, 0);
        } else {
            int i;
            for (i = 0; i < newIndices.length; ++i) {
                int n = i;
                newIndices[n] = newIndices[n] + 1;
                if (newIndices[i] != maxIndices[i]) break;
                newIndices[i] = 0;
            }
            if (i == newIndices.length) {
                newIndices = null;
            }
        }
        return newIndices;
    }
}

