/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice.annotation.assignability;

import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aop.advice.annotation.assignability.VariableNode;

public class VariableHierarchy {
    private Map<String, VariableNode> map = new HashMap<String, VariableNode>();
    private int boundComparation;
    private int realBoundComparation;

    void finishBoundComparation() {
        --this.boundComparation;
    }

    void finishRealBoundComparation() {
        --this.realBoundComparation;
    }

    VariableNode getVariableNode(TypeVariable typeVariable) {
        String key = typeVariable.getName();
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        VariableNode node = new VariableNode(typeVariable, this);
        this.map.put(key, node);
        return node;
    }

    boolean isBoundComparation() {
        return this.boundComparation > 0;
    }

    boolean isRealBoundComparation() {
        return this.realBoundComparation > 0;
    }

    public void reset() {
        this.map.clear();
        this.boundComparation = 0;
        this.realBoundComparation = 0;
    }

    void startBoundComparation() {
        ++this.boundComparation;
    }

    void startRealBoundComparation() {
        ++this.realBoundComparation;
    }
}

