/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.View;

public class DocumentPrinting
implements Printable {
    protected int m_CurrentPage = -1;
    protected JTextPane m_PrintPane = new JTextPane();
    protected double m_PageEndY = 0.0;
    protected double m_PageStartY = 0.0;
    protected boolean m_ScaleWidthToFit = true;
    protected PageFormat m_PageFormat = new PageFormat();
    protected PrinterJob m_PrinterJob = PrinterJob.getPrinterJob();

    protected void pageDialog() {
        this.m_PageFormat = this.m_PrinterJob.pageDialog(this.m_PageFormat);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        double scale = 1.0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.m_PrintPane.setSize((int)pageFormat.getImageableWidth(), Integer.MAX_VALUE);
        this.m_PrintPane.validate();
        View rootView = this.m_PrintPane.getUI().getRootView(this.m_PrintPane);
        if (this.m_ScaleWidthToFit && this.m_PrintPane.getMinimumSize().getWidth() > pageFormat.getImageableWidth()) {
            scale = pageFormat.getImageableWidth() / this.m_PrintPane.getMinimumSize().getWidth();
            graphics2D.scale(scale, scale);
        }
        graphics2D.setClip((int)(pageFormat.getImageableX() / scale), (int)(pageFormat.getImageableY() / scale), (int)(pageFormat.getImageableWidth() / scale), (int)(pageFormat.getImageableHeight() / scale));
        if (pageIndex > this.m_CurrentPage) {
            this.m_CurrentPage = pageIndex;
            this.m_PageStartY += this.m_PageEndY;
            this.m_PageEndY = graphics2D.getClipBounds().getHeight();
        }
        graphics2D.translate(graphics2D.getClipBounds().getX(), graphics2D.getClipBounds().getY());
        Rectangle allocation = new Rectangle(0, (int)(-this.m_PageStartY), (int)this.m_PrintPane.getMinimumSize().getWidth(), (int)this.m_PrintPane.getPreferredSize().getHeight());
        if (this.printView(graphics2D, allocation, rootView)) {
            return 0;
        }
        this.m_PageStartY = 0.0;
        this.m_PageEndY = 0.0;
        this.m_CurrentPage = -1;
        return 1;
    }

    public void print(JTextPane pane) {
        this.setDocument(pane);
        this.printDialog();
    }

    public void printDialog() {
        if (this.m_PrinterJob.printDialog()) {
            this.m_PrinterJob.setPrintable(this, this.m_PageFormat);
            try {
                this.m_PrinterJob.print();
            }
            catch (PrinterException printerException) {
                this.m_PageStartY = 0.0;
                this.m_PageEndY = 0.0;
                this.m_CurrentPage = -1;
                System.out.println("Error Printing Document");
            }
        }
    }

    protected boolean printView(Graphics2D graphics2D, Shape allocation, View view) {
        boolean pageExists = false;
        Rectangle clipRectangle = graphics2D.getClipBounds();
        if (view.getViewCount() > 0) {
            for (int i = 0; i < view.getViewCount(); ++i) {
                View childView;
                Shape childAllocation = view.getChildAllocation(i, allocation);
                if (childAllocation == null || !this.printView(graphics2D, childAllocation, childView = view.getView(i))) continue;
                pageExists = true;
            }
        } else if (allocation.getBounds().getMaxY() >= clipRectangle.getY()) {
            pageExists = true;
            if (allocation.getBounds().getHeight() > clipRectangle.getHeight() && allocation.intersects(clipRectangle)) {
                view.paint(graphics2D, allocation);
            } else if (allocation.getBounds().getY() >= clipRectangle.getY()) {
                if (allocation.getBounds().getMaxY() <= clipRectangle.getMaxY()) {
                    view.paint(graphics2D, allocation);
                } else if (allocation.getBounds().getY() < this.m_PageEndY) {
                    this.m_PageEndY = allocation.getBounds().getY();
                }
            }
        }
        return pageExists;
    }

    public void setContentType(String type2) {
        this.m_PrintPane.setContentType(type2);
    }

    public Document getDocument() {
        if (this.m_PrintPane != null) {
            return this.m_PrintPane.getDocument();
        }
        return null;
    }

    public void setDocument(JTextPane pane) {
        this.m_PrintPane = new JTextPane();
        this.setDocument(pane.getContentType(), pane.getDocument());
    }

    public void setDocument(String type2, Document document) {
        this.setContentType(type2);
        this.m_PrintPane.setDocument(document);
    }

    public void setScaleWidthToFit(boolean scaleWidth) {
        this.m_ScaleWidthToFit = scaleWidth;
    }

    public boolean getScaleWidthToFit() {
        return this.m_ScaleWidthToFit;
    }
}

