/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import weka.gui.ComponentHelper;
import weka.gui.DatabaseConnectionDialog;
import weka.gui.ExtensionFileFilter;
import weka.gui.ListSelectorDialog;
import weka.gui.sql.DbUtils;
import weka.gui.sql.event.ConnectionEvent;
import weka.gui.sql.event.ConnectionListener;
import weka.gui.sql.event.HistoryChangedEvent;
import weka.gui.sql.event.HistoryChangedListener;

public class ConnectionPanel
extends JPanel
implements CaretListener {
    static final long serialVersionUID = 3499317023969723490L;
    public static final String HISTORY_NAME = "connection";
    protected JFrame m_Parent = null;
    protected DatabaseConnectionDialog m_DbDialog;
    protected String m_URL = "";
    protected String m_User = "";
    protected String m_Password = "";
    protected JLabel m_LabelURL = new JLabel("URL ");
    protected JTextField m_TextURL = new JTextField(40);
    protected JButton m_ButtonDatabase = new JButton(ComponentHelper.getImageIcon("user.png"));
    protected JButton m_ButtonConnect = new JButton(ComponentHelper.getImageIcon("connect.png"));
    protected JButton m_ButtonHistory = new JButton(ComponentHelper.getImageIcon("history.png"));
    protected JButton m_ButtonSetup = new JButton(ComponentHelper.getImageIcon("properties.gif"));
    protected HashSet m_ConnectionListeners;
    protected HashSet m_HistoryChangedListeners;
    protected DbUtils m_DbUtils;
    protected DefaultListModel m_History = new DefaultListModel();
    protected JFileChooser m_SetupFileChooser;

    public ConnectionPanel(JFrame parent) {
        this.m_Parent = parent;
        this.m_ConnectionListeners = new HashSet();
        this.m_HistoryChangedListeners = new HashSet();
        this.m_SetupFileChooser = new JFileChooser();
        this.m_SetupFileChooser.setDialogTitle("Switch database setup");
        this.m_SetupFileChooser.setFileSelectionMode(0);
        this.m_SetupFileChooser.setMultiSelectionEnabled(false);
        this.m_SetupFileChooser.setAcceptAllFileFilterUsed(true);
        ExtensionFileFilter filter = new ExtensionFileFilter(".props", "Properties file");
        this.m_SetupFileChooser.addChoosableFileFilter(filter);
        this.m_SetupFileChooser.setFileFilter(filter);
        try {
            this.m_DbUtils = new DbUtils();
            this.m_URL = this.m_DbUtils.getDatabaseURL();
            this.m_User = this.m_DbUtils.getUsername();
            this.m_Password = this.m_DbUtils.getPassword();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_URL = "";
            this.m_User = "";
            this.m_Password = "";
        }
        this.createPanel();
    }

    protected void createPanel() {
        this.setLayout(new BorderLayout());
        JPanel panel2 = new JPanel(new FlowLayout());
        this.add((Component)panel2, "West");
        this.m_LabelURL.setLabelFor(this.m_ButtonDatabase);
        this.m_LabelURL.setDisplayedMnemonic('U');
        panel2.add(this.m_LabelURL);
        this.m_TextURL.setText(this.m_URL);
        this.m_TextURL.addCaretListener(this);
        panel2.add(this.m_TextURL);
        JPanel panel = new JPanel(new FlowLayout());
        panel2.add(panel);
        this.m_ButtonDatabase.setToolTipText("Set user and password");
        this.m_ButtonDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionPanel.this.showDialog();
            }
        });
        panel.add(this.m_ButtonDatabase);
        this.m_ButtonConnect.setToolTipText("Connect to the database");
        this.m_ButtonConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionPanel.this.connect();
            }
        });
        panel.add(this.m_ButtonConnect);
        this.m_ButtonHistory.setToolTipText("Select a previously used connection");
        this.m_ButtonHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionPanel.this.showHistory();
            }
        });
        panel.add(this.m_ButtonHistory);
        this.m_ButtonSetup.setToolTipText("Switch database setup");
        this.m_ButtonSetup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionPanel.this.switchSetup();
            }
        });
        panel.add(this.m_ButtonSetup);
        this.setButtons();
    }

    protected void setButtons() {
        boolean isEmpty = this.m_TextURL.getText().equals("");
        this.m_ButtonConnect.setEnabled(!isEmpty);
        this.m_ButtonDatabase.setEnabled(!isEmpty);
        this.m_ButtonHistory.setEnabled(this.m_History.size() > 0);
        this.m_ButtonSetup.setEnabled(true);
    }

    public void clear() {
        this.setURL(this.m_DbUtils.getDatabaseURL());
        this.setUser(this.m_DbUtils.getUsername());
        this.setPassword(this.m_DbUtils.getPassword());
    }

    public void setFocus() {
        this.m_TextURL.requestFocus();
    }

    public void setURL(String url) {
        this.m_URL = url;
        this.m_TextURL.setText(url);
    }

    public String getURL() {
        this.m_URL = this.m_TextURL.getText();
        return this.m_URL;
    }

    public void setUser(String user) {
        this.m_User = user;
    }

    public String getUser() {
        return this.m_User;
    }

    public void setPassword(String pw) {
        this.m_Password = pw;
    }

    public String getPassword() {
        return this.m_Password;
    }

    protected void addHistory(String s) {
        if (s.equals("")) {
            return;
        }
        if (this.m_History.contains(s)) {
            this.m_History.removeElement(s);
        }
        this.m_History.add(0, s);
        this.notifyHistoryChangedListeners();
    }

    public void setHistory(DefaultListModel history) {
        this.m_History.clear();
        for (int i = 0; i < history.size(); ++i) {
            this.m_History.addElement(history.get(i));
        }
        this.setButtons();
    }

    public DefaultListModel getHistory() {
        return this.m_History;
    }

    protected void showDialog() {
        this.m_DbDialog = new DatabaseConnectionDialog((Frame)this.m_Parent, this.getURL(), this.getUser(), false);
        this.m_DbDialog.setVisible(true);
        if (this.m_DbDialog.getReturnValue() == 0) {
            this.setURL(this.m_DbDialog.getURL());
            this.setUser(this.m_DbDialog.getUsername());
            this.setPassword(this.m_DbDialog.getPassword());
        }
        this.setButtons();
    }

    protected void connect() {
        if (this.m_DbUtils.isConnected()) {
            try {
                this.m_DbUtils.disconnectFromDatabase();
                this.notifyConnectionListeners(1);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.notifyConnectionListeners(1, e);
            }
        }
        try {
            this.m_DbUtils.setDatabaseURL(this.getURL());
            this.m_DbUtils.setUsername(this.getUser());
            this.m_DbUtils.setPassword(this.getPassword());
            this.m_DbUtils.connectToDatabase();
            this.notifyConnectionListeners(0);
            this.addHistory(this.getUser() + "@" + this.getURL());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.notifyConnectionListeners(0, e);
        }
        this.setButtons();
    }

    public void showHistory() {
        JList list = new JList(this.m_History);
        ListSelectorDialog dialog = new ListSelectorDialog((Frame)this.m_Parent, list);
        if (dialog.showDialog() == 0 && list.getSelectedValue() != null) {
            String tmpStr = list.getSelectedValue().toString();
            if (tmpStr.indexOf("@") > -1) {
                this.setUser(tmpStr.substring(0, tmpStr.indexOf("@")));
                this.setURL(tmpStr.substring(tmpStr.indexOf("@") + 1));
                this.showDialog();
            } else {
                this.setUser("");
                this.setURL(tmpStr);
            }
        }
        this.setButtons();
    }

    public void switchSetup() {
        int retVal = this.m_SetupFileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        this.m_DbUtils.initialize(this.m_SetupFileChooser.getSelectedFile());
        this.m_URL = this.m_DbUtils.getDatabaseURL();
        this.m_User = this.m_DbUtils.getUsername();
        this.m_Password = this.m_DbUtils.getPassword();
        this.m_TextURL.setText(this.m_URL);
    }

    public void addConnectionListener(ConnectionListener l) {
        this.m_ConnectionListeners.add(l);
    }

    public void removeConnectionListener(ConnectionListener l) {
        this.m_ConnectionListeners.remove(l);
    }

    protected void notifyConnectionListeners(int type2) {
        this.notifyConnectionListeners(type2, null);
    }

    protected void notifyConnectionListeners(int type2, Exception ex) {
        for (ConnectionListener l : this.m_ConnectionListeners) {
            l.connectionChange(new ConnectionEvent(this, type2, this.m_DbUtils, ex));
        }
    }

    public void addHistoryChangedListener(HistoryChangedListener l) {
        this.m_HistoryChangedListeners.add(l);
    }

    public void removeHistoryChangedListener(HistoryChangedListener l) {
        this.m_HistoryChangedListeners.remove(l);
    }

    protected void notifyHistoryChangedListeners() {
        for (HistoryChangedListener l : this.m_HistoryChangedListeners) {
            l.historyChanged(new HistoryChangedEvent(this, HISTORY_NAME, this.getHistory()));
        }
    }

    @Override
    public void caretUpdate(CaretEvent event) {
        this.setButtons();
    }
}

