/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.art.ont_indexer;

import it.uniroma2.art.ont_indexer.index.IndexManager;
import it.uniroma2.art.ont_indexer.search.OntIndexSearcher;
import it.uniroma2.art.owlart.exceptions.ModelAccessException;
import it.uniroma2.art.owlart.model.ARTURIResource;
import it.uniroma2.art.owlart.models.OWLModel;
import it.uniroma2.art.owlart.navigation.ARTURIResourceIterator;
import it.uniroma2.art.owlart.vocabulary.RDFS;
import it.uniroma2.art.owlart.vocabulary.VocabularyTypesEnum;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyIndexer {
    public OWLModel m;
    private Collection<String> languages;
    private IndexManager ontIndexManager;
    private OntIndexSearcher ontSearcher;
    private Collection<String> URILangs;
    public static VocabularyTypesEnum[] allTypes = new VocabularyTypesEnum[3];
    protected static Logger logger;

    public OntologyIndexer(OWLModel m, String IndexDir, Collection<String> languages, Collection<String> URILangs) {
        this.m = m;
        this.languages = languages;
        this.URILangs = URILangs;
        this.ontIndexManager = new IndexManager(m, IndexDir, URILangs, languages);
    }

    public OntIndexSearcher buildIndex(boolean create, VocabularyTypesEnum ... enums) throws ModelAccessException, IOException {
        OntIndexSearcher searcher;
        this.ontIndexManager.buildIndex(create, enums);
        this.ontSearcher = searcher = new OntIndexSearcher(this.ontIndexManager, this.URILangs);
        return searcher;
    }

    public OntIndexSearcher buildCustomIndex(String idxID, ARTURIResourceIterator resourcesIterator, boolean create) throws ModelAccessException, IOException {
        return this.buildCustomIndex(idxID, resourcesIterator, RDFS.Res.LABEL, create);
    }

    public OntIndexSearcher buildCustomIndex(String idxID, ARTURIResourceIterator resourcesIterator, ARTURIResource predicate, boolean create) throws ModelAccessException, IOException {
        OntIndexSearcher searcher;
        this.ontIndexManager.buildIndex(idxID, resourcesIterator, predicate, create);
        this.ontSearcher = searcher = new OntIndexSearcher(this.ontIndexManager, this.URILangs);
        return searcher;
    }

    public OntIndexSearcher createOntIndexSearcher() throws IOException {
        OntIndexSearcher searcher;
        this.ontSearcher = searcher = new OntIndexSearcher(this.ontIndexManager, this.URILangs);
        logger.debug("ontsearcher set " + this.ontSearcher);
        return searcher;
    }

    public double getTHRESHOLD() {
        return Double.parseDouble(this.ontSearcher.getTHRESHOLD());
    }

    public void setTHRESHOLD(double threshold) {
        this.ontSearcher.setTHRESHOLD(Double.toString(threshold));
    }

    public Collection<ARTURIResource> findClasses(String searchString, String lang, int strategy) {
        logger.debug(this.ontSearcher + "  looking for classes");
        return this.ontSearcher.findClses(this.m, searchString, lang, strategy);
    }

    public Collection<ARTURIResource> findProperties(String label, String lang, int strategy) {
        return this.ontSearcher.findProperties(this.m, label, lang, strategy);
    }

    public Collection<ARTURIResource> findIndividuals(String label, String lang, int strategy) {
        return this.ontSearcher.findIndividuals(this.m, label, lang, strategy);
    }

    public Collection<ARTURIResource> findResourcesForIndex(String indexID, String label, String lang, int strategy) {
        return this.ontSearcher.findResources(this.m, indexID, label, lang, strategy);
    }

    public Collection<String> findLabelsForType(VocabularyTypesEnum type, String label, String lang, int strategy) {
        return this.ontSearcher.findLabels(this.m, type.toString(), label, lang, strategy);
    }

    public Collection<String> findLabelsForIndex(String indexID, String label, String lang, int strategy) {
        return this.ontSearcher.findLabels(this.m, indexID, label, lang, strategy);
    }

    public IndexManager getIndexManager() {
        return this.ontIndexManager;
    }

    public void initializeStandardIndexWriters(VocabularyTypesEnum ... ontTypes) throws IOException {
        this.ontIndexManager.initializeStandardIndexWriters(ontTypes);
    }

    public void initializeCustomIndexWriters(Collection<String> idxIdentifiers) throws IOException {
        this.ontIndexManager.initializeCustomIndexWriters(idxIdentifiers);
    }

    static {
        OntologyIndexer.allTypes[0] = VocabularyTypesEnum.cls;
        OntologyIndexer.allTypes[1] = VocabularyTypesEnum.property;
        OntologyIndexer.allTypes[2] = VocabularyTypesEnum.individual;
        logger = LoggerFactory.getLogger(OntologyIndexer.class);
    }
}

