/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.art.ont_indexer.analysis;

import it.uniroma2.art.ont_indexer.analysis.SynonymEngine;
import java.io.IOException;
import java.util.Stack;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class SynonymFilter
extends TokenFilter {
    public static final String TOKEN_TYPE_SYNONYM = "SYNONYM";
    private Stack synonymStack = new Stack();
    private SynonymEngine engine;

    public SynonymFilter(TokenStream in, SynonymEngine engine) {
        super(in);
        this.engine = engine;
    }

    public Token next() throws IOException {
        if (this.synonymStack.size() > 0) {
            return (Token)this.synonymStack.pop();
        }
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        this.addAliasesToStack(token);
        return token;
    }

    private void addAliasesToStack(Token token) throws IOException {
        String[] synonyms = this.engine.getSynonyms(token.termText());
        if (synonyms == null) {
            return;
        }
        for (int i = 0; i < synonyms.length; ++i) {
            Token synToken = new Token(synonyms[i], token.startOffset(), token.endOffset(), TOKEN_TYPE_SYNONYM);
            synToken.setPositionIncrement(0);
            this.synonymStack.push(synToken);
        }
    }
}

