/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.art.ont_indexer.index;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import it.uniroma2.art.ont_indexer.OntologyIndexer;
import it.uniroma2.art.ont_indexer.analysis.GenericAnalyzer;
import it.uniroma2.art.ont_indexer.index.AnalyzerMap;
import it.uniroma2.art.ont_indexer.index.IndexWriterMap;
import it.uniroma2.art.ont_indexer.lucene.util.Util;
import it.uniroma2.art.owlart.exceptions.ModelAccessException;
import it.uniroma2.art.owlart.filter.DesiredLanguageLabelPredicate;
import it.uniroma2.art.owlart.model.ARTLiteral;
import it.uniroma2.art.owlart.model.ARTResource;
import it.uniroma2.art.owlart.model.ARTURIResource;
import it.uniroma2.art.owlart.models.OWLModel;
import it.uniroma2.art.owlart.navigation.ARTLiteralIterator;
import it.uniroma2.art.owlart.navigation.ARTURIResourceIterator;
import it.uniroma2.art.owlart.vocabulary.RDFS;
import it.uniroma2.art.owlart.vocabulary.VocabularyTypesEnum;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexManager {
    private String idxFieldLocalName = "localName";
    private String idxFieldURI = "URI";
    private static final Logger logger = Logger.getLogger(OntologyIndexer.class);
    private boolean inference;
    private Collection<String> languages;
    private Collection<String> URILangs;
    private String indexDir;
    private OWLModel model;
    IndexWriterMap idxWritersMap;
    AnalyzerMap idxAnalyzerMap;

    public IndexManager(OWLModel m, String IndexDir, Collection<String> URILangs, Collection<String> languages) {
        this.indexDir = IndexDir;
        this.model = m;
        this.inference = false;
        this.URILangs = URILangs;
        this.languages = languages;
        this.idxWritersMap = new IndexWriterMap();
        this.idxAnalyzerMap = new AnalyzerMap();
    }

    public void initializeStandardIndexWriters(VocabularyTypesEnum ... ontTypes) throws IOException {
        if (ontTypes.length == 0) {
            ontTypes = OntologyIndexer.allTypes;
        }
        for (VocabularyTypesEnum type : ontTypes) {
            this.initializeWritersAndAnalyzersMap(type.toString(), this.languages, false);
        }
    }

    public void initializeCustomIndexWriters(Collection<String> idxIdentifiers) throws IOException {
        for (String idxIdentifier : idxIdentifiers) {
            this.initializeWritersAndAnalyzersMap(idxIdentifier, this.languages, false);
        }
    }

    public void buildIndex(boolean create, VocabularyTypesEnum ... ontTypes) throws IOException, ModelAccessException {
        if (ontTypes.length == 0) {
            ontTypes = OntologyIndexer.allTypes;
        }
        for (VocabularyTypesEnum type : ontTypes) {
            ARTURIResourceIterator resourcesIterator = type == VocabularyTypesEnum.cls ? this.model.listNamedClasses(this.inference, new ARTResource[0]) : (type == VocabularyTypesEnum.property ? this.model.listProperties(new ARTResource[0]) : this.model.listNamedInstances(new ARTResource[0]));
            this.buildIndexForResources(type.toString(), resourcesIterator, RDFS.Res.LABEL, create);
            logger.debug((Object)(type + " INDEX BUILT"));
        }
    }

    public void buildIndex(String idxIdentifier, ARTURIResourceIterator resourcesIterator, ARTURIResource predicate, boolean create) throws IOException, ModelAccessException {
        this.buildIndexForResources(idxIdentifier, resourcesIterator, predicate, create);
        logger.debug((Object)(idxIdentifier + " INDEX BUILT"));
    }

    protected String getIndexIdentifier(VocabularyTypesEnum type) {
        return type.toString();
    }

    protected String getIndexIdentifier(String idxIdentifier, String lang) {
        return idxIdentifier + "_" + lang;
    }

    protected String getIndexIdentifier(VocabularyTypesEnum type, String lang) {
        return this.getIndexIdentifier(type.toString(), lang);
    }

    public String getBaseIndexDir() {
        return this.indexDir;
    }

    public String getIndexDirByIndexId(String idxIdentifier) {
        return this.indexDir + "/" + idxIdentifier;
    }

    public String getIndexDirForTypeResources(VocabularyTypesEnum type) {
        return this.getIndexDirByIndexId(this.getIndexIdentifier(type));
    }

    public String getLangIndexDirForTypeLabels(String idxIdentifier, String lang) {
        return this.getIndexDirByIndexId(this.getIndexIdentifier(idxIdentifier, lang));
    }

    public String getLangIndexDirForTypeLabels(VocabularyTypesEnum type, String lang) {
        return this.getIndexDirByIndexId(this.getIndexIdentifier(type.toString(), lang));
    }

    public IndexWriter getIndexWriter(String idxIdentifier) {
        return (IndexWriter)this.idxWritersMap.get(idxIdentifier);
    }

    public IndexWriter getIndexWriter(String idxIdentifier, String lang) {
        return (IndexWriter)this.idxWritersMap.get(idxIdentifier, lang);
    }

    public IndexWriter getIndexWriter(VocabularyTypesEnum type, String lang) {
        return this.getIndexWriter(type.toString(), lang);
    }

    public Analyzer getIndexAnalyer(String lang) {
        return (Analyzer)this.idxAnalyzerMap.get(lang);
    }

    public Analyzer prepareSuitableAnalyzer(String lang) {
        Analyzer analyzer = Util.getSuitableAnalyzer(lang);
        this.idxAnalyzerMap.put(lang, analyzer);
        return analyzer;
    }

    private void buildIndexForResources(String idxIdentifier, ARTURIResourceIterator resourcesIterator, ARTURIResource property, boolean create) throws IOException, ModelAccessException {
        this.initializeWritersAndAnalyzersMap(idxIdentifier, this.languages, create);
        IndexWriter mainWriter = this.getIndexWriter(idxIdentifier);
        int i = 0;
        while (resourcesIterator.hasNext()) {
            logger.info((Object)("resource #" + ++i));
            ARTURIResource ontResource = (ARTURIResource)resourcesIterator.next();
            Document resIdx = new Document();
            logger.debug((Object)("checking stuff to add for resurce: " + ontResource));
            resIdx.add(new Field("URI", ontResource.getURI(), Field.Store.YES, Field.Index.UN_TOKENIZED));
            resIdx.add(new Field("localName", ontResource.getLocalName(), Field.Store.YES, Field.Index.TOKENIZED));
            mainWriter.addDocument(resIdx);
            for (String lang : this.languages) {
                logger.debug((Object)("checking language: " + lang + " for: " + ontResource));
                IndexWriter writer = (IndexWriter)this.idxWritersMap.get(idxIdentifier, lang);
                ARTLiteralIterator labelsIterator = this.model.listValuesOfSubjDTypePropertyPair((ARTResource)ontResource, property, false, new ARTResource[0]);
                UnmodifiableIterator filteredLangIt = Iterators.filter((Iterator)labelsIterator, (Predicate)new DesiredLanguageLabelPredicate(lang));
                if (filteredLangIt.hasNext()) {
                    resIdx = new Document();
                    resIdx.add(new Field("URI", ontResource.getURI(), Field.Store.YES, Field.Index.UN_TOKENIZED));
                    logger.debug((Object)("ontresource: " + ontResource.getURI()));
                    resIdx.add(new Field("localName", ontResource.getLocalName(), Field.Store.YES, Field.Index.TOKENIZED));
                    logger.debug((Object)("localname: " + ontResource.getLocalName()));
                    String termVector = ((ARTLiteral)filteredLangIt.next()).getLabel();
                    logger.debug((Object)("term vector: " + termVector));
                    while (filteredLangIt.hasNext()) {
                        logger.debug((Object)"fino a qui: ");
                        termVector = termVector + " " + ((ARTLiteral)filteredLangIt.next()).getLabel();
                    }
                    resIdx.add(new Field(lang, termVector, Field.Store.YES, Field.Index.TOKENIZED));
                    logger.debug((Object)("adding: " + termVector));
                }
                writer.addDocument(resIdx);
                labelsIterator.close();
            }
        }
        mainWriter.optimize();
        mainWriter.close();
        for (String lang : this.languages) {
            IndexWriter idxWriter = (IndexWriter)this.idxWritersMap.get(idxIdentifier, lang);
            idxWriter.optimize();
            idxWriter.close();
        }
        logger.debug((Object)"indexbuilt");
    }

    private void initializeWritersAndAnalyzersMap(String idxIdentifier, Collection<String> languages, boolean create) throws IOException {
        logger.debug((Object)("initializing writers and analyzers for: " + idxIdentifier));
        IndexWriter idxWrt = (IndexWriter)this.idxWritersMap.get(idxIdentifier);
        if (idxWrt != null) {
            logger.debug((Object)(idxIdentifier + " writer already present, trying to close it..."));
            idxWrt.close();
        }
        GenericAnalyzer analyzer = new GenericAnalyzer();
        this.idxAnalyzerMap.put(idxIdentifier, analyzer);
        File indexDir = new File(this.getIndexDirByIndexId(idxIdentifier));
        if (!indexDir.exists()) {
            create = true;
        }
        idxWrt = new IndexWriter(indexDir, (Analyzer)analyzer, create);
        this.idxWritersMap.put(idxIdentifier, idxWrt);
        idxWrt.close();
        logger.debug((Object)("generic writer initialized for: " + idxIdentifier));
        logger.debug((Object)("now initializing writers for languages: " + languages));
        for (String lang : languages) {
            idxWrt = (IndexWriter)this.idxWritersMap.get(idxIdentifier, lang);
            if (idxWrt != null) {
                logger.debug((Object)(this.getIndexIdentifier(idxIdentifier, lang) + " language writer already present, trying to close it..."));
                idxWrt.close();
            }
            if ((analyzer = (Analyzer)this.idxAnalyzerMap.get(lang)) == null) {
                analyzer = this.prepareSuitableAnalyzer(lang);
            }
            idxWrt = new IndexWriter(indexDir, (Analyzer)analyzer, !(indexDir = new File(this.getLangIndexDirForTypeLabels(idxIdentifier, lang))).exists() ? true : create);
            this.idxWritersMap.put(idxIdentifier, lang, idxWrt);
            idxWrt.close();
            logger.debug((Object)("writer for language: " + lang + " initialized for base index: " + idxIdentifier));
        }
        logger.debug((Object)"all index managers have been initialized");
    }

    public IndexWriterMap getIdxWritersMap() {
        return this.idxWritersMap;
    }

    public void addNewClassToIndex(ARTURIResource cls) throws IOException {
        this.addNewResourceToIndex(cls, VocabularyTypesEnum.cls.toString());
    }

    public void addNewPropertyToIndex(ARTURIResource prop) throws IOException {
        this.addNewResourceToIndex(prop, VocabularyTypesEnum.property.toString());
    }

    public void addNewIndividualToIndex(ARTURIResource ind) throws IOException {
        this.addNewResourceToIndex(ind, VocabularyTypesEnum.individual.toString());
    }

    public void addNewResourceToIndex(ARTURIResource ontResource, String idxIdentifier) throws IOException {
        Document resIdx = new Document();
        logger.debug((Object)("checking stuff to add for resurce: " + ontResource));
        resIdx.add(new Field(this.idxFieldURI, ontResource.getURI(), Field.Store.YES, Field.Index.UN_TOKENIZED));
        resIdx.add(new Field(this.idxFieldLocalName, ontResource.getLocalName(), Field.Store.YES, Field.Index.TOKENIZED));
        IndexWriter mainWriter = this.getIndexWriter(idxIdentifier);
        logger.debug((Object)("main Writer: " + mainWriter.getDirectory()));
        mainWriter.addDocument(resIdx);
        mainWriter.close();
    }

    protected void deleteResourceFromMainIndex(ARTURIResource ontResource, String idxIdentifier) throws IOException {
        IndexReader idxReader = IndexReader.open((String)this.getIndexDirByIndexId(idxIdentifier));
        idxReader.deleteDocuments(new Term(this.idxFieldURI, ontResource.getURI()));
        idxReader.close();
    }

    protected void deleteResourceFromLangIndex(ARTURIResource ontResource, String idxIdentifier, String lang) throws IOException {
        IndexReader idxReader = IndexReader.open((String)this.getLangIndexDirForTypeLabels(idxIdentifier, lang));
        idxReader.deleteDocuments(new Term(this.idxFieldURI, ontResource.getURI()));
        idxReader.close();
    }

    public void deleteResourceFromIndexes(ARTURIResource ontResource, String idxIdentifier) throws IOException {
        this.deleteResourceFromMainIndex(ontResource, idxIdentifier);
        for (String lang : this.languages) {
            this.deleteResourceFromLangIndex(ontResource, idxIdentifier, lang);
        }
    }

    public void deleteClassFromIndexes(ARTURIResource ontResource) throws IOException {
        this.deleteResourceFromIndexes(ontResource, VocabularyTypesEnum.cls.toString());
    }

    public void deletePropertyFromIndexes(ARTURIResource ontResource) throws IOException {
        this.deleteResourceFromIndexes(ontResource, VocabularyTypesEnum.property.toString());
    }

    public void deleteIndividualFromIndexes(ARTURIResource ontResource) throws IOException {
        this.deleteResourceFromIndexes(ontResource, VocabularyTypesEnum.individual.toString());
    }

    public void updateLangIndexForClass(ARTURIResource ontResource, String lang) throws IOException, ModelAccessException {
        this.updateLangIndexForResource(ontResource, VocabularyTypesEnum.cls.toString(), lang);
    }

    public void updateLangIndexForProperty(ARTURIResource ontResource, String lang) throws IOException, ModelAccessException {
        this.updateLangIndexForResource(ontResource, VocabularyTypesEnum.property.toString(), lang);
    }

    public void updateLangIndexForIndividual(ARTURIResource ontResource, String lang) throws IOException, ModelAccessException {
        this.updateLangIndexForResource(ontResource, VocabularyTypesEnum.individual.toString(), lang);
    }

    public void updateLangIndexForResource(ARTURIResource ontResource, ARTURIResource property, String idxIdentifier, String lang) throws IOException, ModelAccessException {
        logger.debug((Object)("updating resource: " + ontResource + " language content for" + lang));
        this.deleteResourceFromLangIndex(ontResource, idxIdentifier, lang);
        Document resIdx = new Document();
        IndexWriter writer = (IndexWriter)this.idxWritersMap.get(idxIdentifier, lang);
        ARTLiteralIterator labelsIterator = this.model.listValuesOfSubjDTypePropertyPair((ARTResource)ontResource, property, this.inference, new ARTResource[0]);
        UnmodifiableIterator filteredLangIt = Iterators.filter((Iterator)labelsIterator, (Predicate)new DesiredLanguageLabelPredicate(lang));
        if (filteredLangIt.hasNext()) {
            resIdx = new Document();
            resIdx.add(new Field("URI", ontResource.getURI(), Field.Store.YES, Field.Index.UN_TOKENIZED));
            logger.debug((Object)("ontresource: " + ontResource.getURI()));
            resIdx.add(new Field("localName", ontResource.getLocalName(), Field.Store.YES, Field.Index.TOKENIZED));
            logger.debug((Object)("localname: " + ontResource.getLocalName()));
            String termVector = ((ARTLiteral)filteredLangIt.next()).getLabel();
            logger.debug((Object)("term vector: " + termVector));
            while (filteredLangIt.hasNext()) {
                logger.debug((Object)"fino a qui: ");
                termVector = termVector + " " + ((ARTLiteral)filteredLangIt.next()).getLabel();
            }
            resIdx.add(new Field(lang, termVector, Field.Store.YES, Field.Index.TOKENIZED));
            logger.debug((Object)("adding: " + termVector));
        }
        writer.addDocument(resIdx);
        labelsIterator.close();
        writer.close();
    }

    public void updateLangIndexForResource(ARTURIResource ontResource, String idxIdentifier, String lang) throws IOException, ModelAccessException {
        this.updateLangIndexForResource(ontResource, RDFS.Res.LABEL, idxIdentifier, lang);
    }
}

