/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.art.ont_indexer.search;

import it.uniroma2.art.ont_indexer.OntologyIndexer;
import it.uniroma2.art.ont_indexer.index.IndexManager;
import it.uniroma2.art.owlart.model.ARTURIResource;
import it.uniroma2.art.owlart.models.OWLModel;
import it.uniroma2.art.owlart.vocabulary.VocabularyTypesEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.WildcardQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntIndexSearcher {
    public static final int EXACT_STRATEGY = 1;
    public static final int SIMILARITY_STRATEGY = 2;
    private String THRESHOLD = "0.9";
    String IndexDir;
    protected static Logger logger = LoggerFactory.getLogger(OntologyIndexer.class);
    private Collection<String> URILangs;
    private IndexManager idxMgr;

    public OntIndexSearcher(IndexManager idxMgr, Collection<String> URILangs) {
        this.idxMgr = idxMgr;
        this.URILangs = URILangs;
    }

    public Collection<ARTURIResource> findResources(OWLModel m, String indexID, String name, String lang, int strategy) {
        Collection<String> standardCollection = this.search(name, lang, indexID, strategy, TargetOfSearch.RESOURCES);
        logger.debug("results: " + standardCollection);
        ArrayList<ARTURIResource> result = new ArrayList<ARTURIResource>();
        Iterator<String> it = standardCollection.iterator();
        while (it.hasNext()) {
            ARTURIResource ontResource = m.createURIResource(it.next());
            logger.debug(indexID + " found: " + ontResource);
            result.add(ontResource);
        }
        logger.debug("\n");
        return result;
    }

    public Collection<String> findLabels(OWLModel m, String indexID, String name, String lang, int strategy) {
        return this.search(name, lang, indexID, strategy, TargetOfSearch.LABELS);
    }

    public Collection<ARTURIResource> findClses(OWLModel m, String name, String lang, int strategy) {
        return this.findResources(m, VocabularyTypesEnum.cls.toString(), name, lang, strategy);
    }

    public Collection<ARTURIResource> findProperties(OWLModel m, String name, String lang, int strategy) {
        return this.findResources(m, VocabularyTypesEnum.property.toString(), name, lang, strategy);
    }

    public Collection<ARTURIResource> findIndividuals(OWLModel m, String name, String lang, int strategy) {
        return this.findResources(m, VocabularyTypesEnum.individual.toString(), name, lang, strategy);
    }

    public Collection<String> search(String name, String lang, String indexID, int strategy, TargetOfSearch srcTgt) {
        if (strategy == 2) {
            name = name + "~" + this.THRESHOLD;
        }
        String indexDir = this.idxMgr.getLangIndexDirForTypeLabels(indexID, lang);
        Analyzer analyzer = this.idxMgr.getIndexAnalyer(lang);
        if (analyzer == null) {
            logger.debug("analyzer not available from indexManager, recreating it");
            analyzer = this.idxMgr.prepareSuitableAnalyzer(lang);
        }
        IndexSearcher searcher = null;
        try {
            if (this.URILangs.contains("I would temporaneously remove this case. I do not need a MultiSearcher")) {
                logger.debug("entering multiindex search:");
                IndexSearcher labelSearcher = new IndexSearcher(indexDir);
                String localNamesIndexDir = null;
                IndexSearcher nameSearcher = new IndexSearcher(localNamesIndexDir);
                Searcher[] searchersArray = new Searcher[]{labelSearcher, nameSearcher};
                searcher = new MultiSearcher((Searchable[])searchersArray);
            } else {
                logger.debug("entering single search:");
                searcher = new IndexSearcher(indexDir);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<String> result = new ArrayList<String>();
        String queryString = name;
        if (this.URILangs.contains(lang)) {
            queryString = queryString + " OR localName:" + name;
        }
        WildcardQuery query = null;
        if (name.startsWith("*")) {
            if (name.contains(" ")) {
                BooleanQuery b = new BooleanQuery();
                String[] tokens = name.split(" ");
                for (int i = 0; i < tokens.length; ++i) {
                    String token = tokens[i];
                    if (token.contains("*")) {
                        b.add((Query)new WildcardQuery(new Term(lang, token)), BooleanClause.Occur.MUST);
                        continue;
                    }
                    QueryParser queryParser = new QueryParser(lang, analyzer);
                    try {
                        b.add(queryParser.parse(token), BooleanClause.Occur.MUST);
                        continue;
                    }
                    catch (ParseException e1) {
                        e1.printStackTrace();
                    }
                }
                query = b;
            } else {
                query = new WildcardQuery(new Term(lang, queryString));
            }
        } else {
            QueryParser queryParser = new QueryParser(lang, analyzer);
            try {
                if (name.contains("*")) {
                    queryParser.setDefaultOperator(QueryParser.Operator.AND);
                }
                query = queryParser.parse(queryString);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
        }
        logger.debug("\nSEARCHING FOR: " + name);
        logger.debug("query is: " + query.toString("text"));
        Hits hits = null;
        try {
            hits = searcher.search((Query)query);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.debug("NUMBER OF MATCHING CONTACTS: " + hits.length());
        for (int j = 0; j < hits.length(); ++j) {
            try {
                if (srcTgt == TargetOfSearch.LABELS) {
                    result.add(hits.doc(j).get(lang));
                    continue;
                }
                result.add(hits.doc(j).get("URI"));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        logger.debug("end of search");
        return result;
    }

    public String getTHRESHOLD() {
        return this.THRESHOLD;
    }

    public void setTHRESHOLD(String threshold) {
        this.THRESHOLD = threshold;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TargetOfSearch {
        LABELS,
        RESOURCES;

    }
}

