(ns fogus.thneed.mm)

(defmacro defmethod-explicit
  [multifn dispatch-val & fn-tail]
  (let [[kw n & body] fn-tail]
    (if (= :as kw)
      `(. ~(with-meta multifn {:tag 'clojure.lang.MultiFn}) 
          addMethod 
          ~dispatch-val 
          (let [~n ~dispatch-val] (fn ~@body)))
      `(. ~(with-meta multifn {:tag 'clojure.lang.MultiFn}) 
          addMethod 
          ~dispatch-val 
          (fn ~@fn-tail)))))

(comment
  (defmulti expl-mm (juxt first second))
  (defmethod-explicit expl-mm [1 2] :as x [s] (str x))
  (defmethod-explicit expl-mm [3 4] [s] (reverse s))

  (expl-mm [1 2])
                                        ;=> "[1 2]"

  (expl-mm [3 4])
                                        ;=> (4 3)
  )

(defmacro defmethod-anaphoric
  [multifn dispatch-val & fn-tail]
  `(. ~(with-meta multifn {:tag 'clojure.lang.MultiFn}) 
      addMethod 
      ~dispatch-val
      (let [~'$ ~dispatch-val]
        (fn ~@fn-tail))))
(comment
  (defmulti a-mm (juxt first second))
  (defmethod-anaphoric a-mm [1 2] [_] (str $))
  (defmethod-anaphoric a-mm [3 4] [s] (reverse s))
  (a-mm [1 2])
                                        ;=> [[1 2] ---> {1 2}]

  (a-mm [3 4])
                                        ;=> (4 3)


  (defmulti repeating-mm (juxt first second))
  (defmethod repeating-mm [1 2] [s] (apply hash-map [1 2]))
  (repeating-mm (range 1 10))
)
