(ns app-2.core
  (:require [clojure.string :refer [join]]))

(def images-url "images.ona.io")

(def hosts
  "Store remote hosts that requests are made to."
  (atom {:images images-url
  	      :request-protocol "https"}))

(defn protocol-prefixed
  "Prefix the resources with the protocol and format strings."
  [resources]
  (-> [(:request-protocol @hosts) "://" resources]
      flatten
      join))

(def thumbor-server (protocol-prefixed (:images @hosts)))

(defn -main
  "I don't do a whole lot ... yet."
  [& args]
  (println "Hello, World!"))
