(ns jamesmacaulay.zelkova.window
  "This namespace provides window-related signals."
  (:refer-clojure :exclude [meta])
       
                                                
                                                        
                                           
        
  (:require [jamesmacaulay.zelkova.signal :as z]
            [jamesmacaulay.zelkova.impl.signal :as impl]
            [jamesmacaulay.async-tools.core :as tools]
            [goog.events :as events]
            [cljs.core.async :as async :refer [>! <!]])
        
  (:require-macros [cljs.core.async.macros :refer [go go-loop]]))

      
(defn- listen
  [el type & args]
  (let [out (apply async/chan 1 args)]
    (events/listen el type (fn [e] (async/put! out e)))
    out))

(defn- get-size
  [opts]
        
  (let [node (or (:dom-node opts) (.-body js/document))
        w (.-clientWidth node)
        h (.-clientHeight node)]
    [w h])
       
           )

(defn- dimensions-channel
  [graph opts]
        
  (listen js/window "resize" (map #(get-size opts)))
       
              )

(def ^:private dimensions-events-fn
  (impl/value-source->events-fn dimensions-channel ::dimensions))

(def ^{:doc "A signal of `[x y]` vectors representing the current dimensions of
the window."}
  dimensions
  (impl/make-signal {:init-fn (fn [_ opts] (get-size opts))
                     :relayed-event-topic ::dimensions
                     :event-sources {::dimensions dimensions-events-fn}}))

(def ^{:doc "A signal of the current width of the window."}
  width
  (z/map first dimensions))

(def ^{:doc "A signal of the current height of the window."}
  height
  (z/map second dimensions))

;;;;;;;;;;;; This file autogenerated from src/cljx/jamesmacaulay/zelkova/window.cljx
