(ns chord.channels
  (:require       [org.httpkit.server :as http]
            
                  [clojure.core.async :refer [chan <! >! put! close! go-loop]]
                                                                    

                  [clojure.core.async.impl.protocols :as p]
                                                         )

                                                                    )

(defn read-from-ws! [ws ch]
       
  (http/on-receive ws #(put! ch {:message %}))

        
                        
                
                                    
                                           )

(defn write-to-ws! [ws ch]
  (go-loop []
    (let [msg (<! ch)]
      (when msg
              (http/send! ws msg)
                             
        (recur)))))

(defn bidi-ch [read-ch write-ch & [{:keys [on-close]}]]
  (reify
    p/ReadPort
    (take! [_ handler]
      (p/take! read-ch handler))

    p/WritePort
    (put! [_ msg handler]
      (p/put! write-ch msg handler))

    p/Channel
    (close! [_]
      (p/close! read-ch)
      (p/close! write-ch)
      (when on-close
        (on-close)))))

;;;;;;;;;;;; This file autogenerated from src/chord/channels.cljx
