(ns flow.el
  (:require                                                          
                   [cljs.core.async :as a]
                   [dommy.core :as d]
            [clojure.data :refer [diff]]
            [clojure.set :as set]
            [flow.stream :refer [nil-sentinel stream-ch]])

        
  (:require-macros [dommy.macros :refer [node sel1]]
                   [cljs.core.async.macros :refer [go go-loop alt!]]))

      
(defn- new-container []
  (node [:div {:style {:display "inline"}}]))

      
(defn- update-els! [$container old-els new-els]
  (d/replace-contents! $container new-els))

      
(defn el<< [el-stream]
  (let [$container (new-container)
        el-ch (stream-ch el-stream (a/chan) #(a/sliding-buffer 1))]
    
    (go-loop [old-els nil]
      (when-let [$el (a/<! el-ch)]
        (if (:flow/ids (meta $el))
          (let [els $el]
            (update-els! $container old-els els)
            (recur els))
          
          (let [$el (if (= nil-sentinel $el)
                      nil
                      $el)]
            (d/replace-contents! $container $el)
            (recur nil)))))
    
    $container))



;;;;;;;;;;;; This file autogenerated from src/flow/el.cljx
