(ns flow.forms.symbols
  (:require       [flow.compiler :as fc]
            [flow.state :as fs]))

(defn build-symbol [sym-fn]
  (fn []
    (letfn [(update-symbol! []
              [(sym-fn) update-symbol!])]
      (update-symbol!))))

     
(defn symbol-form [sym bound-syms]
  (if (contains? bound-syms sym)
    `(get fs/*state* (quote ~sym))
    sym))

     
(defmethod fc/compile-el-form :symbol [sym {:keys [bound-syms] :as opts}]
  `(build-symbol (fn [] ~(symbol-form sym bound-syms))))

     
(defmethod fc/compile-value-form :symbol [sym {:keys [bound-syms] :as opts}]
  (symbol-form sym bound-syms))

;;;;;;;;;;;; This file autogenerated from src/flow/forms/symbols.cljx
