(ns lein-nomad.plugin
  (:require [robert.hooke :refer [add-hook]]
            [clojure.java.io :as io]))

(defn nomad-file [{:keys [root target-path]}]
  (io/file root target-path ".nomad-file"))

(defn app-config-file [{:keys [root]
                        config-path :nomad/config-path}]
  (println "getting app config file")
  (io/file root config-path))

(defn write-app-config-file-to-nomad-file [project]
  (spit (nomad-file project) (.getAbsolutePath (app-config-file project))))

(defn wrap-apply-task [func task-name project args]
  (write-app-config-file-to-nomad-file project)
  (func task-name project args))

(defn hooks []
  (add-hook #'leiningen.core.main/apply-task #'wrap-apply-task ))