(ns pipe.core)

(defn fire [%pipe & args]
  (doseq [f @%pipe]
    (apply f args))
  %pipe)

(defn on [%pipe f]
  (swap! %pipe conj f)
  %pipe)

(defn pipe
  ([]
     (atom []))
  ([f]
     (on (pipe) f)))
