(ns jarohen.with-open
  (:import [java.io Closeable]))

(defmacro with-close [value close-expr]
  `(let [value# ~value]
     (fn [f#]
       (try
         (f# value#)
         (finally
           ~close-expr)))))

(defn- with-open* [resource f]
  (cond
    (instance? Closeable resource) (with-open [resource resource]
                                     (f resource))

    (fn? resource) (resource f)
    :else (throw (ex-info "Invalid resource passed to with-open+" {:resource resource}))))

(defmacro with-open+ [bindings & body]
  (if-let [[binding expr & more-bindings] (seq bindings)]
    `(#'with-open* ~expr (fn [~binding]
                           (with-open+ [~@more-bindings]
                             ~@body)))

    `(do ~@body)))
