# bodykit-clj

A Clojure library for the Body Labs [BodyKit Instant API](http://developer.bodylabs.com/).

## Install

Add to `:dependencies` in Leiningen or Boot:

    [bodykit-clj "0.1.0"]

## Use

### Get API credentials

You'll need an API access key and secret from Body Labs. As of late 2015 it's still in private beta, so you'll have to [request an invite](http://www.bodylabs.com/bodykit.html).

### REPL

    (require '[bodykit-clj.core :as bodykit])

### From application

    (ns my-app.core
      (:require [bodykit-clj.core :as bodykit]))

### Make API calls

bodykit-clj supports the [published API calls](http://developer.bodylabs.com/instant_api_reference.html). Pass in a map of parameters to override the defaults.

The methods share [common parameters](http://developer.bodylabs.com/measurement_guide.html#Standard-Scheme), so you may want to store them for reuse:

    (def foo {:gender       "female"
              :scheme       "standard"
              :size         "US 10"
              :unitSystem   "unitedStates"
              :measurements {:height              63
                             :weight              140
                             :bust_girth          36
                             :waist_girth         24
                             :low_hip_girth       36
                             :shirt_sleeve_length 28
                             :inseam              29
                             :mid_neck_girth      12}})

Wrap calls with `with-auth` to provide an API access key and secret. Currently only [server-to-server](http://developer.bodylabs.com/authentication.html#Servertoserver-applications) authentication is supported, but this should work for most use cases.

#### Measurements

Get a map of several predicted measurements from a smaller number of measurements.

    (bodykit/with-auth :server my-access-key my-secret
      (bodykit/measurements foo))

#### Mesh

Get a 3D mesh in [Wavefront OBJ](http://people.cs.clemson.edu/~dhouse/courses/405/docs/brief-obj-file-format.html) format.

    (bodykit/with-auth :server my-access-key my-secret
      (bodykit/mesh foo))

#### Mesh metrics

Get physical metrics (e.g., volume, surface area) about the mesh predicted from the given measurements.

    (bodykit/with-auth :server my-access-key my-secret
      (bodykit/mesh-metrics foo))

#### Heatmap

Get a 3D heat map comparison mesh, showing the difference of the two input meshes (again in [Wavefront OBJ](https://en.wikipedia.org/wiki/Wavefront_.obj_file) format). The heatmap 

    (bodykit/with-auth :server my-access-key my-secret
      (bodykit/heatmap foo))



    (bk/with-auth :server "my-access-key" "my-secret"
                  ;(bk/measurements j)
                  (bk/mesh j)
                  ;(bk/mesh-metrics j)
                  ;(bk/heatmap {:bodies [h j]})
                  ))

## License

Copyright © 2015 [Jeff Kayser](https://jeffkayser.com/)

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.

## TODO

- Support the [web application](http://developer.bodylabs.com/authentication.html#Web-applications) authentication scheme.
- Tests

## Contribute

Pull requests are welcome.