(ns bodykit-clj.test
  (:require [bodykit-clj.core :as bk]))

(comment

  (def pp clojure.pprint/pprint)
  (def r
    (binding [*key* "AK165a7291580287f88ce648dd282788fd"
              *secret* "944192399783d9a46defd6848cbd1ee4"]
      (let [params nil]
        ;(measurements *base-uri* params *key* *secret* :server)
        ;(mesh *base-uri* params *key* *secret* :server)
        ;(mesh-metrics *base-uri* params *key* *secret* :server)
        (bk/heatmap *base-uri* {:bodies [h nil]} *key* *secret* :server)
        )))
  (def r
    (bk/with-auth :server "AK165a7291580287f88ce648dd282788fd" "944192399783d9a46defd6848cbd1ee4"
                  ;(bk/measurements j)
                  ;(bk/mesh j)
                  (bk/mesh-metrics j)
                  ;(bk/heatmap {:bodies [j j2]})
                  ))
  (clojure.pprint/pprint r)
  (count r)
  (spit "/Users/jeffmk/dev/bodykit-heatmap.obj" r)
  (spit "/Users/jeffmk/dev/bodykit-heatmap-j2.obj" r)

  (def j {:scheme       "standard"
          :gender       "male"
          :unitSystem   "unitedStates"
          :size         "US L"
          :measurements {:height              70
                         :weight              190
                         :bust_girth          40
                         :low_hip_girth       42
                         :waist_girth         37.5}})
  (def j2 {:scheme       "standard"
          :gender       "male"
          :unitSystem   "unitedStates"
          :size         "US L"
          :measurements {:height              70
                         :weight              190
                         :bust_girth          40
                         :low_hip_girth       42
                         :waist_girth         37.5
                         :shirt_sleeve_length 37.5
                         :inseam              32}})

  (def h {:scheme       "standard"
          :gender       "female"
          :unitSystem   "unitedStates"
          :size         "US 10"
          :measurements {:height        64.5
                         :weight        175
                         :bust_girth    41
                         :low_hip_girth 41
                         :waist_girth   34
                         ;:shirt_sleeve_length 30
                         ;:inseam              30
                         }})

  (def mix {:gender       "female"
            :scheme       "standard"
            :size         "US 10"
            :unitSystem   "unitedStates"
            :measurements {:height              63
                           :weight              140
                           :bust_girth          36
                           :waist_girth         24
                           :low_hip_girth       36
                           :shirt_sleeve_length 28
                           :inseam              29
                           :mid_neck_girth      12}})

  (def mix2 {:gender      "female"
            :scheme       "standard"
            :size         "US 6"
            :unitSystem   "unitedStates"
            :measurements {:height              63
                           :weight              125
                           :bust_girth          32
                           :waist_girth         22
                           :low_hip_girth       33
                           :shirt_sleeve_length 25
                           :inseam              28}})



  (def rr
    (let [key "AK165a7291580287f88ce648dd282788fd"
          secret "944192399783d9a46defd6848cbd1ee4"]
      (bk/with-auth :server key secret
                    ;(bk/measurements mix)
                    ;(bk/mesh mix)
                    (bk/mesh-metrics mix)
                    ;(bk/heatmap {:bodies [mix mix2] :scale 3})
                    )))
  (clojure.pprint/pprint rr)
  (spit "/Users/jeffmk/dev/bodykit-mix.obj" rr)
  (spit "/Users/jeffmk/dev/bodykit-mix-heatmap-scale3.obj" rr)


  (def f {:BODY1 {:a 1 :b 2 :c 3} :BODY2 {:a 11 :b 22 :c 33 :d 55}})
  (def g {:BODY1 {:a 2 :b 4} :BODY2 {:a 22 :b 44 :c 66}})

  => {:status 200,
      :headers
              {"Access-Control-Allow-Headers"
               "Origin,X-Requested-With, Content-Type, Accept, Authorization"
               "Server" "Cowboy"
               "Via" "1.1 vegur"
               "Content-Type" "application/json; charset=utf-8"
               "Access-Control-Allow-Origin" "*"
               "Connection" "close"
               "Transfer-Encoding" "chunked"
               "Access-Control-Allow-Methods" "POST, GET, PUT, DELETE, OPTIONS"
               "Date" "Mon, 24 Aug 2015 03:35:30 GMT"
               "Vary" "Accept-Encoding"
               "X-Powered-By" "Express"}
      :body
              "{\"output\":{\"measurements\":{\"armscye_girth\":16.91,\"ankle_girth\":9.38,\"ankle_height\":3.13,\"above_bust_girth\":37.18,\"across_back_shoulder_width\":15.2,\"across_back_width\":14.05,\"across_front_width\":13.19,\"back_arm_length\":22,\"back_neck_height\":55.67,\"back_neck_to_across_back\":4.35,\"back_neck_to_mid_neck\":1.22,\"back_neck_to_waist\":15.97,\"bicep_girth\":11.97,\"bust_girth\":37.7,\"bust_height\":46.93,\"bust_point_to_bust_point_halter\":27.66,\"bust_point_to_bust_point_width\":8.82,\"calf_girth\":14.29,\"calf_height\":12.37,\"elbow_girth\":9.66,\"forearm_girth\":9.26,\"front_neck_height\":53.52,\"front_neck_to_above_bust\":3.64,\"front_neck_to_across_front\":2.61,\"front_neck_to_mid_neck\":1.65,\"front_neck_to_waist\":13.96,\"full_sleeve_length\":28.04,\"high_hip_girth\":39.13,\"high_hip_height\":36.49,\"inseam\":30,\"knee_girth\":15.06,\"knee_height\":17.93,\"low_hip_girth\":41,\"low_hip_height\":33.58,\"mid_neck_girth\":12.99,\"neck_base_girth\":15.96,\"outseam\":40.55,\"height\":64.8,\"weight\":150,\"shirt_sleeve_length\":30,\"shoulder_drop\":1.82,\"shoulder_length\":4.27,\"side_arm_length\":21.16,\"side_neck_to_bust_point\":10.77,\"thigh_girth\":23.75,\"thigh_height\":28.48,\"total_rise_length\":28.74,\"under_bust_girth\":32.36,\"under_bust_height\":44.37,\"vertical_trunk_girth\":61.85,\"waist_girth\":31.5,\"waist_height\":41.52,\"waist_to_high_hip\":3.95,\"waist_to_low_hip\":8.29,\"wrist_girth\":6.06}},\"input\":{\"scheme\":\"standard\",\"gender\":\"female\",\"size\":\"US 8\",\"unitSystem\":\"unitedStates\",\"measurements\":{\"height\":64.8,\"weight\":150,\"bust_girth\":37.7,\"low_hip_girth\":41,\"waist_girth\":31.5,\"shirt_sleeve_length\":30,\"inseam\":30},\"generation\":\"2.0\"}}"
      :request-time 206
      :trace-redirects ["https://api.bodylabs.com/instant/measurements"]
      :orig-content-encoding "gzip"}

  )
