/*
 * Decompiled with CFR 0.152.
 */
package cascading.avro;

import cascading.avro.AvroTuple;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.io.BytesWritable;

public class AvroToCascading {
    public static Object[] parseRecord(GenericData.Record record, Schema readerSchema) {
        Object[] result = new Object[readerSchema.getFields().size()];
        Schema writerSchema = record.getSchema();
        List schemaFields = readerSchema.getFields();
        for (int i = 0; i < schemaFields.size(); ++i) {
            Schema.Field field = (Schema.Field)schemaFields.get(i);
            if (writerSchema.getField(field.name()) == null) {
                throw new AvroRuntimeException("Not a valid schema field: " + field.name());
            }
            Object obj = record.get(field.name());
            result[i] = AvroToCascading.fromAvro(obj, field.schema());
        }
        return result;
    }

    protected static Object fromAvro(Object obj, Schema schema) {
        switch (schema.getType()) {
            case UNION: {
                return AvroToCascading.fromAvroUnion(obj, schema);
            }
            case ARRAY: {
                return AvroToCascading.fromAvroArray(obj, schema);
            }
            case STRING: 
            case ENUM: {
                return obj.toString();
            }
            case FIXED: {
                return AvroToCascading.fromAvroFixed(obj);
            }
            case BYTES: {
                return AvroToCascading.fromAvroBytes((ByteBuffer)obj);
            }
            case RECORD: {
                return new AvroTuple((GenericData.Record)obj);
            }
            case MAP: {
                return AvroToCascading.fromAvroMap(obj, schema);
            }
            case NULL: 
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: {
                return obj;
            }
        }
        throw new RuntimeException("Can't convert from type " + schema.getType().toString());
    }

    private static Object fromAvroFixed(Object obj) {
        GenericData.Fixed fixed = (GenericData.Fixed)obj;
        return new BytesWritable(fixed.bytes());
    }

    private static Object fromAvroMap(Object obj, Schema schema) {
        HashMap<String, Object> convertedMap = new HashMap<String, Object>();
        for (Map.Entry e : ((Map)obj).entrySet()) {
            convertedMap.put(((Utf8)e.getKey()).toString(), AvroToCascading.fromAvro(e.getValue(), schema.getValueType()));
        }
        return convertedMap;
    }

    private static Object fromAvroBytes(ByteBuffer val) {
        return new BytesWritable(val.array());
    }

    private static Object fromAvroArray(Object obj, Schema schema) {
        ArrayList<Object> array = new ArrayList<Object>();
        for (Object element : (GenericData.Array)obj) {
            array.add(AvroToCascading.fromAvro(element, schema.getElementType()));
        }
        return array;
    }

    private static Object fromAvroUnion(Object obj, Schema schema) {
        List types = schema.getTypes();
        if (types.size() < 1) {
            throw new AvroRuntimeException("Union has no types");
        }
        if (types.size() == 1) {
            return AvroToCascading.fromAvro(obj, (Schema)types.get(0));
        }
        if (types.size() > 2) {
            throw new AvroRuntimeException("Unions may only consist of a concrete type and null in cascading.avro");
        }
        if (!((Schema)types.get(0)).getType().equals((Object)Schema.Type.NULL) && !((Schema)types.get(1)).getType().equals((Object)Schema.Type.NULL)) {
            throw new AvroRuntimeException("Unions may only consist of a concrete type and null in cascading.avro");
        }
        Integer concreteIndex = ((Schema)types.get(0)).getType() == Schema.Type.NULL ? 1 : 0;
        return AvroToCascading.fromAvro(obj, (Schema)types.get(concreteIndex));
    }
}

