/*
 * Decompiled with CFR 0.152.
 */
package cascading.avro;

import cascading.avro.AvroToCascading;
import cascading.avro.CascadingToAvro;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleException;
import cascading.tuple.util.TupleViews;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;

public class AvroTuple
extends Tuple {
    private final GenericData.Record record;
    private final Schema schema;

    public AvroTuple(GenericData.Record inputRecord) {
        this.record = inputRecord;
        this.schema = inputRecord.getSchema();
    }

    public Object getObject(int pos) {
        return AvroToCascading.fromAvro(this.record.get(pos), ((Schema.Field)this.schema.getFields().get(pos)).schema());
    }

    public void set(int pos, Object val) {
        this.record.put(pos, CascadingToAvro.toAvro(val, ((Schema.Field)this.schema.getFields().get(pos)).schema()));
    }

    public int[] getPos(Fields declarator, Fields selector) {
        if (!declarator.isUnknown() && this.schema.getFields().size() != declarator.size()) {
            throw new TupleException("field declaration: " + declarator.print() + ", does not match tuple: " + this.print());
        }
        return declarator.getPos(selector);
    }

    public Tuple get(int[] pos) {
        if (pos == null || pos.length == 0) {
            return this;
        }
        return TupleViews.createNarrow((int[])pos, (Tuple)this);
    }

    public int size() {
        return this.schema.getFields().size();
    }

    public GenericData.Record getRecord() {
        return this.record;
    }
}

