/*
 * Decompiled with CFR 0.152.
 */
package cascading.avro;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.io.BytesWritable;

public class CascadingToAvro {
    private static final Map<Class<?>, Schema.Type> TYPE_MAP = new HashMap<Class<?>, Schema.Type>(){
        {
            this.put(Integer.class, Schema.Type.INT);
            this.put(Long.class, Schema.Type.LONG);
            this.put(Boolean.class, Schema.Type.BOOLEAN);
            this.put(Double.class, Schema.Type.DOUBLE);
            this.put(Float.class, Schema.Type.FLOAT);
            this.put(String.class, Schema.Type.STRING);
            this.put(BytesWritable.class, Schema.Type.BYTES);
            this.put(List.class, Schema.Type.ARRAY);
            this.put(Map.class, Schema.Type.MAP);
        }
    };

    public static Object[] parseTupleEntry(TupleEntry tupleEntry, Schema writerSchema) {
        if (writerSchema.getFields().size() != tupleEntry.size()) {
            throw new AvroRuntimeException("Arity mismatch between incoming tuple and schema");
        }
        return CascadingToAvro.parseTuple(tupleEntry.getTuple(), writerSchema);
    }

    private static Object[] parseTuple(Tuple tuple, Schema writerSchema) {
        Object[] result = new Object[writerSchema.getFields().size()];
        List schemaFields = writerSchema.getFields();
        for (int i = 0; i < schemaFields.size(); ++i) {
            Schema.Field field = (Schema.Field)schemaFields.get(i);
            Object obj = tuple.getObject(i);
            result[i] = CascadingToAvro.toAvro(obj, field.schema());
        }
        return result;
    }

    protected static Object toAvro(Object obj, Schema schema) {
        switch (schema.getType()) {
            case ARRAY: {
                return CascadingToAvro.toAvroArray(obj, schema);
            }
            case STRING: {
                return obj.toString();
            }
            case ENUM: {
                return CascadingToAvro.toAvroEnum(obj, schema);
            }
            case FIXED: {
                return CascadingToAvro.toAvroFixed(obj, schema);
            }
            case BYTES: {
                return CascadingToAvro.toAvroBytes(obj);
            }
            case RECORD: {
                if (obj instanceof GenericData.Record) {
                    return obj;
                }
                Object[] objectArray = obj instanceof Tuple ? CascadingToAvro.parseTuple((Tuple)obj, schema) : CascadingToAvro.parseTupleEntry((TupleEntry)obj, schema);
                GenericData.Record record = new GenericData.Record(schema);
                for (int i = 0; i < objectArray.length; ++i) {
                    record.put(i, objectArray[i]);
                }
                return record;
            }
            case MAP: {
                return CascadingToAvro.toAvroMap(obj, schema);
            }
            case UNION: {
                return CascadingToAvro.toAvroUnion(obj, schema);
            }
            case NULL: 
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: {
                return obj;
            }
        }
        throw new AvroRuntimeException("Can't convert from type " + schema.getType().toString());
    }

    private static Object toAvroEnum(Object obj, Schema schema) {
        return new GenericData.EnumSymbol(schema, obj.toString());
    }

    private static Object toAvroFixed(Object obj, Schema schema) {
        if (obj instanceof GenericData.Fixed) {
            return obj;
        }
        BytesWritable bytes = (BytesWritable)obj;
        return new GenericData.Fixed(schema, bytes.getBytes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object toAvroMap(Object obj, Schema schema) {
        HashMap<String, Object> convertedMap = new HashMap<String, Object>();
        if (obj instanceof Tuple) {
            Schema.Type mapValueType = schema.getValueType().getType();
            Tuple tuple = (Tuple)obj;
            if (tuple.size() % 2 != 0) throw new AvroRuntimeException("Can't convert from an odd length tuple to a map");
            for (int i = 0; i < tuple.size(); i += 2) {
                if (tuple.getObject(i).getClass() != String.class) {
                    throw new AvroRuntimeException("Invalid map definition - the key should be a String - instead of " + tuple.getObject(i).getClass());
                }
                if (CascadingToAvro.toAvroSchemaType(tuple.getObject(i + 1).getClass()) != mapValueType) {
                    throw new AvroRuntimeException(String.format("Found map value with %s instead of expected %s", tuple.getObject(i + 1).getClass(), mapValueType));
                }
                convertedMap.put(tuple.getObject(i).toString(), CascadingToAvro.toAvro(tuple.getObject(i + 1), schema.getValueType()));
            }
            return convertedMap;
        } else {
            for (Map.Entry e : ((Map)obj).entrySet()) {
                convertedMap.put((String)e.getKey(), CascadingToAvro.toAvro(e.getValue(), schema.getValueType()));
            }
        }
        return convertedMap;
    }

    private static Object toAvroBytes(Object obj) {
        if (obj instanceof ByteBuffer) {
            return obj;
        }
        BytesWritable inBytes = (BytesWritable)obj;
        return ByteBuffer.wrap(inBytes.getBytes());
    }

    private static Object toAvroArray(Object obj, Schema schema) {
        if (obj instanceof Iterable) {
            Schema elementSchema = schema.getElementType();
            ArrayList<Object> array = new ArrayList<Object>();
            for (Object element : (Iterable)obj) {
                array.add(CascadingToAvro.toAvro(element, elementSchema));
            }
            return new GenericData.Array(schema, array);
        }
        throw new AvroRuntimeException("Can't convert from non-iterable to array");
    }

    private static Object toAvroUnion(Object obj, Schema schema) {
        if (obj == null) {
            return obj;
        }
        List types = schema.getTypes();
        if (types.size() < 1) {
            throw new AvroRuntimeException("Union in writer schema has no types");
        }
        if (types.size() == 1) {
            return CascadingToAvro.toAvro(obj, (Schema)types.get(0));
        }
        if (types.size() > 2) {
            throw new AvroRuntimeException("Unions may only consist of a concrete type and null in cascading.avro");
        }
        if (!((Schema)types.get(0)).getType().equals((Object)Schema.Type.NULL) && !((Schema)types.get(1)).getType().equals((Object)Schema.Type.NULL)) {
            throw new AvroRuntimeException("Unions may only consist of a concrete type and null in cascading.avro");
        }
        Integer concreteIndex = ((Schema)types.get(0)).getType() == Schema.Type.NULL ? 1 : 0;
        return CascadingToAvro.toAvro(obj, (Schema)types.get(concreteIndex));
    }

    protected static Schema generateAvroSchemaFromTupleEntry(TupleEntry tupleEntry, String recordName, boolean isNullable) {
        Fields tupleFields = tupleEntry.getFields();
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
        for (Comparable fieldName : tupleFields) {
            if (!(fieldName instanceof String)) {
                throw new AvroRuntimeException("Can't generate schema from non-string named fields");
            }
            Schema fieldSchema = CascadingToAvro.generateAvroSchemaFromElement(tupleEntry.getObject(fieldName), (String)((Object)fieldName), isNullable);
            avroFields.add(new Schema.Field((String)((Object)fieldName), fieldSchema, null, null));
        }
        Schema outputSchema = Schema.createRecord((String)recordName, (String)"auto-generated by cascading.avro", null, (boolean)false);
        outputSchema.setFields(avroFields);
        return outputSchema;
    }

    protected static Schema generateAvroSchemaFromElement(Object element, String name, boolean isNullable) {
        if (element == null) {
            throw new AvroRuntimeException("Can't infer schema from null valued element");
        }
        if (isNullable) {
            return CascadingToAvro.generateUnionSchema(element, name);
        }
        if (element instanceof TupleEntry) {
            return CascadingToAvro.generateAvroSchemaFromTupleEntry((TupleEntry)element, name, isNullable);
        }
        if (element instanceof Map) {
            return CascadingToAvro.generateAvroSchemaFromMap((Map)element, name);
        }
        if (element instanceof Iterable) {
            return CascadingToAvro.generateAvroSchemaFromIterable((Iterable)element, name);
        }
        if (element instanceof BytesWritable) {
            return Schema.create((Schema.Type)Schema.Type.BYTES);
        }
        if (element instanceof String) {
            return Schema.create((Schema.Type)Schema.Type.STRING);
        }
        if (element instanceof Double) {
            return Schema.create((Schema.Type)Schema.Type.DOUBLE);
        }
        if (element instanceof Float) {
            return Schema.create((Schema.Type)Schema.Type.FLOAT);
        }
        if (element instanceof Integer) {
            return Schema.create((Schema.Type)Schema.Type.INT);
        }
        if (element instanceof Long) {
            return Schema.create((Schema.Type)Schema.Type.LONG);
        }
        if (element instanceof Boolean) {
            return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
        }
        throw new AvroRuntimeException("Can't create schema from type " + element.getClass());
    }

    private static Schema generateAvroSchemaFromIterable(Iterable element, String name) {
        Iterator iterator = element.iterator();
        if (!iterator.hasNext()) {
            throw new AvroRuntimeException("Can't infer list schema from empty iterable");
        }
        Schema itemSchema = CascadingToAvro.generateAvroSchemaFromElement(iterator.next(), name + "ArrayElement", false);
        return Schema.createArray((Schema)itemSchema);
    }

    private static Schema generateAvroSchemaFromMap(Map<String, Object> element, String name) {
        if (element.isEmpty()) {
            throw new AvroRuntimeException("Can't infer map schema from empty map");
        }
        Iterator<Object> iterator = element.values().iterator();
        Schema valueSchema = CascadingToAvro.generateAvroSchemaFromElement(iterator.next(), name + "MapValue", false);
        return Schema.createMap((Schema)valueSchema);
    }

    private static Schema generateUnionSchema(Object element, String name) {
        ArrayList<Schema> types = new ArrayList<Schema>();
        types.add(Schema.create((Schema.Type)Schema.Type.NULL));
        types.add(CascadingToAvro.generateAvroSchemaFromElement(element, name, false));
        return Schema.createUnion(types);
    }

    public static Schema generateAvroSchemaFromFieldsAndTypes(String recordName, Fields schemeFields, Class<?>[] schemeTypes) {
        if (schemeFields.size() == 0) {
            throw new IllegalArgumentException("There must be at least one field");
        }
        int schemeTypesSize = 0;
        int i = 0;
        while (i < schemeTypes.length) {
            if (schemeTypes[i] == List.class || schemeTypes[i] == Map.class) {
                ++i;
            }
            ++i;
            ++schemeTypesSize;
        }
        if (schemeTypesSize != schemeFields.size()) {
            throw new IllegalArgumentException("You must have a schemeType for every field");
        }
        for (i = 0; i < schemeTypes.length; ++i) {
            if (schemeTypes[i] != List.class && schemeTypes[i] != Map.class || !CascadingToAvro.isNotPrimitiveType(schemeTypes[++i])) continue;
            throw new IllegalArgumentException("Only primitive types are allowed for an Array or Map");
        }
        return CascadingToAvro.generateSchema(recordName, schemeFields, schemeTypes, 0);
    }

    public static void addToTuple(Tuple t, byte[] bytes) {
        t.add((Comparable)new BytesWritable(bytes));
    }

    public static void addToTuple(Tuple t, Enum e) {
        t.add((Comparable)((Object)e.toString()));
    }

    public static void addToTuple(Tuple t, List<?> list) {
        Tuple listTuple = new Tuple();
        for (Object item : list) {
            listTuple.add(item);
        }
        t.add((Comparable)listTuple);
    }

    public static void addToTuple(Tuple t, Map<String, ?> map) {
        Tuple mapTuple = new Tuple();
        for (String key : map.keySet()) {
            mapTuple.add((Comparable)((Object)key));
            mapTuple.add(map.get(key));
        }
        t.add((Comparable)mapTuple);
    }

    private static boolean isNotPrimitiveType(Class<?> arrayType) {
        return arrayType != Boolean.class && arrayType != Integer.class && arrayType != Long.class && arrayType != Float.class && arrayType != Double.class && arrayType != String.class && arrayType != BytesWritable.class;
    }

    private static Schema generateSchema(String recordName, Fields schemeFields, Class<?>[] schemeTypes, int depth) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        int typeIndex = 0;
        int fieldIndex = 0;
        while (typeIndex < schemeTypes.length) {
            String fieldName = schemeFields.get(fieldIndex).toString();
            Class[] subSchemeTypes = new Class[2];
            subSchemeTypes[0] = schemeTypes[typeIndex];
            if (schemeTypes[typeIndex] == List.class || schemeTypes[typeIndex] == Map.class) {
                subSchemeTypes[1] = schemeTypes[++typeIndex];
            }
            final Schema schema = CascadingToAvro.createAvroSchema(recordName, schemeFields, subSchemeTypes, depth + 1);
            final Schema nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
            LinkedList<Schema> schemas = new LinkedList<Schema>(){
                {
                    this.add(nullSchema);
                    this.add(schema);
                }
            };
            fields.add(new Schema.Field(fieldName, Schema.createUnion((List)schemas), "", null));
            ++typeIndex;
            ++fieldIndex;
        }
        if (depth > 0) {
            recordName = recordName + depth;
        }
        Schema schema = Schema.createRecord((String)recordName, (String)"auto generated", (String)"", (boolean)false);
        schema.setFields(fields);
        return schema;
    }

    private static Schema createAvroSchema(String recordName, Fields schemeFields, Class<?>[] fieldTypes, int depth) {
        Schema.Type avroType = CascadingToAvro.toAvroSchemaType(fieldTypes[0]);
        int remainingFields = schemeFields.size() - 1;
        if (avroType == Schema.Type.ARRAY) {
            Schema schema;
            if (remainingFields == 0) {
                schema = Schema.createArray((Schema)Schema.create((Schema.Type)CascadingToAvro.toAvroSchemaType(fieldTypes[1])));
            } else {
                Class[] arrayTypes = new Class[]{fieldTypes[1]};
                schema = Schema.createArray((Schema)CascadingToAvro.createAvroSchema(recordName, Fields.offsetSelector((int)(schemeFields.size() - 1), (int)1), arrayTypes, depth + 1));
            }
            return schema;
        }
        if (avroType == Schema.Type.MAP) {
            Schema schema;
            if (remainingFields == 0) {
                schema = Schema.createMap((Schema)Schema.create((Schema.Type)CascadingToAvro.toAvroSchemaType(fieldTypes[1])));
            } else {
                Class[] mapTypes = new Class[]{fieldTypes[1]};
                schema = Schema.createMap((Schema)CascadingToAvro.createAvroSchema(recordName, Fields.offsetSelector((int)(schemeFields.size() - 1), (int)1), mapTypes, depth + 1));
            }
            return schema;
        }
        if (avroType == Schema.Type.RECORD) {
            return CascadingToAvro.generateSchema(recordName, Fields.offsetSelector((int)(schemeFields.size() - 1), (int)1), fieldTypes, depth + 1);
        }
        if (avroType == Schema.Type.ENUM) {
            Class<?> clazz = fieldTypes[0];
            ?[] names = clazz.getEnumConstants();
            ArrayList<String> enumNames = new ArrayList<String>(names.length);
            for (Object name : names) {
                enumNames.add(name.toString());
            }
            return Schema.createEnum((String)fieldTypes[0].getName(), null, null, enumNames);
        }
        return Schema.create((Schema.Type)avroType);
    }

    private static Schema.Type toAvroSchemaType(Class<?> clazz) {
        if (TYPE_MAP.containsKey(clazz)) {
            return TYPE_MAP.get(clazz);
        }
        if (clazz.isEnum()) {
            return Schema.Type.ENUM;
        }
        throw new UnsupportedOperationException("The class type " + clazz + " is currently unsupported");
    }
}

