/*
 * Decompiled with CFR 0.152.
 */
package cascading.avro;

import cascading.avro.AvroScheme;
import cascading.flow.FlowProcess;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class PackedAvroScheme<T extends GenericContainer>
extends AvroScheme {
    public PackedAvroScheme() {
        this(null);
    }

    public PackedAvroScheme(Schema schema) {
        this.schema = schema;
        if (schema == null) {
            this.setSinkFields(Fields.ALL);
            this.setSourceFields(Fields.UNKNOWN);
        } else {
            String schemaName = schema.getName();
            Fields cascadingFields = new Fields(new Comparable[]{schemaName});
            this.setSinkFields(cascadingFields);
            this.setSourceFields(cascadingFields);
        }
    }

    @Override
    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        ((OutputCollector)sinkCall.getOutput()).collect((Object)new AvroWrapper((Object)((GenericContainer)tupleEntry.getObject((Comparable)this.getSinkFields()))), (Object)NullWritable.get());
    }

    @Override
    public void sinkPrepare(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
    }

    @Override
    public Fields retrieveSourceFields(FlowProcess<JobConf> flowProcess, Tap tap) {
        if (this.schema == null) {
            this.setSourceFields(Fields.UNKNOWN);
        } else {
            this.setSourceFields(new Fields(new Comparable[]{this.schema.getName()}));
        }
        return this.getSourceFields();
    }

    @Override
    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        AvroWrapper wrapper;
        RecordReader input = (RecordReader)sourceCall.getInput();
        if (!input.next((Object)(wrapper = (AvroWrapper)input.createKey()), input.createValue())) {
            return false;
        }
        GenericContainer record = (GenericContainer)wrapper.datum();
        Tuple tuple = sourceCall.getIncomingEntry().getTuple();
        tuple.clear();
        tuple.add((Object)record);
        return true;
    }
}

