// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args19047 = [];
var len__17893__auto___19053 = arguments.length;
var i__17894__auto___19054 = (0);
while(true){
if((i__17894__auto___19054 < len__17893__auto___19053)){
args19047.push((arguments[i__17894__auto___19054]));

var G__19055 = (i__17894__auto___19054 + (1));
i__17894__auto___19054 = G__19055;
continue;
} else {
}
break;
}

var G__19049 = args19047.length;
switch (G__19049) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19047.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async19050 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19050 = (function (f,blockable,meta19051){
this.f = f;
this.blockable = blockable;
this.meta19051 = meta19051;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19052,meta19051__$1){
var self__ = this;
var _19052__$1 = this;
return (new cljs.core.async.t_cljs$core$async19050(self__.f,self__.blockable,meta19051__$1));
});

cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19052){
var self__ = this;
var _19052__$1 = this;
return self__.meta19051;
});

cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async19050.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta19051","meta19051",-806146433,null)], null);
});

cljs.core.async.t_cljs$core$async19050.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19050.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19050";

cljs.core.async.t_cljs$core$async19050.cljs$lang$ctorPrWriter = (function (this__17433__auto__,writer__17434__auto__,opt__17435__auto__){
return cljs.core._write.call(null,writer__17434__auto__,"cljs.core.async/t_cljs$core$async19050");
});

cljs.core.async.__GT_t_cljs$core$async19050 = (function cljs$core$async$__GT_t_cljs$core$async19050(f__$1,blockable__$1,meta19051){
return (new cljs.core.async.t_cljs$core$async19050(f__$1,blockable__$1,meta19051));
});

}

return (new cljs.core.async.t_cljs$core$async19050(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args19059 = [];
var len__17893__auto___19062 = arguments.length;
var i__17894__auto___19063 = (0);
while(true){
if((i__17894__auto___19063 < len__17893__auto___19062)){
args19059.push((arguments[i__17894__auto___19063]));

var G__19064 = (i__17894__auto___19063 + (1));
i__17894__auto___19063 = G__19064;
continue;
} else {
}
break;
}

var G__19061 = args19059.length;
switch (G__19061) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19059.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args19066 = [];
var len__17893__auto___19069 = arguments.length;
var i__17894__auto___19070 = (0);
while(true){
if((i__17894__auto___19070 < len__17893__auto___19069)){
args19066.push((arguments[i__17894__auto___19070]));

var G__19071 = (i__17894__auto___19070 + (1));
i__17894__auto___19070 = G__19071;
continue;
} else {
}
break;
}

var G__19068 = args19066.length;
switch (G__19068) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19066.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args19073 = [];
var len__17893__auto___19076 = arguments.length;
var i__17894__auto___19077 = (0);
while(true){
if((i__17894__auto___19077 < len__17893__auto___19076)){
args19073.push((arguments[i__17894__auto___19077]));

var G__19078 = (i__17894__auto___19077 + (1));
i__17894__auto___19077 = G__19078;
continue;
} else {
}
break;
}

var G__19075 = args19073.length;
switch (G__19075) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19073.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_19080 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_19080);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_19080,ret){
return (function (){
return fn1.call(null,val_19080);
});})(val_19080,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args19081 = [];
var len__17893__auto___19084 = arguments.length;
var i__17894__auto___19085 = (0);
while(true){
if((i__17894__auto___19085 < len__17893__auto___19084)){
args19081.push((arguments[i__17894__auto___19085]));

var G__19086 = (i__17894__auto___19085 + (1));
i__17894__auto___19085 = G__19086;
continue;
} else {
}
break;
}

var G__19083 = args19081.length;
switch (G__19083) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19081.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__17738__auto___19088 = n;
var x_19089 = (0);
while(true){
if((x_19089 < n__17738__auto___19088)){
(a[x_19089] = (0));

var G__19090 = (x_19089 + (1));
x_19089 = G__19090;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__19091 = (i + (1));
i = G__19091;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async19095 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19095 = (function (alt_flag,flag,meta19096){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta19096 = meta19096;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19095.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_19097,meta19096__$1){
var self__ = this;
var _19097__$1 = this;
return (new cljs.core.async.t_cljs$core$async19095(self__.alt_flag,self__.flag,meta19096__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async19095.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_19097){
var self__ = this;
var _19097__$1 = this;
return self__.meta19096;
});})(flag))
;

cljs.core.async.t_cljs$core$async19095.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19095.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async19095.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19095.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19095.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta19096","meta19096",-760432625,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async19095.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19095.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19095";

cljs.core.async.t_cljs$core$async19095.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__17433__auto__,writer__17434__auto__,opt__17435__auto__){
return cljs.core._write.call(null,writer__17434__auto__,"cljs.core.async/t_cljs$core$async19095");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async19095 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async19095(alt_flag__$1,flag__$1,meta19096){
return (new cljs.core.async.t_cljs$core$async19095(alt_flag__$1,flag__$1,meta19096));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async19095(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async19101 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19101 = (function (alt_handler,flag,cb,meta19102){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta19102 = meta19102;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19101.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19103,meta19102__$1){
var self__ = this;
var _19103__$1 = this;
return (new cljs.core.async.t_cljs$core$async19101(self__.alt_handler,self__.flag,self__.cb,meta19102__$1));
});

cljs.core.async.t_cljs$core$async19101.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19103){
var self__ = this;
var _19103__$1 = this;
return self__.meta19102;
});

cljs.core.async.t_cljs$core$async19101.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19101.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async19101.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async19101.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async19101.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta19102","meta19102",-1629409767,null)], null);
});

cljs.core.async.t_cljs$core$async19101.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19101.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19101";

cljs.core.async.t_cljs$core$async19101.cljs$lang$ctorPrWriter = (function (this__17433__auto__,writer__17434__auto__,opt__17435__auto__){
return cljs.core._write.call(null,writer__17434__auto__,"cljs.core.async/t_cljs$core$async19101");
});

cljs.core.async.__GT_t_cljs$core$async19101 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async19101(alt_handler__$1,flag__$1,cb__$1,meta19102){
return (new cljs.core.async.t_cljs$core$async19101(alt_handler__$1,flag__$1,cb__$1,meta19102));
});

}

return (new cljs.core.async.t_cljs$core$async19101(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19104_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19104_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19105_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19105_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__16835__auto__ = wport;
if(cljs.core.truth_(or__16835__auto__)){
return or__16835__auto__;
} else {
return port;
}
})()], null));
} else {
var G__19106 = (i + (1));
i = G__19106;
continue;
}
} else {
return null;
}
break;
}
})();
var or__16835__auto__ = ret;
if(cljs.core.truth_(or__16835__auto__)){
return or__16835__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__16823__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__16823__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__16823__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__17900__auto__ = [];
var len__17893__auto___19112 = arguments.length;
var i__17894__auto___19113 = (0);
while(true){
if((i__17894__auto___19113 < len__17893__auto___19112)){
args__17900__auto__.push((arguments[i__17894__auto___19113]));

var G__19114 = (i__17894__auto___19113 + (1));
i__17894__auto___19113 = G__19114;
continue;
} else {
}
break;
}

var argseq__17901__auto__ = ((((1) < args__17900__auto__.length))?(new cljs.core.IndexedSeq(args__17900__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17901__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__19109){
var map__19110 = p__19109;
var map__19110__$1 = ((((!((map__19110 == null)))?((((map__19110.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19110.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19110):map__19110);
var opts = map__19110__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq19107){
var G__19108 = cljs.core.first.call(null,seq19107);
var seq19107__$1 = cljs.core.next.call(null,seq19107);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19108,seq19107__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args19115 = [];
var len__17893__auto___19165 = arguments.length;
var i__17894__auto___19166 = (0);
while(true){
if((i__17894__auto___19166 < len__17893__auto___19165)){
args19115.push((arguments[i__17894__auto___19166]));

var G__19167 = (i__17894__auto___19166 + (1));
i__17894__auto___19166 = G__19167;
continue;
} else {
}
break;
}

var G__19117 = args19115.length;
switch (G__19117) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19115.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__19002__auto___19169 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___19169){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___19169){
return (function (state_19141){
var state_val_19142 = (state_19141[(1)]);
if((state_val_19142 === (7))){
var inst_19137 = (state_19141[(2)]);
var state_19141__$1 = state_19141;
var statearr_19143_19170 = state_19141__$1;
(statearr_19143_19170[(2)] = inst_19137);

(statearr_19143_19170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19142 === (1))){
var state_19141__$1 = state_19141;
var statearr_19144_19171 = state_19141__$1;
(statearr_19144_19171[(2)] = null);

(statearr_19144_19171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19142 === (4))){
var inst_19120 = (state_19141[(7)]);
var inst_19120__$1 = (state_19141[(2)]);
var inst_19121 = (inst_19120__$1 == null);
var state_19141__$1 = (function (){var statearr_19145 = state_19141;
(statearr_19145[(7)] = inst_19120__$1);

return statearr_19145;
})();
if(cljs.core.truth_(inst_19121)){
var statearr_19146_19172 = state_19141__$1;
(statearr_19146_19172[(1)] = (5));

} else {
var statearr_19147_19173 = state_19141__$1;
(statearr_19147_19173[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19142 === (13))){
var state_19141__$1 = state_19141;
var statearr_19148_19174 = state_19141__$1;
(statearr_19148_19174[(2)] = null);

(statearr_19148_19174[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19142 === (6))){
var inst_19120 = (state_19141[(7)]);
var state_19141__$1 = state_19141;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19141__$1,(11),to,inst_19120);
} else {
if((state_val_19142 === (3))){
var inst_19139 = (state_19141[(2)]);
var state_19141__$1 = state_19141;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19141__$1,inst_19139);
} else {
if((state_val_19142 === (12))){
var state_19141__$1 = state_19141;
var statearr_19149_19175 = state_19141__$1;
(statearr_19149_19175[(2)] = null);

(statearr_19149_19175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19142 === (2))){
var state_19141__$1 = state_19141;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19141__$1,(4),from);
} else {
if((state_val_19142 === (11))){
var inst_19130 = (state_19141[(2)]);
var state_19141__$1 = state_19141;
if(cljs.core.truth_(inst_19130)){
var statearr_19150_19176 = state_19141__$1;
(statearr_19150_19176[(1)] = (12));

} else {
var statearr_19151_19177 = state_19141__$1;
(statearr_19151_19177[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19142 === (9))){
var state_19141__$1 = state_19141;
var statearr_19152_19178 = state_19141__$1;
(statearr_19152_19178[(2)] = null);

(statearr_19152_19178[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19142 === (5))){
var state_19141__$1 = state_19141;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19153_19179 = state_19141__$1;
(statearr_19153_19179[(1)] = (8));

} else {
var statearr_19154_19180 = state_19141__$1;
(statearr_19154_19180[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19142 === (14))){
var inst_19135 = (state_19141[(2)]);
var state_19141__$1 = state_19141;
var statearr_19155_19181 = state_19141__$1;
(statearr_19155_19181[(2)] = inst_19135);

(statearr_19155_19181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19142 === (10))){
var inst_19127 = (state_19141[(2)]);
var state_19141__$1 = state_19141;
var statearr_19156_19182 = state_19141__$1;
(statearr_19156_19182[(2)] = inst_19127);

(statearr_19156_19182[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19142 === (8))){
var inst_19124 = cljs.core.async.close_BANG_.call(null,to);
var state_19141__$1 = state_19141;
var statearr_19157_19183 = state_19141__$1;
(statearr_19157_19183[(2)] = inst_19124);

(statearr_19157_19183[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto___19169))
;
return ((function (switch__18890__auto__,c__19002__auto___19169){
return (function() {
var cljs$core$async$state_machine__18891__auto__ = null;
var cljs$core$async$state_machine__18891__auto____0 = (function (){
var statearr_19161 = [null,null,null,null,null,null,null,null];
(statearr_19161[(0)] = cljs$core$async$state_machine__18891__auto__);

(statearr_19161[(1)] = (1));

return statearr_19161;
});
var cljs$core$async$state_machine__18891__auto____1 = (function (state_19141){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_19141);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e19162){if((e19162 instanceof Object)){
var ex__18894__auto__ = e19162;
var statearr_19163_19184 = state_19141;
(statearr_19163_19184[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19141);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19162;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19185 = state_19141;
state_19141 = G__19185;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$state_machine__18891__auto__ = function(state_19141){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18891__auto____1.call(this,state_19141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18891__auto____0;
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18891__auto____1;
return cljs$core$async$state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___19169))
})();
var state__19004__auto__ = (function (){var statearr_19164 = f__19003__auto__.call(null);
(statearr_19164[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___19169);

return statearr_19164;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___19169))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__19369){
var vec__19370 = p__19369;
var v = cljs.core.nth.call(null,vec__19370,(0),null);
var p = cljs.core.nth.call(null,vec__19370,(1),null);
var job = vec__19370;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__19002__auto___19553 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___19553,res,vec__19370,v,p,job,jobs,results){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___19553,res,vec__19370,v,p,job,jobs,results){
return (function (state_19375){
var state_val_19376 = (state_19375[(1)]);
if((state_val_19376 === (1))){
var state_19375__$1 = state_19375;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19375__$1,(2),res,v);
} else {
if((state_val_19376 === (2))){
var inst_19372 = (state_19375[(2)]);
var inst_19373 = cljs.core.async.close_BANG_.call(null,res);
var state_19375__$1 = (function (){var statearr_19377 = state_19375;
(statearr_19377[(7)] = inst_19372);

return statearr_19377;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19375__$1,inst_19373);
} else {
return null;
}
}
});})(c__19002__auto___19553,res,vec__19370,v,p,job,jobs,results))
;
return ((function (switch__18890__auto__,c__19002__auto___19553,res,vec__19370,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0 = (function (){
var statearr_19381 = [null,null,null,null,null,null,null,null];
(statearr_19381[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__);

(statearr_19381[(1)] = (1));

return statearr_19381;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1 = (function (state_19375){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_19375);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e19382){if((e19382 instanceof Object)){
var ex__18894__auto__ = e19382;
var statearr_19383_19554 = state_19375;
(statearr_19383_19554[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19375);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19382;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19555 = state_19375;
state_19375 = G__19555;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__ = function(state_19375){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1.call(this,state_19375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___19553,res,vec__19370,v,p,job,jobs,results))
})();
var state__19004__auto__ = (function (){var statearr_19384 = f__19003__auto__.call(null);
(statearr_19384[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___19553);

return statearr_19384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___19553,res,vec__19370,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__19385){
var vec__19386 = p__19385;
var v = cljs.core.nth.call(null,vec__19386,(0),null);
var p = cljs.core.nth.call(null,vec__19386,(1),null);
var job = vec__19386;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__17738__auto___19556 = n;
var __19557 = (0);
while(true){
if((__19557 < n__17738__auto___19556)){
var G__19387_19558 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__19387_19558) {
case "compute":
var c__19002__auto___19560 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19557,c__19002__auto___19560,G__19387_19558,n__17738__auto___19556,jobs,results,process,async){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (__19557,c__19002__auto___19560,G__19387_19558,n__17738__auto___19556,jobs,results,process,async){
return (function (state_19400){
var state_val_19401 = (state_19400[(1)]);
if((state_val_19401 === (1))){
var state_19400__$1 = state_19400;
var statearr_19402_19561 = state_19400__$1;
(statearr_19402_19561[(2)] = null);

(statearr_19402_19561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19401 === (2))){
var state_19400__$1 = state_19400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19400__$1,(4),jobs);
} else {
if((state_val_19401 === (3))){
var inst_19398 = (state_19400[(2)]);
var state_19400__$1 = state_19400;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19400__$1,inst_19398);
} else {
if((state_val_19401 === (4))){
var inst_19390 = (state_19400[(2)]);
var inst_19391 = process.call(null,inst_19390);
var state_19400__$1 = state_19400;
if(cljs.core.truth_(inst_19391)){
var statearr_19403_19562 = state_19400__$1;
(statearr_19403_19562[(1)] = (5));

} else {
var statearr_19404_19563 = state_19400__$1;
(statearr_19404_19563[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19401 === (5))){
var state_19400__$1 = state_19400;
var statearr_19405_19564 = state_19400__$1;
(statearr_19405_19564[(2)] = null);

(statearr_19405_19564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19401 === (6))){
var state_19400__$1 = state_19400;
var statearr_19406_19565 = state_19400__$1;
(statearr_19406_19565[(2)] = null);

(statearr_19406_19565[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19401 === (7))){
var inst_19396 = (state_19400[(2)]);
var state_19400__$1 = state_19400;
var statearr_19407_19566 = state_19400__$1;
(statearr_19407_19566[(2)] = inst_19396);

(statearr_19407_19566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19557,c__19002__auto___19560,G__19387_19558,n__17738__auto___19556,jobs,results,process,async))
;
return ((function (__19557,switch__18890__auto__,c__19002__auto___19560,G__19387_19558,n__17738__auto___19556,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0 = (function (){
var statearr_19411 = [null,null,null,null,null,null,null];
(statearr_19411[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__);

(statearr_19411[(1)] = (1));

return statearr_19411;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1 = (function (state_19400){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_19400);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e19412){if((e19412 instanceof Object)){
var ex__18894__auto__ = e19412;
var statearr_19413_19567 = state_19400;
(statearr_19413_19567[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19400);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19412;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19568 = state_19400;
state_19400 = G__19568;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__ = function(state_19400){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1.call(this,state_19400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__;
})()
;})(__19557,switch__18890__auto__,c__19002__auto___19560,G__19387_19558,n__17738__auto___19556,jobs,results,process,async))
})();
var state__19004__auto__ = (function (){var statearr_19414 = f__19003__auto__.call(null);
(statearr_19414[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___19560);

return statearr_19414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(__19557,c__19002__auto___19560,G__19387_19558,n__17738__auto___19556,jobs,results,process,async))
);


break;
case "async":
var c__19002__auto___19569 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19557,c__19002__auto___19569,G__19387_19558,n__17738__auto___19556,jobs,results,process,async){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (__19557,c__19002__auto___19569,G__19387_19558,n__17738__auto___19556,jobs,results,process,async){
return (function (state_19427){
var state_val_19428 = (state_19427[(1)]);
if((state_val_19428 === (1))){
var state_19427__$1 = state_19427;
var statearr_19429_19570 = state_19427__$1;
(statearr_19429_19570[(2)] = null);

(statearr_19429_19570[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19428 === (2))){
var state_19427__$1 = state_19427;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19427__$1,(4),jobs);
} else {
if((state_val_19428 === (3))){
var inst_19425 = (state_19427[(2)]);
var state_19427__$1 = state_19427;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19427__$1,inst_19425);
} else {
if((state_val_19428 === (4))){
var inst_19417 = (state_19427[(2)]);
var inst_19418 = async.call(null,inst_19417);
var state_19427__$1 = state_19427;
if(cljs.core.truth_(inst_19418)){
var statearr_19430_19571 = state_19427__$1;
(statearr_19430_19571[(1)] = (5));

} else {
var statearr_19431_19572 = state_19427__$1;
(statearr_19431_19572[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19428 === (5))){
var state_19427__$1 = state_19427;
var statearr_19432_19573 = state_19427__$1;
(statearr_19432_19573[(2)] = null);

(statearr_19432_19573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19428 === (6))){
var state_19427__$1 = state_19427;
var statearr_19433_19574 = state_19427__$1;
(statearr_19433_19574[(2)] = null);

(statearr_19433_19574[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19428 === (7))){
var inst_19423 = (state_19427[(2)]);
var state_19427__$1 = state_19427;
var statearr_19434_19575 = state_19427__$1;
(statearr_19434_19575[(2)] = inst_19423);

(statearr_19434_19575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19557,c__19002__auto___19569,G__19387_19558,n__17738__auto___19556,jobs,results,process,async))
;
return ((function (__19557,switch__18890__auto__,c__19002__auto___19569,G__19387_19558,n__17738__auto___19556,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0 = (function (){
var statearr_19438 = [null,null,null,null,null,null,null];
(statearr_19438[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__);

(statearr_19438[(1)] = (1));

return statearr_19438;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1 = (function (state_19427){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_19427);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e19439){if((e19439 instanceof Object)){
var ex__18894__auto__ = e19439;
var statearr_19440_19576 = state_19427;
(statearr_19440_19576[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19427);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19439;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19577 = state_19427;
state_19427 = G__19577;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__ = function(state_19427){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1.call(this,state_19427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__;
})()
;})(__19557,switch__18890__auto__,c__19002__auto___19569,G__19387_19558,n__17738__auto___19556,jobs,results,process,async))
})();
var state__19004__auto__ = (function (){var statearr_19441 = f__19003__auto__.call(null);
(statearr_19441[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___19569);

return statearr_19441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(__19557,c__19002__auto___19569,G__19387_19558,n__17738__auto___19556,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__19578 = (__19557 + (1));
__19557 = G__19578;
continue;
} else {
}
break;
}

var c__19002__auto___19579 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___19579,jobs,results,process,async){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___19579,jobs,results,process,async){
return (function (state_19463){
var state_val_19464 = (state_19463[(1)]);
if((state_val_19464 === (1))){
var state_19463__$1 = state_19463;
var statearr_19465_19580 = state_19463__$1;
(statearr_19465_19580[(2)] = null);

(statearr_19465_19580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19464 === (2))){
var state_19463__$1 = state_19463;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19463__$1,(4),from);
} else {
if((state_val_19464 === (3))){
var inst_19461 = (state_19463[(2)]);
var state_19463__$1 = state_19463;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19463__$1,inst_19461);
} else {
if((state_val_19464 === (4))){
var inst_19444 = (state_19463[(7)]);
var inst_19444__$1 = (state_19463[(2)]);
var inst_19445 = (inst_19444__$1 == null);
var state_19463__$1 = (function (){var statearr_19466 = state_19463;
(statearr_19466[(7)] = inst_19444__$1);

return statearr_19466;
})();
if(cljs.core.truth_(inst_19445)){
var statearr_19467_19581 = state_19463__$1;
(statearr_19467_19581[(1)] = (5));

} else {
var statearr_19468_19582 = state_19463__$1;
(statearr_19468_19582[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19464 === (5))){
var inst_19447 = cljs.core.async.close_BANG_.call(null,jobs);
var state_19463__$1 = state_19463;
var statearr_19469_19583 = state_19463__$1;
(statearr_19469_19583[(2)] = inst_19447);

(statearr_19469_19583[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19464 === (6))){
var inst_19444 = (state_19463[(7)]);
var inst_19449 = (state_19463[(8)]);
var inst_19449__$1 = cljs.core.async.chan.call(null,(1));
var inst_19450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19451 = [inst_19444,inst_19449__$1];
var inst_19452 = (new cljs.core.PersistentVector(null,2,(5),inst_19450,inst_19451,null));
var state_19463__$1 = (function (){var statearr_19470 = state_19463;
(statearr_19470[(8)] = inst_19449__$1);

return statearr_19470;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19463__$1,(8),jobs,inst_19452);
} else {
if((state_val_19464 === (7))){
var inst_19459 = (state_19463[(2)]);
var state_19463__$1 = state_19463;
var statearr_19471_19584 = state_19463__$1;
(statearr_19471_19584[(2)] = inst_19459);

(statearr_19471_19584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19464 === (8))){
var inst_19449 = (state_19463[(8)]);
var inst_19454 = (state_19463[(2)]);
var state_19463__$1 = (function (){var statearr_19472 = state_19463;
(statearr_19472[(9)] = inst_19454);

return statearr_19472;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19463__$1,(9),results,inst_19449);
} else {
if((state_val_19464 === (9))){
var inst_19456 = (state_19463[(2)]);
var state_19463__$1 = (function (){var statearr_19473 = state_19463;
(statearr_19473[(10)] = inst_19456);

return statearr_19473;
})();
var statearr_19474_19585 = state_19463__$1;
(statearr_19474_19585[(2)] = null);

(statearr_19474_19585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__19002__auto___19579,jobs,results,process,async))
;
return ((function (switch__18890__auto__,c__19002__auto___19579,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0 = (function (){
var statearr_19478 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19478[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__);

(statearr_19478[(1)] = (1));

return statearr_19478;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1 = (function (state_19463){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_19463);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e19479){if((e19479 instanceof Object)){
var ex__18894__auto__ = e19479;
var statearr_19480_19586 = state_19463;
(statearr_19480_19586[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19463);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19479;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19587 = state_19463;
state_19463 = G__19587;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__ = function(state_19463){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1.call(this,state_19463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___19579,jobs,results,process,async))
})();
var state__19004__auto__ = (function (){var statearr_19481 = f__19003__auto__.call(null);
(statearr_19481[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___19579);

return statearr_19481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___19579,jobs,results,process,async))
);


var c__19002__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto__,jobs,results,process,async){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto__,jobs,results,process,async){
return (function (state_19519){
var state_val_19520 = (state_19519[(1)]);
if((state_val_19520 === (7))){
var inst_19515 = (state_19519[(2)]);
var state_19519__$1 = state_19519;
var statearr_19521_19588 = state_19519__$1;
(statearr_19521_19588[(2)] = inst_19515);

(statearr_19521_19588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (20))){
var state_19519__$1 = state_19519;
var statearr_19522_19589 = state_19519__$1;
(statearr_19522_19589[(2)] = null);

(statearr_19522_19589[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (1))){
var state_19519__$1 = state_19519;
var statearr_19523_19590 = state_19519__$1;
(statearr_19523_19590[(2)] = null);

(statearr_19523_19590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (4))){
var inst_19484 = (state_19519[(7)]);
var inst_19484__$1 = (state_19519[(2)]);
var inst_19485 = (inst_19484__$1 == null);
var state_19519__$1 = (function (){var statearr_19524 = state_19519;
(statearr_19524[(7)] = inst_19484__$1);

return statearr_19524;
})();
if(cljs.core.truth_(inst_19485)){
var statearr_19525_19591 = state_19519__$1;
(statearr_19525_19591[(1)] = (5));

} else {
var statearr_19526_19592 = state_19519__$1;
(statearr_19526_19592[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (15))){
var inst_19497 = (state_19519[(8)]);
var state_19519__$1 = state_19519;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19519__$1,(18),to,inst_19497);
} else {
if((state_val_19520 === (21))){
var inst_19510 = (state_19519[(2)]);
var state_19519__$1 = state_19519;
var statearr_19527_19593 = state_19519__$1;
(statearr_19527_19593[(2)] = inst_19510);

(statearr_19527_19593[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (13))){
var inst_19512 = (state_19519[(2)]);
var state_19519__$1 = (function (){var statearr_19528 = state_19519;
(statearr_19528[(9)] = inst_19512);

return statearr_19528;
})();
var statearr_19529_19594 = state_19519__$1;
(statearr_19529_19594[(2)] = null);

(statearr_19529_19594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (6))){
var inst_19484 = (state_19519[(7)]);
var state_19519__$1 = state_19519;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19519__$1,(11),inst_19484);
} else {
if((state_val_19520 === (17))){
var inst_19505 = (state_19519[(2)]);
var state_19519__$1 = state_19519;
if(cljs.core.truth_(inst_19505)){
var statearr_19530_19595 = state_19519__$1;
(statearr_19530_19595[(1)] = (19));

} else {
var statearr_19531_19596 = state_19519__$1;
(statearr_19531_19596[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (3))){
var inst_19517 = (state_19519[(2)]);
var state_19519__$1 = state_19519;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19519__$1,inst_19517);
} else {
if((state_val_19520 === (12))){
var inst_19494 = (state_19519[(10)]);
var state_19519__$1 = state_19519;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19519__$1,(14),inst_19494);
} else {
if((state_val_19520 === (2))){
var state_19519__$1 = state_19519;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19519__$1,(4),results);
} else {
if((state_val_19520 === (19))){
var state_19519__$1 = state_19519;
var statearr_19533_19597 = state_19519__$1;
(statearr_19533_19597[(2)] = null);

(statearr_19533_19597[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (11))){
var inst_19494 = (state_19519[(2)]);
var state_19519__$1 = (function (){var statearr_19534 = state_19519;
(statearr_19534[(10)] = inst_19494);

return statearr_19534;
})();
var statearr_19535_19598 = state_19519__$1;
(statearr_19535_19598[(2)] = null);

(statearr_19535_19598[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (9))){
var state_19519__$1 = state_19519;
var statearr_19536_19599 = state_19519__$1;
(statearr_19536_19599[(2)] = null);

(statearr_19536_19599[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (5))){
var state_19519__$1 = state_19519;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19537_19600 = state_19519__$1;
(statearr_19537_19600[(1)] = (8));

} else {
var statearr_19538_19601 = state_19519__$1;
(statearr_19538_19601[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (14))){
var inst_19497 = (state_19519[(8)]);
var inst_19499 = (state_19519[(11)]);
var inst_19497__$1 = (state_19519[(2)]);
var inst_19498 = (inst_19497__$1 == null);
var inst_19499__$1 = cljs.core.not.call(null,inst_19498);
var state_19519__$1 = (function (){var statearr_19539 = state_19519;
(statearr_19539[(8)] = inst_19497__$1);

(statearr_19539[(11)] = inst_19499__$1);

return statearr_19539;
})();
if(inst_19499__$1){
var statearr_19540_19602 = state_19519__$1;
(statearr_19540_19602[(1)] = (15));

} else {
var statearr_19541_19603 = state_19519__$1;
(statearr_19541_19603[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (16))){
var inst_19499 = (state_19519[(11)]);
var state_19519__$1 = state_19519;
var statearr_19542_19604 = state_19519__$1;
(statearr_19542_19604[(2)] = inst_19499);

(statearr_19542_19604[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (10))){
var inst_19491 = (state_19519[(2)]);
var state_19519__$1 = state_19519;
var statearr_19543_19605 = state_19519__$1;
(statearr_19543_19605[(2)] = inst_19491);

(statearr_19543_19605[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (18))){
var inst_19502 = (state_19519[(2)]);
var state_19519__$1 = state_19519;
var statearr_19544_19606 = state_19519__$1;
(statearr_19544_19606[(2)] = inst_19502);

(statearr_19544_19606[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19520 === (8))){
var inst_19488 = cljs.core.async.close_BANG_.call(null,to);
var state_19519__$1 = state_19519;
var statearr_19545_19607 = state_19519__$1;
(statearr_19545_19607[(2)] = inst_19488);

(statearr_19545_19607[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto__,jobs,results,process,async))
;
return ((function (switch__18890__auto__,c__19002__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0 = (function (){
var statearr_19549 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19549[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__);

(statearr_19549[(1)] = (1));

return statearr_19549;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1 = (function (state_19519){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_19519);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e19550){if((e19550 instanceof Object)){
var ex__18894__auto__ = e19550;
var statearr_19551_19608 = state_19519;
(statearr_19551_19608[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19519);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19550;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19609 = state_19519;
state_19519 = G__19609;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__ = function(state_19519){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1.call(this,state_19519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18891__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto__,jobs,results,process,async))
})();
var state__19004__auto__ = (function (){var statearr_19552 = f__19003__auto__.call(null);
(statearr_19552[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto__);

return statearr_19552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto__,jobs,results,process,async))
);

return c__19002__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args19610 = [];
var len__17893__auto___19613 = arguments.length;
var i__17894__auto___19614 = (0);
while(true){
if((i__17894__auto___19614 < len__17893__auto___19613)){
args19610.push((arguments[i__17894__auto___19614]));

var G__19615 = (i__17894__auto___19614 + (1));
i__17894__auto___19614 = G__19615;
continue;
} else {
}
break;
}

var G__19612 = args19610.length;
switch (G__19612) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19610.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args19617 = [];
var len__17893__auto___19620 = arguments.length;
var i__17894__auto___19621 = (0);
while(true){
if((i__17894__auto___19621 < len__17893__auto___19620)){
args19617.push((arguments[i__17894__auto___19621]));

var G__19622 = (i__17894__auto___19621 + (1));
i__17894__auto___19621 = G__19622;
continue;
} else {
}
break;
}

var G__19619 = args19617.length;
switch (G__19619) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19617.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args19624 = [];
var len__17893__auto___19677 = arguments.length;
var i__17894__auto___19678 = (0);
while(true){
if((i__17894__auto___19678 < len__17893__auto___19677)){
args19624.push((arguments[i__17894__auto___19678]));

var G__19679 = (i__17894__auto___19678 + (1));
i__17894__auto___19678 = G__19679;
continue;
} else {
}
break;
}

var G__19626 = args19624.length;
switch (G__19626) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19624.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__19002__auto___19681 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___19681,tc,fc){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___19681,tc,fc){
return (function (state_19652){
var state_val_19653 = (state_19652[(1)]);
if((state_val_19653 === (7))){
var inst_19648 = (state_19652[(2)]);
var state_19652__$1 = state_19652;
var statearr_19654_19682 = state_19652__$1;
(statearr_19654_19682[(2)] = inst_19648);

(statearr_19654_19682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19653 === (1))){
var state_19652__$1 = state_19652;
var statearr_19655_19683 = state_19652__$1;
(statearr_19655_19683[(2)] = null);

(statearr_19655_19683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19653 === (4))){
var inst_19629 = (state_19652[(7)]);
var inst_19629__$1 = (state_19652[(2)]);
var inst_19630 = (inst_19629__$1 == null);
var state_19652__$1 = (function (){var statearr_19656 = state_19652;
(statearr_19656[(7)] = inst_19629__$1);

return statearr_19656;
})();
if(cljs.core.truth_(inst_19630)){
var statearr_19657_19684 = state_19652__$1;
(statearr_19657_19684[(1)] = (5));

} else {
var statearr_19658_19685 = state_19652__$1;
(statearr_19658_19685[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19653 === (13))){
var state_19652__$1 = state_19652;
var statearr_19659_19686 = state_19652__$1;
(statearr_19659_19686[(2)] = null);

(statearr_19659_19686[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19653 === (6))){
var inst_19629 = (state_19652[(7)]);
var inst_19635 = p.call(null,inst_19629);
var state_19652__$1 = state_19652;
if(cljs.core.truth_(inst_19635)){
var statearr_19660_19687 = state_19652__$1;
(statearr_19660_19687[(1)] = (9));

} else {
var statearr_19661_19688 = state_19652__$1;
(statearr_19661_19688[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19653 === (3))){
var inst_19650 = (state_19652[(2)]);
var state_19652__$1 = state_19652;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19652__$1,inst_19650);
} else {
if((state_val_19653 === (12))){
var state_19652__$1 = state_19652;
var statearr_19662_19689 = state_19652__$1;
(statearr_19662_19689[(2)] = null);

(statearr_19662_19689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19653 === (2))){
var state_19652__$1 = state_19652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19652__$1,(4),ch);
} else {
if((state_val_19653 === (11))){
var inst_19629 = (state_19652[(7)]);
var inst_19639 = (state_19652[(2)]);
var state_19652__$1 = state_19652;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19652__$1,(8),inst_19639,inst_19629);
} else {
if((state_val_19653 === (9))){
var state_19652__$1 = state_19652;
var statearr_19663_19690 = state_19652__$1;
(statearr_19663_19690[(2)] = tc);

(statearr_19663_19690[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19653 === (5))){
var inst_19632 = cljs.core.async.close_BANG_.call(null,tc);
var inst_19633 = cljs.core.async.close_BANG_.call(null,fc);
var state_19652__$1 = (function (){var statearr_19664 = state_19652;
(statearr_19664[(8)] = inst_19632);

return statearr_19664;
})();
var statearr_19665_19691 = state_19652__$1;
(statearr_19665_19691[(2)] = inst_19633);

(statearr_19665_19691[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19653 === (14))){
var inst_19646 = (state_19652[(2)]);
var state_19652__$1 = state_19652;
var statearr_19666_19692 = state_19652__$1;
(statearr_19666_19692[(2)] = inst_19646);

(statearr_19666_19692[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19653 === (10))){
var state_19652__$1 = state_19652;
var statearr_19667_19693 = state_19652__$1;
(statearr_19667_19693[(2)] = fc);

(statearr_19667_19693[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19653 === (8))){
var inst_19641 = (state_19652[(2)]);
var state_19652__$1 = state_19652;
if(cljs.core.truth_(inst_19641)){
var statearr_19668_19694 = state_19652__$1;
(statearr_19668_19694[(1)] = (12));

} else {
var statearr_19669_19695 = state_19652__$1;
(statearr_19669_19695[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto___19681,tc,fc))
;
return ((function (switch__18890__auto__,c__19002__auto___19681,tc,fc){
return (function() {
var cljs$core$async$state_machine__18891__auto__ = null;
var cljs$core$async$state_machine__18891__auto____0 = (function (){
var statearr_19673 = [null,null,null,null,null,null,null,null,null];
(statearr_19673[(0)] = cljs$core$async$state_machine__18891__auto__);

(statearr_19673[(1)] = (1));

return statearr_19673;
});
var cljs$core$async$state_machine__18891__auto____1 = (function (state_19652){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_19652);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e19674){if((e19674 instanceof Object)){
var ex__18894__auto__ = e19674;
var statearr_19675_19696 = state_19652;
(statearr_19675_19696[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19652);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19674;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19697 = state_19652;
state_19652 = G__19697;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$state_machine__18891__auto__ = function(state_19652){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18891__auto____1.call(this,state_19652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18891__auto____0;
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18891__auto____1;
return cljs$core$async$state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___19681,tc,fc))
})();
var state__19004__auto__ = (function (){var statearr_19676 = f__19003__auto__.call(null);
(statearr_19676[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___19681);

return statearr_19676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___19681,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__19002__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto__){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto__){
return (function (state_19761){
var state_val_19762 = (state_19761[(1)]);
if((state_val_19762 === (7))){
var inst_19757 = (state_19761[(2)]);
var state_19761__$1 = state_19761;
var statearr_19763_19784 = state_19761__$1;
(statearr_19763_19784[(2)] = inst_19757);

(statearr_19763_19784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19762 === (1))){
var inst_19741 = init;
var state_19761__$1 = (function (){var statearr_19764 = state_19761;
(statearr_19764[(7)] = inst_19741);

return statearr_19764;
})();
var statearr_19765_19785 = state_19761__$1;
(statearr_19765_19785[(2)] = null);

(statearr_19765_19785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19762 === (4))){
var inst_19744 = (state_19761[(8)]);
var inst_19744__$1 = (state_19761[(2)]);
var inst_19745 = (inst_19744__$1 == null);
var state_19761__$1 = (function (){var statearr_19766 = state_19761;
(statearr_19766[(8)] = inst_19744__$1);

return statearr_19766;
})();
if(cljs.core.truth_(inst_19745)){
var statearr_19767_19786 = state_19761__$1;
(statearr_19767_19786[(1)] = (5));

} else {
var statearr_19768_19787 = state_19761__$1;
(statearr_19768_19787[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19762 === (6))){
var inst_19744 = (state_19761[(8)]);
var inst_19748 = (state_19761[(9)]);
var inst_19741 = (state_19761[(7)]);
var inst_19748__$1 = f.call(null,inst_19741,inst_19744);
var inst_19749 = cljs.core.reduced_QMARK_.call(null,inst_19748__$1);
var state_19761__$1 = (function (){var statearr_19769 = state_19761;
(statearr_19769[(9)] = inst_19748__$1);

return statearr_19769;
})();
if(inst_19749){
var statearr_19770_19788 = state_19761__$1;
(statearr_19770_19788[(1)] = (8));

} else {
var statearr_19771_19789 = state_19761__$1;
(statearr_19771_19789[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19762 === (3))){
var inst_19759 = (state_19761[(2)]);
var state_19761__$1 = state_19761;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19761__$1,inst_19759);
} else {
if((state_val_19762 === (2))){
var state_19761__$1 = state_19761;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19761__$1,(4),ch);
} else {
if((state_val_19762 === (9))){
var inst_19748 = (state_19761[(9)]);
var inst_19741 = inst_19748;
var state_19761__$1 = (function (){var statearr_19772 = state_19761;
(statearr_19772[(7)] = inst_19741);

return statearr_19772;
})();
var statearr_19773_19790 = state_19761__$1;
(statearr_19773_19790[(2)] = null);

(statearr_19773_19790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19762 === (5))){
var inst_19741 = (state_19761[(7)]);
var state_19761__$1 = state_19761;
var statearr_19774_19791 = state_19761__$1;
(statearr_19774_19791[(2)] = inst_19741);

(statearr_19774_19791[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19762 === (10))){
var inst_19755 = (state_19761[(2)]);
var state_19761__$1 = state_19761;
var statearr_19775_19792 = state_19761__$1;
(statearr_19775_19792[(2)] = inst_19755);

(statearr_19775_19792[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19762 === (8))){
var inst_19748 = (state_19761[(9)]);
var inst_19751 = cljs.core.deref.call(null,inst_19748);
var state_19761__$1 = state_19761;
var statearr_19776_19793 = state_19761__$1;
(statearr_19776_19793[(2)] = inst_19751);

(statearr_19776_19793[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto__))
;
return ((function (switch__18890__auto__,c__19002__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__18891__auto__ = null;
var cljs$core$async$reduce_$_state_machine__18891__auto____0 = (function (){
var statearr_19780 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19780[(0)] = cljs$core$async$reduce_$_state_machine__18891__auto__);

(statearr_19780[(1)] = (1));

return statearr_19780;
});
var cljs$core$async$reduce_$_state_machine__18891__auto____1 = (function (state_19761){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_19761);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e19781){if((e19781 instanceof Object)){
var ex__18894__auto__ = e19781;
var statearr_19782_19794 = state_19761;
(statearr_19782_19794[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19761);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19781;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19795 = state_19761;
state_19761 = G__19795;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__18891__auto__ = function(state_19761){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__18891__auto____1.call(this,state_19761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__18891__auto____0;
cljs$core$async$reduce_$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__18891__auto____1;
return cljs$core$async$reduce_$_state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto__))
})();
var state__19004__auto__ = (function (){var statearr_19783 = f__19003__auto__.call(null);
(statearr_19783[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto__);

return statearr_19783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto__))
);

return c__19002__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args19796 = [];
var len__17893__auto___19848 = arguments.length;
var i__17894__auto___19849 = (0);
while(true){
if((i__17894__auto___19849 < len__17893__auto___19848)){
args19796.push((arguments[i__17894__auto___19849]));

var G__19850 = (i__17894__auto___19849 + (1));
i__17894__auto___19849 = G__19850;
continue;
} else {
}
break;
}

var G__19798 = args19796.length;
switch (G__19798) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19796.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__19002__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto__){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto__){
return (function (state_19823){
var state_val_19824 = (state_19823[(1)]);
if((state_val_19824 === (7))){
var inst_19805 = (state_19823[(2)]);
var state_19823__$1 = state_19823;
var statearr_19825_19852 = state_19823__$1;
(statearr_19825_19852[(2)] = inst_19805);

(statearr_19825_19852[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19824 === (1))){
var inst_19799 = cljs.core.seq.call(null,coll);
var inst_19800 = inst_19799;
var state_19823__$1 = (function (){var statearr_19826 = state_19823;
(statearr_19826[(7)] = inst_19800);

return statearr_19826;
})();
var statearr_19827_19853 = state_19823__$1;
(statearr_19827_19853[(2)] = null);

(statearr_19827_19853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19824 === (4))){
var inst_19800 = (state_19823[(7)]);
var inst_19803 = cljs.core.first.call(null,inst_19800);
var state_19823__$1 = state_19823;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19823__$1,(7),ch,inst_19803);
} else {
if((state_val_19824 === (13))){
var inst_19817 = (state_19823[(2)]);
var state_19823__$1 = state_19823;
var statearr_19828_19854 = state_19823__$1;
(statearr_19828_19854[(2)] = inst_19817);

(statearr_19828_19854[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19824 === (6))){
var inst_19808 = (state_19823[(2)]);
var state_19823__$1 = state_19823;
if(cljs.core.truth_(inst_19808)){
var statearr_19829_19855 = state_19823__$1;
(statearr_19829_19855[(1)] = (8));

} else {
var statearr_19830_19856 = state_19823__$1;
(statearr_19830_19856[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19824 === (3))){
var inst_19821 = (state_19823[(2)]);
var state_19823__$1 = state_19823;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19823__$1,inst_19821);
} else {
if((state_val_19824 === (12))){
var state_19823__$1 = state_19823;
var statearr_19831_19857 = state_19823__$1;
(statearr_19831_19857[(2)] = null);

(statearr_19831_19857[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19824 === (2))){
var inst_19800 = (state_19823[(7)]);
var state_19823__$1 = state_19823;
if(cljs.core.truth_(inst_19800)){
var statearr_19832_19858 = state_19823__$1;
(statearr_19832_19858[(1)] = (4));

} else {
var statearr_19833_19859 = state_19823__$1;
(statearr_19833_19859[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19824 === (11))){
var inst_19814 = cljs.core.async.close_BANG_.call(null,ch);
var state_19823__$1 = state_19823;
var statearr_19834_19860 = state_19823__$1;
(statearr_19834_19860[(2)] = inst_19814);

(statearr_19834_19860[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19824 === (9))){
var state_19823__$1 = state_19823;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19835_19861 = state_19823__$1;
(statearr_19835_19861[(1)] = (11));

} else {
var statearr_19836_19862 = state_19823__$1;
(statearr_19836_19862[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19824 === (5))){
var inst_19800 = (state_19823[(7)]);
var state_19823__$1 = state_19823;
var statearr_19837_19863 = state_19823__$1;
(statearr_19837_19863[(2)] = inst_19800);

(statearr_19837_19863[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19824 === (10))){
var inst_19819 = (state_19823[(2)]);
var state_19823__$1 = state_19823;
var statearr_19838_19864 = state_19823__$1;
(statearr_19838_19864[(2)] = inst_19819);

(statearr_19838_19864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19824 === (8))){
var inst_19800 = (state_19823[(7)]);
var inst_19810 = cljs.core.next.call(null,inst_19800);
var inst_19800__$1 = inst_19810;
var state_19823__$1 = (function (){var statearr_19839 = state_19823;
(statearr_19839[(7)] = inst_19800__$1);

return statearr_19839;
})();
var statearr_19840_19865 = state_19823__$1;
(statearr_19840_19865[(2)] = null);

(statearr_19840_19865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto__))
;
return ((function (switch__18890__auto__,c__19002__auto__){
return (function() {
var cljs$core$async$state_machine__18891__auto__ = null;
var cljs$core$async$state_machine__18891__auto____0 = (function (){
var statearr_19844 = [null,null,null,null,null,null,null,null];
(statearr_19844[(0)] = cljs$core$async$state_machine__18891__auto__);

(statearr_19844[(1)] = (1));

return statearr_19844;
});
var cljs$core$async$state_machine__18891__auto____1 = (function (state_19823){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_19823);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e19845){if((e19845 instanceof Object)){
var ex__18894__auto__ = e19845;
var statearr_19846_19866 = state_19823;
(statearr_19846_19866[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19823);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19845;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19867 = state_19823;
state_19823 = G__19867;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$state_machine__18891__auto__ = function(state_19823){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18891__auto____1.call(this,state_19823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18891__auto____0;
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18891__auto____1;
return cljs$core$async$state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto__))
})();
var state__19004__auto__ = (function (){var statearr_19847 = f__19003__auto__.call(null);
(statearr_19847[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto__);

return statearr_19847;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto__))
);

return c__19002__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__17490__auto__ = (((_ == null))?null:_);
var m__17491__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,_);
} else {
var m__17491__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__17490__auto__ = (((m == null))?null:m);
var m__17491__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__17491__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__17490__auto__ = (((m == null))?null:m);
var m__17491__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,m,ch);
} else {
var m__17491__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__17490__auto__ = (((m == null))?null:m);
var m__17491__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,m);
} else {
var m__17491__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20089 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20089 = (function (mult,ch,cs,meta20090){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta20090 = meta20090;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20089.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_20091,meta20090__$1){
var self__ = this;
var _20091__$1 = this;
return (new cljs.core.async.t_cljs$core$async20089(self__.mult,self__.ch,self__.cs,meta20090__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async20089.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_20091){
var self__ = this;
var _20091__$1 = this;
return self__.meta20090;
});})(cs))
;

cljs.core.async.t_cljs$core$async20089.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20089.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async20089.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async20089.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20089.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20089.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20089.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta20090","meta20090",-687821710,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async20089.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20089.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20089";

cljs.core.async.t_cljs$core$async20089.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__17433__auto__,writer__17434__auto__,opt__17435__auto__){
return cljs.core._write.call(null,writer__17434__auto__,"cljs.core.async/t_cljs$core$async20089");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async20089 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async20089(mult__$1,ch__$1,cs__$1,meta20090){
return (new cljs.core.async.t_cljs$core$async20089(mult__$1,ch__$1,cs__$1,meta20090));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async20089(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__19002__auto___20310 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___20310,cs,m,dchan,dctr,done){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___20310,cs,m,dchan,dctr,done){
return (function (state_20222){
var state_val_20223 = (state_20222[(1)]);
if((state_val_20223 === (7))){
var inst_20218 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
var statearr_20224_20311 = state_20222__$1;
(statearr_20224_20311[(2)] = inst_20218);

(statearr_20224_20311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (20))){
var inst_20123 = (state_20222[(7)]);
var inst_20133 = cljs.core.first.call(null,inst_20123);
var inst_20134 = cljs.core.nth.call(null,inst_20133,(0),null);
var inst_20135 = cljs.core.nth.call(null,inst_20133,(1),null);
var state_20222__$1 = (function (){var statearr_20225 = state_20222;
(statearr_20225[(8)] = inst_20134);

return statearr_20225;
})();
if(cljs.core.truth_(inst_20135)){
var statearr_20226_20312 = state_20222__$1;
(statearr_20226_20312[(1)] = (22));

} else {
var statearr_20227_20313 = state_20222__$1;
(statearr_20227_20313[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (27))){
var inst_20163 = (state_20222[(9)]);
var inst_20165 = (state_20222[(10)]);
var inst_20094 = (state_20222[(11)]);
var inst_20170 = (state_20222[(12)]);
var inst_20170__$1 = cljs.core._nth.call(null,inst_20163,inst_20165);
var inst_20171 = cljs.core.async.put_BANG_.call(null,inst_20170__$1,inst_20094,done);
var state_20222__$1 = (function (){var statearr_20228 = state_20222;
(statearr_20228[(12)] = inst_20170__$1);

return statearr_20228;
})();
if(cljs.core.truth_(inst_20171)){
var statearr_20229_20314 = state_20222__$1;
(statearr_20229_20314[(1)] = (30));

} else {
var statearr_20230_20315 = state_20222__$1;
(statearr_20230_20315[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (1))){
var state_20222__$1 = state_20222;
var statearr_20231_20316 = state_20222__$1;
(statearr_20231_20316[(2)] = null);

(statearr_20231_20316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (24))){
var inst_20123 = (state_20222[(7)]);
var inst_20140 = (state_20222[(2)]);
var inst_20141 = cljs.core.next.call(null,inst_20123);
var inst_20103 = inst_20141;
var inst_20104 = null;
var inst_20105 = (0);
var inst_20106 = (0);
var state_20222__$1 = (function (){var statearr_20232 = state_20222;
(statearr_20232[(13)] = inst_20140);

(statearr_20232[(14)] = inst_20106);

(statearr_20232[(15)] = inst_20104);

(statearr_20232[(16)] = inst_20103);

(statearr_20232[(17)] = inst_20105);

return statearr_20232;
})();
var statearr_20233_20317 = state_20222__$1;
(statearr_20233_20317[(2)] = null);

(statearr_20233_20317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (39))){
var state_20222__$1 = state_20222;
var statearr_20237_20318 = state_20222__$1;
(statearr_20237_20318[(2)] = null);

(statearr_20237_20318[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (4))){
var inst_20094 = (state_20222[(11)]);
var inst_20094__$1 = (state_20222[(2)]);
var inst_20095 = (inst_20094__$1 == null);
var state_20222__$1 = (function (){var statearr_20238 = state_20222;
(statearr_20238[(11)] = inst_20094__$1);

return statearr_20238;
})();
if(cljs.core.truth_(inst_20095)){
var statearr_20239_20319 = state_20222__$1;
(statearr_20239_20319[(1)] = (5));

} else {
var statearr_20240_20320 = state_20222__$1;
(statearr_20240_20320[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (15))){
var inst_20106 = (state_20222[(14)]);
var inst_20104 = (state_20222[(15)]);
var inst_20103 = (state_20222[(16)]);
var inst_20105 = (state_20222[(17)]);
var inst_20119 = (state_20222[(2)]);
var inst_20120 = (inst_20106 + (1));
var tmp20234 = inst_20104;
var tmp20235 = inst_20103;
var tmp20236 = inst_20105;
var inst_20103__$1 = tmp20235;
var inst_20104__$1 = tmp20234;
var inst_20105__$1 = tmp20236;
var inst_20106__$1 = inst_20120;
var state_20222__$1 = (function (){var statearr_20241 = state_20222;
(statearr_20241[(18)] = inst_20119);

(statearr_20241[(14)] = inst_20106__$1);

(statearr_20241[(15)] = inst_20104__$1);

(statearr_20241[(16)] = inst_20103__$1);

(statearr_20241[(17)] = inst_20105__$1);

return statearr_20241;
})();
var statearr_20242_20321 = state_20222__$1;
(statearr_20242_20321[(2)] = null);

(statearr_20242_20321[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (21))){
var inst_20144 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
var statearr_20246_20322 = state_20222__$1;
(statearr_20246_20322[(2)] = inst_20144);

(statearr_20246_20322[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (31))){
var inst_20170 = (state_20222[(12)]);
var inst_20174 = done.call(null,null);
var inst_20175 = cljs.core.async.untap_STAR_.call(null,m,inst_20170);
var state_20222__$1 = (function (){var statearr_20247 = state_20222;
(statearr_20247[(19)] = inst_20174);

return statearr_20247;
})();
var statearr_20248_20323 = state_20222__$1;
(statearr_20248_20323[(2)] = inst_20175);

(statearr_20248_20323[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (32))){
var inst_20162 = (state_20222[(20)]);
var inst_20164 = (state_20222[(21)]);
var inst_20163 = (state_20222[(9)]);
var inst_20165 = (state_20222[(10)]);
var inst_20177 = (state_20222[(2)]);
var inst_20178 = (inst_20165 + (1));
var tmp20243 = inst_20162;
var tmp20244 = inst_20164;
var tmp20245 = inst_20163;
var inst_20162__$1 = tmp20243;
var inst_20163__$1 = tmp20245;
var inst_20164__$1 = tmp20244;
var inst_20165__$1 = inst_20178;
var state_20222__$1 = (function (){var statearr_20249 = state_20222;
(statearr_20249[(20)] = inst_20162__$1);

(statearr_20249[(21)] = inst_20164__$1);

(statearr_20249[(9)] = inst_20163__$1);

(statearr_20249[(22)] = inst_20177);

(statearr_20249[(10)] = inst_20165__$1);

return statearr_20249;
})();
var statearr_20250_20324 = state_20222__$1;
(statearr_20250_20324[(2)] = null);

(statearr_20250_20324[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (40))){
var inst_20190 = (state_20222[(23)]);
var inst_20194 = done.call(null,null);
var inst_20195 = cljs.core.async.untap_STAR_.call(null,m,inst_20190);
var state_20222__$1 = (function (){var statearr_20251 = state_20222;
(statearr_20251[(24)] = inst_20194);

return statearr_20251;
})();
var statearr_20252_20325 = state_20222__$1;
(statearr_20252_20325[(2)] = inst_20195);

(statearr_20252_20325[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (33))){
var inst_20181 = (state_20222[(25)]);
var inst_20183 = cljs.core.chunked_seq_QMARK_.call(null,inst_20181);
var state_20222__$1 = state_20222;
if(inst_20183){
var statearr_20253_20326 = state_20222__$1;
(statearr_20253_20326[(1)] = (36));

} else {
var statearr_20254_20327 = state_20222__$1;
(statearr_20254_20327[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (13))){
var inst_20113 = (state_20222[(26)]);
var inst_20116 = cljs.core.async.close_BANG_.call(null,inst_20113);
var state_20222__$1 = state_20222;
var statearr_20255_20328 = state_20222__$1;
(statearr_20255_20328[(2)] = inst_20116);

(statearr_20255_20328[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (22))){
var inst_20134 = (state_20222[(8)]);
var inst_20137 = cljs.core.async.close_BANG_.call(null,inst_20134);
var state_20222__$1 = state_20222;
var statearr_20256_20329 = state_20222__$1;
(statearr_20256_20329[(2)] = inst_20137);

(statearr_20256_20329[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (36))){
var inst_20181 = (state_20222[(25)]);
var inst_20185 = cljs.core.chunk_first.call(null,inst_20181);
var inst_20186 = cljs.core.chunk_rest.call(null,inst_20181);
var inst_20187 = cljs.core.count.call(null,inst_20185);
var inst_20162 = inst_20186;
var inst_20163 = inst_20185;
var inst_20164 = inst_20187;
var inst_20165 = (0);
var state_20222__$1 = (function (){var statearr_20257 = state_20222;
(statearr_20257[(20)] = inst_20162);

(statearr_20257[(21)] = inst_20164);

(statearr_20257[(9)] = inst_20163);

(statearr_20257[(10)] = inst_20165);

return statearr_20257;
})();
var statearr_20258_20330 = state_20222__$1;
(statearr_20258_20330[(2)] = null);

(statearr_20258_20330[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (41))){
var inst_20181 = (state_20222[(25)]);
var inst_20197 = (state_20222[(2)]);
var inst_20198 = cljs.core.next.call(null,inst_20181);
var inst_20162 = inst_20198;
var inst_20163 = null;
var inst_20164 = (0);
var inst_20165 = (0);
var state_20222__$1 = (function (){var statearr_20259 = state_20222;
(statearr_20259[(20)] = inst_20162);

(statearr_20259[(21)] = inst_20164);

(statearr_20259[(9)] = inst_20163);

(statearr_20259[(27)] = inst_20197);

(statearr_20259[(10)] = inst_20165);

return statearr_20259;
})();
var statearr_20260_20331 = state_20222__$1;
(statearr_20260_20331[(2)] = null);

(statearr_20260_20331[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (43))){
var state_20222__$1 = state_20222;
var statearr_20261_20332 = state_20222__$1;
(statearr_20261_20332[(2)] = null);

(statearr_20261_20332[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (29))){
var inst_20206 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
var statearr_20262_20333 = state_20222__$1;
(statearr_20262_20333[(2)] = inst_20206);

(statearr_20262_20333[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (44))){
var inst_20215 = (state_20222[(2)]);
var state_20222__$1 = (function (){var statearr_20263 = state_20222;
(statearr_20263[(28)] = inst_20215);

return statearr_20263;
})();
var statearr_20264_20334 = state_20222__$1;
(statearr_20264_20334[(2)] = null);

(statearr_20264_20334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (6))){
var inst_20154 = (state_20222[(29)]);
var inst_20153 = cljs.core.deref.call(null,cs);
var inst_20154__$1 = cljs.core.keys.call(null,inst_20153);
var inst_20155 = cljs.core.count.call(null,inst_20154__$1);
var inst_20156 = cljs.core.reset_BANG_.call(null,dctr,inst_20155);
var inst_20161 = cljs.core.seq.call(null,inst_20154__$1);
var inst_20162 = inst_20161;
var inst_20163 = null;
var inst_20164 = (0);
var inst_20165 = (0);
var state_20222__$1 = (function (){var statearr_20265 = state_20222;
(statearr_20265[(30)] = inst_20156);

(statearr_20265[(20)] = inst_20162);

(statearr_20265[(21)] = inst_20164);

(statearr_20265[(9)] = inst_20163);

(statearr_20265[(29)] = inst_20154__$1);

(statearr_20265[(10)] = inst_20165);

return statearr_20265;
})();
var statearr_20266_20335 = state_20222__$1;
(statearr_20266_20335[(2)] = null);

(statearr_20266_20335[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (28))){
var inst_20162 = (state_20222[(20)]);
var inst_20181 = (state_20222[(25)]);
var inst_20181__$1 = cljs.core.seq.call(null,inst_20162);
var state_20222__$1 = (function (){var statearr_20267 = state_20222;
(statearr_20267[(25)] = inst_20181__$1);

return statearr_20267;
})();
if(inst_20181__$1){
var statearr_20268_20336 = state_20222__$1;
(statearr_20268_20336[(1)] = (33));

} else {
var statearr_20269_20337 = state_20222__$1;
(statearr_20269_20337[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (25))){
var inst_20164 = (state_20222[(21)]);
var inst_20165 = (state_20222[(10)]);
var inst_20167 = (inst_20165 < inst_20164);
var inst_20168 = inst_20167;
var state_20222__$1 = state_20222;
if(cljs.core.truth_(inst_20168)){
var statearr_20270_20338 = state_20222__$1;
(statearr_20270_20338[(1)] = (27));

} else {
var statearr_20271_20339 = state_20222__$1;
(statearr_20271_20339[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (34))){
var state_20222__$1 = state_20222;
var statearr_20272_20340 = state_20222__$1;
(statearr_20272_20340[(2)] = null);

(statearr_20272_20340[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (17))){
var state_20222__$1 = state_20222;
var statearr_20273_20341 = state_20222__$1;
(statearr_20273_20341[(2)] = null);

(statearr_20273_20341[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (3))){
var inst_20220 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20222__$1,inst_20220);
} else {
if((state_val_20223 === (12))){
var inst_20149 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
var statearr_20274_20342 = state_20222__$1;
(statearr_20274_20342[(2)] = inst_20149);

(statearr_20274_20342[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (2))){
var state_20222__$1 = state_20222;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20222__$1,(4),ch);
} else {
if((state_val_20223 === (23))){
var state_20222__$1 = state_20222;
var statearr_20275_20343 = state_20222__$1;
(statearr_20275_20343[(2)] = null);

(statearr_20275_20343[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (35))){
var inst_20204 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
var statearr_20276_20344 = state_20222__$1;
(statearr_20276_20344[(2)] = inst_20204);

(statearr_20276_20344[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (19))){
var inst_20123 = (state_20222[(7)]);
var inst_20127 = cljs.core.chunk_first.call(null,inst_20123);
var inst_20128 = cljs.core.chunk_rest.call(null,inst_20123);
var inst_20129 = cljs.core.count.call(null,inst_20127);
var inst_20103 = inst_20128;
var inst_20104 = inst_20127;
var inst_20105 = inst_20129;
var inst_20106 = (0);
var state_20222__$1 = (function (){var statearr_20277 = state_20222;
(statearr_20277[(14)] = inst_20106);

(statearr_20277[(15)] = inst_20104);

(statearr_20277[(16)] = inst_20103);

(statearr_20277[(17)] = inst_20105);

return statearr_20277;
})();
var statearr_20278_20345 = state_20222__$1;
(statearr_20278_20345[(2)] = null);

(statearr_20278_20345[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (11))){
var inst_20123 = (state_20222[(7)]);
var inst_20103 = (state_20222[(16)]);
var inst_20123__$1 = cljs.core.seq.call(null,inst_20103);
var state_20222__$1 = (function (){var statearr_20279 = state_20222;
(statearr_20279[(7)] = inst_20123__$1);

return statearr_20279;
})();
if(inst_20123__$1){
var statearr_20280_20346 = state_20222__$1;
(statearr_20280_20346[(1)] = (16));

} else {
var statearr_20281_20347 = state_20222__$1;
(statearr_20281_20347[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (9))){
var inst_20151 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
var statearr_20282_20348 = state_20222__$1;
(statearr_20282_20348[(2)] = inst_20151);

(statearr_20282_20348[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (5))){
var inst_20101 = cljs.core.deref.call(null,cs);
var inst_20102 = cljs.core.seq.call(null,inst_20101);
var inst_20103 = inst_20102;
var inst_20104 = null;
var inst_20105 = (0);
var inst_20106 = (0);
var state_20222__$1 = (function (){var statearr_20283 = state_20222;
(statearr_20283[(14)] = inst_20106);

(statearr_20283[(15)] = inst_20104);

(statearr_20283[(16)] = inst_20103);

(statearr_20283[(17)] = inst_20105);

return statearr_20283;
})();
var statearr_20284_20349 = state_20222__$1;
(statearr_20284_20349[(2)] = null);

(statearr_20284_20349[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (14))){
var state_20222__$1 = state_20222;
var statearr_20285_20350 = state_20222__$1;
(statearr_20285_20350[(2)] = null);

(statearr_20285_20350[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (45))){
var inst_20212 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
var statearr_20286_20351 = state_20222__$1;
(statearr_20286_20351[(2)] = inst_20212);

(statearr_20286_20351[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (26))){
var inst_20154 = (state_20222[(29)]);
var inst_20208 = (state_20222[(2)]);
var inst_20209 = cljs.core.seq.call(null,inst_20154);
var state_20222__$1 = (function (){var statearr_20287 = state_20222;
(statearr_20287[(31)] = inst_20208);

return statearr_20287;
})();
if(inst_20209){
var statearr_20288_20352 = state_20222__$1;
(statearr_20288_20352[(1)] = (42));

} else {
var statearr_20289_20353 = state_20222__$1;
(statearr_20289_20353[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (16))){
var inst_20123 = (state_20222[(7)]);
var inst_20125 = cljs.core.chunked_seq_QMARK_.call(null,inst_20123);
var state_20222__$1 = state_20222;
if(inst_20125){
var statearr_20290_20354 = state_20222__$1;
(statearr_20290_20354[(1)] = (19));

} else {
var statearr_20291_20355 = state_20222__$1;
(statearr_20291_20355[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (38))){
var inst_20201 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
var statearr_20292_20356 = state_20222__$1;
(statearr_20292_20356[(2)] = inst_20201);

(statearr_20292_20356[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (30))){
var state_20222__$1 = state_20222;
var statearr_20293_20357 = state_20222__$1;
(statearr_20293_20357[(2)] = null);

(statearr_20293_20357[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (10))){
var inst_20106 = (state_20222[(14)]);
var inst_20104 = (state_20222[(15)]);
var inst_20112 = cljs.core._nth.call(null,inst_20104,inst_20106);
var inst_20113 = cljs.core.nth.call(null,inst_20112,(0),null);
var inst_20114 = cljs.core.nth.call(null,inst_20112,(1),null);
var state_20222__$1 = (function (){var statearr_20294 = state_20222;
(statearr_20294[(26)] = inst_20113);

return statearr_20294;
})();
if(cljs.core.truth_(inst_20114)){
var statearr_20295_20358 = state_20222__$1;
(statearr_20295_20358[(1)] = (13));

} else {
var statearr_20296_20359 = state_20222__$1;
(statearr_20296_20359[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (18))){
var inst_20147 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
var statearr_20297_20360 = state_20222__$1;
(statearr_20297_20360[(2)] = inst_20147);

(statearr_20297_20360[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (42))){
var state_20222__$1 = state_20222;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20222__$1,(45),dchan);
} else {
if((state_val_20223 === (37))){
var inst_20181 = (state_20222[(25)]);
var inst_20190 = (state_20222[(23)]);
var inst_20094 = (state_20222[(11)]);
var inst_20190__$1 = cljs.core.first.call(null,inst_20181);
var inst_20191 = cljs.core.async.put_BANG_.call(null,inst_20190__$1,inst_20094,done);
var state_20222__$1 = (function (){var statearr_20298 = state_20222;
(statearr_20298[(23)] = inst_20190__$1);

return statearr_20298;
})();
if(cljs.core.truth_(inst_20191)){
var statearr_20299_20361 = state_20222__$1;
(statearr_20299_20361[(1)] = (39));

} else {
var statearr_20300_20362 = state_20222__$1;
(statearr_20300_20362[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (8))){
var inst_20106 = (state_20222[(14)]);
var inst_20105 = (state_20222[(17)]);
var inst_20108 = (inst_20106 < inst_20105);
var inst_20109 = inst_20108;
var state_20222__$1 = state_20222;
if(cljs.core.truth_(inst_20109)){
var statearr_20301_20363 = state_20222__$1;
(statearr_20301_20363[(1)] = (10));

} else {
var statearr_20302_20364 = state_20222__$1;
(statearr_20302_20364[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto___20310,cs,m,dchan,dctr,done))
;
return ((function (switch__18890__auto__,c__19002__auto___20310,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__18891__auto__ = null;
var cljs$core$async$mult_$_state_machine__18891__auto____0 = (function (){
var statearr_20306 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20306[(0)] = cljs$core$async$mult_$_state_machine__18891__auto__);

(statearr_20306[(1)] = (1));

return statearr_20306;
});
var cljs$core$async$mult_$_state_machine__18891__auto____1 = (function (state_20222){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_20222);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e20307){if((e20307 instanceof Object)){
var ex__18894__auto__ = e20307;
var statearr_20308_20365 = state_20222;
(statearr_20308_20365[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20222);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20307;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20366 = state_20222;
state_20222 = G__20366;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__18891__auto__ = function(state_20222){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__18891__auto____1.call(this,state_20222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__18891__auto____0;
cljs$core$async$mult_$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__18891__auto____1;
return cljs$core$async$mult_$_state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___20310,cs,m,dchan,dctr,done))
})();
var state__19004__auto__ = (function (){var statearr_20309 = f__19003__auto__.call(null);
(statearr_20309[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___20310);

return statearr_20309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___20310,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args20367 = [];
var len__17893__auto___20370 = arguments.length;
var i__17894__auto___20371 = (0);
while(true){
if((i__17894__auto___20371 < len__17893__auto___20370)){
args20367.push((arguments[i__17894__auto___20371]));

var G__20372 = (i__17894__auto___20371 + (1));
i__17894__auto___20371 = G__20372;
continue;
} else {
}
break;
}

var G__20369 = args20367.length;
switch (G__20369) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20367.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__17490__auto__ = (((m == null))?null:m);
var m__17491__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,m,ch);
} else {
var m__17491__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__17490__auto__ = (((m == null))?null:m);
var m__17491__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,m,ch);
} else {
var m__17491__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__17490__auto__ = (((m == null))?null:m);
var m__17491__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,m);
} else {
var m__17491__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__17490__auto__ = (((m == null))?null:m);
var m__17491__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,m,state_map);
} else {
var m__17491__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__17490__auto__ = (((m == null))?null:m);
var m__17491__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,m,mode);
} else {
var m__17491__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__17900__auto__ = [];
var len__17893__auto___20384 = arguments.length;
var i__17894__auto___20385 = (0);
while(true){
if((i__17894__auto___20385 < len__17893__auto___20384)){
args__17900__auto__.push((arguments[i__17894__auto___20385]));

var G__20386 = (i__17894__auto___20385 + (1));
i__17894__auto___20385 = G__20386;
continue;
} else {
}
break;
}

var argseq__17901__auto__ = ((((3) < args__17900__auto__.length))?(new cljs.core.IndexedSeq(args__17900__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__17901__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__20378){
var map__20379 = p__20378;
var map__20379__$1 = ((((!((map__20379 == null)))?((((map__20379.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20379.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20379):map__20379);
var opts = map__20379__$1;
var statearr_20381_20387 = state;
(statearr_20381_20387[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__20379,map__20379__$1,opts){
return (function (val){
var statearr_20382_20388 = state;
(statearr_20382_20388[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__20379,map__20379__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_20383_20389 = state;
(statearr_20383_20389[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq20374){
var G__20375 = cljs.core.first.call(null,seq20374);
var seq20374__$1 = cljs.core.next.call(null,seq20374);
var G__20376 = cljs.core.first.call(null,seq20374__$1);
var seq20374__$2 = cljs.core.next.call(null,seq20374__$1);
var G__20377 = cljs.core.first.call(null,seq20374__$2);
var seq20374__$3 = cljs.core.next.call(null,seq20374__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20375,G__20376,G__20377,seq20374__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20553 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20553 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta20554){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta20554 = meta20554;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20553.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20555,meta20554__$1){
var self__ = this;
var _20555__$1 = this;
return (new cljs.core.async.t_cljs$core$async20553(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta20554__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20553.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20555){
var self__ = this;
var _20555__$1 = this;
return self__.meta20554;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20553.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20553.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20553.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async20553.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20553.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20553.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20553.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20553.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20553.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta20554","meta20554",838990199,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20553.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20553.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20553";

cljs.core.async.t_cljs$core$async20553.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__17433__auto__,writer__17434__auto__,opt__17435__auto__){
return cljs.core._write.call(null,writer__17434__auto__,"cljs.core.async/t_cljs$core$async20553");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async20553 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async20553(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20554){
return (new cljs.core.async.t_cljs$core$async20553(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20554));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async20553(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19002__auto___20716 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___20716,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___20716,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_20653){
var state_val_20654 = (state_20653[(1)]);
if((state_val_20654 === (7))){
var inst_20571 = (state_20653[(2)]);
var state_20653__$1 = state_20653;
var statearr_20655_20717 = state_20653__$1;
(statearr_20655_20717[(2)] = inst_20571);

(statearr_20655_20717[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (20))){
var inst_20583 = (state_20653[(7)]);
var state_20653__$1 = state_20653;
var statearr_20656_20718 = state_20653__$1;
(statearr_20656_20718[(2)] = inst_20583);

(statearr_20656_20718[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (27))){
var state_20653__$1 = state_20653;
var statearr_20657_20719 = state_20653__$1;
(statearr_20657_20719[(2)] = null);

(statearr_20657_20719[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (1))){
var inst_20559 = (state_20653[(8)]);
var inst_20559__$1 = calc_state.call(null);
var inst_20561 = (inst_20559__$1 == null);
var inst_20562 = cljs.core.not.call(null,inst_20561);
var state_20653__$1 = (function (){var statearr_20658 = state_20653;
(statearr_20658[(8)] = inst_20559__$1);

return statearr_20658;
})();
if(inst_20562){
var statearr_20659_20720 = state_20653__$1;
(statearr_20659_20720[(1)] = (2));

} else {
var statearr_20660_20721 = state_20653__$1;
(statearr_20660_20721[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (24))){
var inst_20627 = (state_20653[(9)]);
var inst_20613 = (state_20653[(10)]);
var inst_20606 = (state_20653[(11)]);
var inst_20627__$1 = inst_20606.call(null,inst_20613);
var state_20653__$1 = (function (){var statearr_20661 = state_20653;
(statearr_20661[(9)] = inst_20627__$1);

return statearr_20661;
})();
if(cljs.core.truth_(inst_20627__$1)){
var statearr_20662_20722 = state_20653__$1;
(statearr_20662_20722[(1)] = (29));

} else {
var statearr_20663_20723 = state_20653__$1;
(statearr_20663_20723[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (4))){
var inst_20574 = (state_20653[(2)]);
var state_20653__$1 = state_20653;
if(cljs.core.truth_(inst_20574)){
var statearr_20664_20724 = state_20653__$1;
(statearr_20664_20724[(1)] = (8));

} else {
var statearr_20665_20725 = state_20653__$1;
(statearr_20665_20725[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (15))){
var inst_20600 = (state_20653[(2)]);
var state_20653__$1 = state_20653;
if(cljs.core.truth_(inst_20600)){
var statearr_20666_20726 = state_20653__$1;
(statearr_20666_20726[(1)] = (19));

} else {
var statearr_20667_20727 = state_20653__$1;
(statearr_20667_20727[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (21))){
var inst_20605 = (state_20653[(12)]);
var inst_20605__$1 = (state_20653[(2)]);
var inst_20606 = cljs.core.get.call(null,inst_20605__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20607 = cljs.core.get.call(null,inst_20605__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20608 = cljs.core.get.call(null,inst_20605__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_20653__$1 = (function (){var statearr_20668 = state_20653;
(statearr_20668[(13)] = inst_20607);

(statearr_20668[(12)] = inst_20605__$1);

(statearr_20668[(11)] = inst_20606);

return statearr_20668;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_20653__$1,(22),inst_20608);
} else {
if((state_val_20654 === (31))){
var inst_20635 = (state_20653[(2)]);
var state_20653__$1 = state_20653;
if(cljs.core.truth_(inst_20635)){
var statearr_20669_20728 = state_20653__$1;
(statearr_20669_20728[(1)] = (32));

} else {
var statearr_20670_20729 = state_20653__$1;
(statearr_20670_20729[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (32))){
var inst_20612 = (state_20653[(14)]);
var state_20653__$1 = state_20653;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20653__$1,(35),out,inst_20612);
} else {
if((state_val_20654 === (33))){
var inst_20605 = (state_20653[(12)]);
var inst_20583 = inst_20605;
var state_20653__$1 = (function (){var statearr_20671 = state_20653;
(statearr_20671[(7)] = inst_20583);

return statearr_20671;
})();
var statearr_20672_20730 = state_20653__$1;
(statearr_20672_20730[(2)] = null);

(statearr_20672_20730[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (13))){
var inst_20583 = (state_20653[(7)]);
var inst_20590 = inst_20583.cljs$lang$protocol_mask$partition0$;
var inst_20591 = (inst_20590 & (64));
var inst_20592 = inst_20583.cljs$core$ISeq$;
var inst_20593 = (inst_20591) || (inst_20592);
var state_20653__$1 = state_20653;
if(cljs.core.truth_(inst_20593)){
var statearr_20673_20731 = state_20653__$1;
(statearr_20673_20731[(1)] = (16));

} else {
var statearr_20674_20732 = state_20653__$1;
(statearr_20674_20732[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (22))){
var inst_20612 = (state_20653[(14)]);
var inst_20613 = (state_20653[(10)]);
var inst_20611 = (state_20653[(2)]);
var inst_20612__$1 = cljs.core.nth.call(null,inst_20611,(0),null);
var inst_20613__$1 = cljs.core.nth.call(null,inst_20611,(1),null);
var inst_20614 = (inst_20612__$1 == null);
var inst_20615 = cljs.core._EQ_.call(null,inst_20613__$1,change);
var inst_20616 = (inst_20614) || (inst_20615);
var state_20653__$1 = (function (){var statearr_20675 = state_20653;
(statearr_20675[(14)] = inst_20612__$1);

(statearr_20675[(10)] = inst_20613__$1);

return statearr_20675;
})();
if(cljs.core.truth_(inst_20616)){
var statearr_20676_20733 = state_20653__$1;
(statearr_20676_20733[(1)] = (23));

} else {
var statearr_20677_20734 = state_20653__$1;
(statearr_20677_20734[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (36))){
var inst_20605 = (state_20653[(12)]);
var inst_20583 = inst_20605;
var state_20653__$1 = (function (){var statearr_20678 = state_20653;
(statearr_20678[(7)] = inst_20583);

return statearr_20678;
})();
var statearr_20679_20735 = state_20653__$1;
(statearr_20679_20735[(2)] = null);

(statearr_20679_20735[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (29))){
var inst_20627 = (state_20653[(9)]);
var state_20653__$1 = state_20653;
var statearr_20680_20736 = state_20653__$1;
(statearr_20680_20736[(2)] = inst_20627);

(statearr_20680_20736[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (6))){
var state_20653__$1 = state_20653;
var statearr_20681_20737 = state_20653__$1;
(statearr_20681_20737[(2)] = false);

(statearr_20681_20737[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (28))){
var inst_20623 = (state_20653[(2)]);
var inst_20624 = calc_state.call(null);
var inst_20583 = inst_20624;
var state_20653__$1 = (function (){var statearr_20682 = state_20653;
(statearr_20682[(7)] = inst_20583);

(statearr_20682[(15)] = inst_20623);

return statearr_20682;
})();
var statearr_20683_20738 = state_20653__$1;
(statearr_20683_20738[(2)] = null);

(statearr_20683_20738[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (25))){
var inst_20649 = (state_20653[(2)]);
var state_20653__$1 = state_20653;
var statearr_20684_20739 = state_20653__$1;
(statearr_20684_20739[(2)] = inst_20649);

(statearr_20684_20739[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (34))){
var inst_20647 = (state_20653[(2)]);
var state_20653__$1 = state_20653;
var statearr_20685_20740 = state_20653__$1;
(statearr_20685_20740[(2)] = inst_20647);

(statearr_20685_20740[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (17))){
var state_20653__$1 = state_20653;
var statearr_20686_20741 = state_20653__$1;
(statearr_20686_20741[(2)] = false);

(statearr_20686_20741[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (3))){
var state_20653__$1 = state_20653;
var statearr_20687_20742 = state_20653__$1;
(statearr_20687_20742[(2)] = false);

(statearr_20687_20742[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (12))){
var inst_20651 = (state_20653[(2)]);
var state_20653__$1 = state_20653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20653__$1,inst_20651);
} else {
if((state_val_20654 === (2))){
var inst_20559 = (state_20653[(8)]);
var inst_20564 = inst_20559.cljs$lang$protocol_mask$partition0$;
var inst_20565 = (inst_20564 & (64));
var inst_20566 = inst_20559.cljs$core$ISeq$;
var inst_20567 = (inst_20565) || (inst_20566);
var state_20653__$1 = state_20653;
if(cljs.core.truth_(inst_20567)){
var statearr_20688_20743 = state_20653__$1;
(statearr_20688_20743[(1)] = (5));

} else {
var statearr_20689_20744 = state_20653__$1;
(statearr_20689_20744[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (23))){
var inst_20612 = (state_20653[(14)]);
var inst_20618 = (inst_20612 == null);
var state_20653__$1 = state_20653;
if(cljs.core.truth_(inst_20618)){
var statearr_20690_20745 = state_20653__$1;
(statearr_20690_20745[(1)] = (26));

} else {
var statearr_20691_20746 = state_20653__$1;
(statearr_20691_20746[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (35))){
var inst_20638 = (state_20653[(2)]);
var state_20653__$1 = state_20653;
if(cljs.core.truth_(inst_20638)){
var statearr_20692_20747 = state_20653__$1;
(statearr_20692_20747[(1)] = (36));

} else {
var statearr_20693_20748 = state_20653__$1;
(statearr_20693_20748[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (19))){
var inst_20583 = (state_20653[(7)]);
var inst_20602 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20583);
var state_20653__$1 = state_20653;
var statearr_20694_20749 = state_20653__$1;
(statearr_20694_20749[(2)] = inst_20602);

(statearr_20694_20749[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (11))){
var inst_20583 = (state_20653[(7)]);
var inst_20587 = (inst_20583 == null);
var inst_20588 = cljs.core.not.call(null,inst_20587);
var state_20653__$1 = state_20653;
if(inst_20588){
var statearr_20695_20750 = state_20653__$1;
(statearr_20695_20750[(1)] = (13));

} else {
var statearr_20696_20751 = state_20653__$1;
(statearr_20696_20751[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (9))){
var inst_20559 = (state_20653[(8)]);
var state_20653__$1 = state_20653;
var statearr_20697_20752 = state_20653__$1;
(statearr_20697_20752[(2)] = inst_20559);

(statearr_20697_20752[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (5))){
var state_20653__$1 = state_20653;
var statearr_20698_20753 = state_20653__$1;
(statearr_20698_20753[(2)] = true);

(statearr_20698_20753[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (14))){
var state_20653__$1 = state_20653;
var statearr_20699_20754 = state_20653__$1;
(statearr_20699_20754[(2)] = false);

(statearr_20699_20754[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (26))){
var inst_20613 = (state_20653[(10)]);
var inst_20620 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_20613);
var state_20653__$1 = state_20653;
var statearr_20700_20755 = state_20653__$1;
(statearr_20700_20755[(2)] = inst_20620);

(statearr_20700_20755[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (16))){
var state_20653__$1 = state_20653;
var statearr_20701_20756 = state_20653__$1;
(statearr_20701_20756[(2)] = true);

(statearr_20701_20756[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (38))){
var inst_20643 = (state_20653[(2)]);
var state_20653__$1 = state_20653;
var statearr_20702_20757 = state_20653__$1;
(statearr_20702_20757[(2)] = inst_20643);

(statearr_20702_20757[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (30))){
var inst_20607 = (state_20653[(13)]);
var inst_20613 = (state_20653[(10)]);
var inst_20606 = (state_20653[(11)]);
var inst_20630 = cljs.core.empty_QMARK_.call(null,inst_20606);
var inst_20631 = inst_20607.call(null,inst_20613);
var inst_20632 = cljs.core.not.call(null,inst_20631);
var inst_20633 = (inst_20630) && (inst_20632);
var state_20653__$1 = state_20653;
var statearr_20703_20758 = state_20653__$1;
(statearr_20703_20758[(2)] = inst_20633);

(statearr_20703_20758[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (10))){
var inst_20559 = (state_20653[(8)]);
var inst_20579 = (state_20653[(2)]);
var inst_20580 = cljs.core.get.call(null,inst_20579,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20581 = cljs.core.get.call(null,inst_20579,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20582 = cljs.core.get.call(null,inst_20579,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_20583 = inst_20559;
var state_20653__$1 = (function (){var statearr_20704 = state_20653;
(statearr_20704[(7)] = inst_20583);

(statearr_20704[(16)] = inst_20582);

(statearr_20704[(17)] = inst_20580);

(statearr_20704[(18)] = inst_20581);

return statearr_20704;
})();
var statearr_20705_20759 = state_20653__$1;
(statearr_20705_20759[(2)] = null);

(statearr_20705_20759[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (18))){
var inst_20597 = (state_20653[(2)]);
var state_20653__$1 = state_20653;
var statearr_20706_20760 = state_20653__$1;
(statearr_20706_20760[(2)] = inst_20597);

(statearr_20706_20760[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (37))){
var state_20653__$1 = state_20653;
var statearr_20707_20761 = state_20653__$1;
(statearr_20707_20761[(2)] = null);

(statearr_20707_20761[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20654 === (8))){
var inst_20559 = (state_20653[(8)]);
var inst_20576 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20559);
var state_20653__$1 = state_20653;
var statearr_20708_20762 = state_20653__$1;
(statearr_20708_20762[(2)] = inst_20576);

(statearr_20708_20762[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto___20716,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__18890__auto__,c__19002__auto___20716,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__18891__auto__ = null;
var cljs$core$async$mix_$_state_machine__18891__auto____0 = (function (){
var statearr_20712 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20712[(0)] = cljs$core$async$mix_$_state_machine__18891__auto__);

(statearr_20712[(1)] = (1));

return statearr_20712;
});
var cljs$core$async$mix_$_state_machine__18891__auto____1 = (function (state_20653){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_20653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e20713){if((e20713 instanceof Object)){
var ex__18894__auto__ = e20713;
var statearr_20714_20763 = state_20653;
(statearr_20714_20763[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20653);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20713;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20764 = state_20653;
state_20653 = G__20764;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__18891__auto__ = function(state_20653){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__18891__auto____1.call(this,state_20653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__18891__auto____0;
cljs$core$async$mix_$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__18891__auto____1;
return cljs$core$async$mix_$_state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___20716,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__19004__auto__ = (function (){var statearr_20715 = f__19003__auto__.call(null);
(statearr_20715[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___20716);

return statearr_20715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___20716,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__17490__auto__ = (((p == null))?null:p);
var m__17491__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__17491__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__17490__auto__ = (((p == null))?null:p);
var m__17491__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,p,v,ch);
} else {
var m__17491__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args20765 = [];
var len__17893__auto___20768 = arguments.length;
var i__17894__auto___20769 = (0);
while(true){
if((i__17894__auto___20769 < len__17893__auto___20768)){
args20765.push((arguments[i__17894__auto___20769]));

var G__20770 = (i__17894__auto___20769 + (1));
i__17894__auto___20769 = G__20770;
continue;
} else {
}
break;
}

var G__20767 = args20765.length;
switch (G__20767) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20765.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__17490__auto__ = (((p == null))?null:p);
var m__17491__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,p);
} else {
var m__17491__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__17490__auto__ = (((p == null))?null:p);
var m__17491__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,p,v);
} else {
var m__17491__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args20773 = [];
var len__17893__auto___20898 = arguments.length;
var i__17894__auto___20899 = (0);
while(true){
if((i__17894__auto___20899 < len__17893__auto___20898)){
args20773.push((arguments[i__17894__auto___20899]));

var G__20900 = (i__17894__auto___20899 + (1));
i__17894__auto___20899 = G__20900;
continue;
} else {
}
break;
}

var G__20775 = args20773.length;
switch (G__20775) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20773.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__16835__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__16835__auto__)){
return or__16835__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__16835__auto__,mults){
return (function (p1__20772_SHARP_){
if(cljs.core.truth_(p1__20772_SHARP_.call(null,topic))){
return p1__20772_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__20772_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__16835__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async20776 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20776 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta20777){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta20777 = meta20777;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20776.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_20778,meta20777__$1){
var self__ = this;
var _20778__$1 = this;
return (new cljs.core.async.t_cljs$core$async20776(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta20777__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20776.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_20778){
var self__ = this;
var _20778__$1 = this;
return self__.meta20777;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20776.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20776.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20776.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async20776.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20776.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20776.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20776.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20776.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta20777","meta20777",1497400002,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20776.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20776.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20776";

cljs.core.async.t_cljs$core$async20776.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__17433__auto__,writer__17434__auto__,opt__17435__auto__){
return cljs.core._write.call(null,writer__17434__auto__,"cljs.core.async/t_cljs$core$async20776");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async20776 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async20776(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20777){
return (new cljs.core.async.t_cljs$core$async20776(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20777));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async20776(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19002__auto___20902 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___20902,mults,ensure_mult,p){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___20902,mults,ensure_mult,p){
return (function (state_20850){
var state_val_20851 = (state_20850[(1)]);
if((state_val_20851 === (7))){
var inst_20846 = (state_20850[(2)]);
var state_20850__$1 = state_20850;
var statearr_20852_20903 = state_20850__$1;
(statearr_20852_20903[(2)] = inst_20846);

(statearr_20852_20903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (20))){
var state_20850__$1 = state_20850;
var statearr_20853_20904 = state_20850__$1;
(statearr_20853_20904[(2)] = null);

(statearr_20853_20904[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (1))){
var state_20850__$1 = state_20850;
var statearr_20854_20905 = state_20850__$1;
(statearr_20854_20905[(2)] = null);

(statearr_20854_20905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (24))){
var inst_20829 = (state_20850[(7)]);
var inst_20838 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_20829);
var state_20850__$1 = state_20850;
var statearr_20855_20906 = state_20850__$1;
(statearr_20855_20906[(2)] = inst_20838);

(statearr_20855_20906[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (4))){
var inst_20781 = (state_20850[(8)]);
var inst_20781__$1 = (state_20850[(2)]);
var inst_20782 = (inst_20781__$1 == null);
var state_20850__$1 = (function (){var statearr_20856 = state_20850;
(statearr_20856[(8)] = inst_20781__$1);

return statearr_20856;
})();
if(cljs.core.truth_(inst_20782)){
var statearr_20857_20907 = state_20850__$1;
(statearr_20857_20907[(1)] = (5));

} else {
var statearr_20858_20908 = state_20850__$1;
(statearr_20858_20908[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (15))){
var inst_20823 = (state_20850[(2)]);
var state_20850__$1 = state_20850;
var statearr_20859_20909 = state_20850__$1;
(statearr_20859_20909[(2)] = inst_20823);

(statearr_20859_20909[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (21))){
var inst_20843 = (state_20850[(2)]);
var state_20850__$1 = (function (){var statearr_20860 = state_20850;
(statearr_20860[(9)] = inst_20843);

return statearr_20860;
})();
var statearr_20861_20910 = state_20850__$1;
(statearr_20861_20910[(2)] = null);

(statearr_20861_20910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (13))){
var inst_20805 = (state_20850[(10)]);
var inst_20807 = cljs.core.chunked_seq_QMARK_.call(null,inst_20805);
var state_20850__$1 = state_20850;
if(inst_20807){
var statearr_20862_20911 = state_20850__$1;
(statearr_20862_20911[(1)] = (16));

} else {
var statearr_20863_20912 = state_20850__$1;
(statearr_20863_20912[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (22))){
var inst_20835 = (state_20850[(2)]);
var state_20850__$1 = state_20850;
if(cljs.core.truth_(inst_20835)){
var statearr_20864_20913 = state_20850__$1;
(statearr_20864_20913[(1)] = (23));

} else {
var statearr_20865_20914 = state_20850__$1;
(statearr_20865_20914[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (6))){
var inst_20781 = (state_20850[(8)]);
var inst_20829 = (state_20850[(7)]);
var inst_20831 = (state_20850[(11)]);
var inst_20829__$1 = topic_fn.call(null,inst_20781);
var inst_20830 = cljs.core.deref.call(null,mults);
var inst_20831__$1 = cljs.core.get.call(null,inst_20830,inst_20829__$1);
var state_20850__$1 = (function (){var statearr_20866 = state_20850;
(statearr_20866[(7)] = inst_20829__$1);

(statearr_20866[(11)] = inst_20831__$1);

return statearr_20866;
})();
if(cljs.core.truth_(inst_20831__$1)){
var statearr_20867_20915 = state_20850__$1;
(statearr_20867_20915[(1)] = (19));

} else {
var statearr_20868_20916 = state_20850__$1;
(statearr_20868_20916[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (25))){
var inst_20840 = (state_20850[(2)]);
var state_20850__$1 = state_20850;
var statearr_20869_20917 = state_20850__$1;
(statearr_20869_20917[(2)] = inst_20840);

(statearr_20869_20917[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (17))){
var inst_20805 = (state_20850[(10)]);
var inst_20814 = cljs.core.first.call(null,inst_20805);
var inst_20815 = cljs.core.async.muxch_STAR_.call(null,inst_20814);
var inst_20816 = cljs.core.async.close_BANG_.call(null,inst_20815);
var inst_20817 = cljs.core.next.call(null,inst_20805);
var inst_20791 = inst_20817;
var inst_20792 = null;
var inst_20793 = (0);
var inst_20794 = (0);
var state_20850__$1 = (function (){var statearr_20870 = state_20850;
(statearr_20870[(12)] = inst_20794);

(statearr_20870[(13)] = inst_20792);

(statearr_20870[(14)] = inst_20791);

(statearr_20870[(15)] = inst_20816);

(statearr_20870[(16)] = inst_20793);

return statearr_20870;
})();
var statearr_20871_20918 = state_20850__$1;
(statearr_20871_20918[(2)] = null);

(statearr_20871_20918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (3))){
var inst_20848 = (state_20850[(2)]);
var state_20850__$1 = state_20850;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20850__$1,inst_20848);
} else {
if((state_val_20851 === (12))){
var inst_20825 = (state_20850[(2)]);
var state_20850__$1 = state_20850;
var statearr_20872_20919 = state_20850__$1;
(statearr_20872_20919[(2)] = inst_20825);

(statearr_20872_20919[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (2))){
var state_20850__$1 = state_20850;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20850__$1,(4),ch);
} else {
if((state_val_20851 === (23))){
var state_20850__$1 = state_20850;
var statearr_20873_20920 = state_20850__$1;
(statearr_20873_20920[(2)] = null);

(statearr_20873_20920[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (19))){
var inst_20781 = (state_20850[(8)]);
var inst_20831 = (state_20850[(11)]);
var inst_20833 = cljs.core.async.muxch_STAR_.call(null,inst_20831);
var state_20850__$1 = state_20850;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20850__$1,(22),inst_20833,inst_20781);
} else {
if((state_val_20851 === (11))){
var inst_20791 = (state_20850[(14)]);
var inst_20805 = (state_20850[(10)]);
var inst_20805__$1 = cljs.core.seq.call(null,inst_20791);
var state_20850__$1 = (function (){var statearr_20874 = state_20850;
(statearr_20874[(10)] = inst_20805__$1);

return statearr_20874;
})();
if(inst_20805__$1){
var statearr_20875_20921 = state_20850__$1;
(statearr_20875_20921[(1)] = (13));

} else {
var statearr_20876_20922 = state_20850__$1;
(statearr_20876_20922[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (9))){
var inst_20827 = (state_20850[(2)]);
var state_20850__$1 = state_20850;
var statearr_20877_20923 = state_20850__$1;
(statearr_20877_20923[(2)] = inst_20827);

(statearr_20877_20923[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (5))){
var inst_20788 = cljs.core.deref.call(null,mults);
var inst_20789 = cljs.core.vals.call(null,inst_20788);
var inst_20790 = cljs.core.seq.call(null,inst_20789);
var inst_20791 = inst_20790;
var inst_20792 = null;
var inst_20793 = (0);
var inst_20794 = (0);
var state_20850__$1 = (function (){var statearr_20878 = state_20850;
(statearr_20878[(12)] = inst_20794);

(statearr_20878[(13)] = inst_20792);

(statearr_20878[(14)] = inst_20791);

(statearr_20878[(16)] = inst_20793);

return statearr_20878;
})();
var statearr_20879_20924 = state_20850__$1;
(statearr_20879_20924[(2)] = null);

(statearr_20879_20924[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (14))){
var state_20850__$1 = state_20850;
var statearr_20883_20925 = state_20850__$1;
(statearr_20883_20925[(2)] = null);

(statearr_20883_20925[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (16))){
var inst_20805 = (state_20850[(10)]);
var inst_20809 = cljs.core.chunk_first.call(null,inst_20805);
var inst_20810 = cljs.core.chunk_rest.call(null,inst_20805);
var inst_20811 = cljs.core.count.call(null,inst_20809);
var inst_20791 = inst_20810;
var inst_20792 = inst_20809;
var inst_20793 = inst_20811;
var inst_20794 = (0);
var state_20850__$1 = (function (){var statearr_20884 = state_20850;
(statearr_20884[(12)] = inst_20794);

(statearr_20884[(13)] = inst_20792);

(statearr_20884[(14)] = inst_20791);

(statearr_20884[(16)] = inst_20793);

return statearr_20884;
})();
var statearr_20885_20926 = state_20850__$1;
(statearr_20885_20926[(2)] = null);

(statearr_20885_20926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (10))){
var inst_20794 = (state_20850[(12)]);
var inst_20792 = (state_20850[(13)]);
var inst_20791 = (state_20850[(14)]);
var inst_20793 = (state_20850[(16)]);
var inst_20799 = cljs.core._nth.call(null,inst_20792,inst_20794);
var inst_20800 = cljs.core.async.muxch_STAR_.call(null,inst_20799);
var inst_20801 = cljs.core.async.close_BANG_.call(null,inst_20800);
var inst_20802 = (inst_20794 + (1));
var tmp20880 = inst_20792;
var tmp20881 = inst_20791;
var tmp20882 = inst_20793;
var inst_20791__$1 = tmp20881;
var inst_20792__$1 = tmp20880;
var inst_20793__$1 = tmp20882;
var inst_20794__$1 = inst_20802;
var state_20850__$1 = (function (){var statearr_20886 = state_20850;
(statearr_20886[(17)] = inst_20801);

(statearr_20886[(12)] = inst_20794__$1);

(statearr_20886[(13)] = inst_20792__$1);

(statearr_20886[(14)] = inst_20791__$1);

(statearr_20886[(16)] = inst_20793__$1);

return statearr_20886;
})();
var statearr_20887_20927 = state_20850__$1;
(statearr_20887_20927[(2)] = null);

(statearr_20887_20927[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (18))){
var inst_20820 = (state_20850[(2)]);
var state_20850__$1 = state_20850;
var statearr_20888_20928 = state_20850__$1;
(statearr_20888_20928[(2)] = inst_20820);

(statearr_20888_20928[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20851 === (8))){
var inst_20794 = (state_20850[(12)]);
var inst_20793 = (state_20850[(16)]);
var inst_20796 = (inst_20794 < inst_20793);
var inst_20797 = inst_20796;
var state_20850__$1 = state_20850;
if(cljs.core.truth_(inst_20797)){
var statearr_20889_20929 = state_20850__$1;
(statearr_20889_20929[(1)] = (10));

} else {
var statearr_20890_20930 = state_20850__$1;
(statearr_20890_20930[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto___20902,mults,ensure_mult,p))
;
return ((function (switch__18890__auto__,c__19002__auto___20902,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__18891__auto__ = null;
var cljs$core$async$state_machine__18891__auto____0 = (function (){
var statearr_20894 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20894[(0)] = cljs$core$async$state_machine__18891__auto__);

(statearr_20894[(1)] = (1));

return statearr_20894;
});
var cljs$core$async$state_machine__18891__auto____1 = (function (state_20850){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_20850);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e20895){if((e20895 instanceof Object)){
var ex__18894__auto__ = e20895;
var statearr_20896_20931 = state_20850;
(statearr_20896_20931[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20850);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20895;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20932 = state_20850;
state_20850 = G__20932;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$state_machine__18891__auto__ = function(state_20850){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18891__auto____1.call(this,state_20850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18891__auto____0;
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18891__auto____1;
return cljs$core$async$state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___20902,mults,ensure_mult,p))
})();
var state__19004__auto__ = (function (){var statearr_20897 = f__19003__auto__.call(null);
(statearr_20897[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___20902);

return statearr_20897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___20902,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args20933 = [];
var len__17893__auto___20936 = arguments.length;
var i__17894__auto___20937 = (0);
while(true){
if((i__17894__auto___20937 < len__17893__auto___20936)){
args20933.push((arguments[i__17894__auto___20937]));

var G__20938 = (i__17894__auto___20937 + (1));
i__17894__auto___20937 = G__20938;
continue;
} else {
}
break;
}

var G__20935 = args20933.length;
switch (G__20935) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20933.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args20940 = [];
var len__17893__auto___20943 = arguments.length;
var i__17894__auto___20944 = (0);
while(true){
if((i__17894__auto___20944 < len__17893__auto___20943)){
args20940.push((arguments[i__17894__auto___20944]));

var G__20945 = (i__17894__auto___20944 + (1));
i__17894__auto___20944 = G__20945;
continue;
} else {
}
break;
}

var G__20942 = args20940.length;
switch (G__20942) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20940.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args20947 = [];
var len__17893__auto___21018 = arguments.length;
var i__17894__auto___21019 = (0);
while(true){
if((i__17894__auto___21019 < len__17893__auto___21018)){
args20947.push((arguments[i__17894__auto___21019]));

var G__21020 = (i__17894__auto___21019 + (1));
i__17894__auto___21019 = G__21020;
continue;
} else {
}
break;
}

var G__20949 = args20947.length;
switch (G__20949) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20947.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__19002__auto___21022 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___21022,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___21022,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_20988){
var state_val_20989 = (state_20988[(1)]);
if((state_val_20989 === (7))){
var state_20988__$1 = state_20988;
var statearr_20990_21023 = state_20988__$1;
(statearr_20990_21023[(2)] = null);

(statearr_20990_21023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20989 === (1))){
var state_20988__$1 = state_20988;
var statearr_20991_21024 = state_20988__$1;
(statearr_20991_21024[(2)] = null);

(statearr_20991_21024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20989 === (4))){
var inst_20952 = (state_20988[(7)]);
var inst_20954 = (inst_20952 < cnt);
var state_20988__$1 = state_20988;
if(cljs.core.truth_(inst_20954)){
var statearr_20992_21025 = state_20988__$1;
(statearr_20992_21025[(1)] = (6));

} else {
var statearr_20993_21026 = state_20988__$1;
(statearr_20993_21026[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20989 === (15))){
var inst_20984 = (state_20988[(2)]);
var state_20988__$1 = state_20988;
var statearr_20994_21027 = state_20988__$1;
(statearr_20994_21027[(2)] = inst_20984);

(statearr_20994_21027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20989 === (13))){
var inst_20977 = cljs.core.async.close_BANG_.call(null,out);
var state_20988__$1 = state_20988;
var statearr_20995_21028 = state_20988__$1;
(statearr_20995_21028[(2)] = inst_20977);

(statearr_20995_21028[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20989 === (6))){
var state_20988__$1 = state_20988;
var statearr_20996_21029 = state_20988__$1;
(statearr_20996_21029[(2)] = null);

(statearr_20996_21029[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20989 === (3))){
var inst_20986 = (state_20988[(2)]);
var state_20988__$1 = state_20988;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20988__$1,inst_20986);
} else {
if((state_val_20989 === (12))){
var inst_20974 = (state_20988[(8)]);
var inst_20974__$1 = (state_20988[(2)]);
var inst_20975 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_20974__$1);
var state_20988__$1 = (function (){var statearr_20997 = state_20988;
(statearr_20997[(8)] = inst_20974__$1);

return statearr_20997;
})();
if(cljs.core.truth_(inst_20975)){
var statearr_20998_21030 = state_20988__$1;
(statearr_20998_21030[(1)] = (13));

} else {
var statearr_20999_21031 = state_20988__$1;
(statearr_20999_21031[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20989 === (2))){
var inst_20951 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_20952 = (0);
var state_20988__$1 = (function (){var statearr_21000 = state_20988;
(statearr_21000[(9)] = inst_20951);

(statearr_21000[(7)] = inst_20952);

return statearr_21000;
})();
var statearr_21001_21032 = state_20988__$1;
(statearr_21001_21032[(2)] = null);

(statearr_21001_21032[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20989 === (11))){
var inst_20952 = (state_20988[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_20988,(10),Object,null,(9));
var inst_20961 = chs__$1.call(null,inst_20952);
var inst_20962 = done.call(null,inst_20952);
var inst_20963 = cljs.core.async.take_BANG_.call(null,inst_20961,inst_20962);
var state_20988__$1 = state_20988;
var statearr_21002_21033 = state_20988__$1;
(statearr_21002_21033[(2)] = inst_20963);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20988__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20989 === (9))){
var inst_20952 = (state_20988[(7)]);
var inst_20965 = (state_20988[(2)]);
var inst_20966 = (inst_20952 + (1));
var inst_20952__$1 = inst_20966;
var state_20988__$1 = (function (){var statearr_21003 = state_20988;
(statearr_21003[(10)] = inst_20965);

(statearr_21003[(7)] = inst_20952__$1);

return statearr_21003;
})();
var statearr_21004_21034 = state_20988__$1;
(statearr_21004_21034[(2)] = null);

(statearr_21004_21034[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20989 === (5))){
var inst_20972 = (state_20988[(2)]);
var state_20988__$1 = (function (){var statearr_21005 = state_20988;
(statearr_21005[(11)] = inst_20972);

return statearr_21005;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20988__$1,(12),dchan);
} else {
if((state_val_20989 === (14))){
var inst_20974 = (state_20988[(8)]);
var inst_20979 = cljs.core.apply.call(null,f,inst_20974);
var state_20988__$1 = state_20988;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20988__$1,(16),out,inst_20979);
} else {
if((state_val_20989 === (16))){
var inst_20981 = (state_20988[(2)]);
var state_20988__$1 = (function (){var statearr_21006 = state_20988;
(statearr_21006[(12)] = inst_20981);

return statearr_21006;
})();
var statearr_21007_21035 = state_20988__$1;
(statearr_21007_21035[(2)] = null);

(statearr_21007_21035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20989 === (10))){
var inst_20956 = (state_20988[(2)]);
var inst_20957 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_20988__$1 = (function (){var statearr_21008 = state_20988;
(statearr_21008[(13)] = inst_20956);

return statearr_21008;
})();
var statearr_21009_21036 = state_20988__$1;
(statearr_21009_21036[(2)] = inst_20957);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20988__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20989 === (8))){
var inst_20970 = (state_20988[(2)]);
var state_20988__$1 = state_20988;
var statearr_21010_21037 = state_20988__$1;
(statearr_21010_21037[(2)] = inst_20970);

(statearr_21010_21037[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto___21022,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__18890__auto__,c__19002__auto___21022,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__18891__auto__ = null;
var cljs$core$async$state_machine__18891__auto____0 = (function (){
var statearr_21014 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21014[(0)] = cljs$core$async$state_machine__18891__auto__);

(statearr_21014[(1)] = (1));

return statearr_21014;
});
var cljs$core$async$state_machine__18891__auto____1 = (function (state_20988){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_20988);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e21015){if((e21015 instanceof Object)){
var ex__18894__auto__ = e21015;
var statearr_21016_21038 = state_20988;
(statearr_21016_21038[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20988);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21015;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21039 = state_20988;
state_20988 = G__21039;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$state_machine__18891__auto__ = function(state_20988){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18891__auto____1.call(this,state_20988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18891__auto____0;
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18891__auto____1;
return cljs$core$async$state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___21022,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__19004__auto__ = (function (){var statearr_21017 = f__19003__auto__.call(null);
(statearr_21017[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___21022);

return statearr_21017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___21022,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args21041 = [];
var len__17893__auto___21097 = arguments.length;
var i__17894__auto___21098 = (0);
while(true){
if((i__17894__auto___21098 < len__17893__auto___21097)){
args21041.push((arguments[i__17894__auto___21098]));

var G__21099 = (i__17894__auto___21098 + (1));
i__17894__auto___21098 = G__21099;
continue;
} else {
}
break;
}

var G__21043 = args21041.length;
switch (G__21043) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21041.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19002__auto___21101 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___21101,out){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___21101,out){
return (function (state_21073){
var state_val_21074 = (state_21073[(1)]);
if((state_val_21074 === (7))){
var inst_21052 = (state_21073[(7)]);
var inst_21053 = (state_21073[(8)]);
var inst_21052__$1 = (state_21073[(2)]);
var inst_21053__$1 = cljs.core.nth.call(null,inst_21052__$1,(0),null);
var inst_21054 = cljs.core.nth.call(null,inst_21052__$1,(1),null);
var inst_21055 = (inst_21053__$1 == null);
var state_21073__$1 = (function (){var statearr_21075 = state_21073;
(statearr_21075[(7)] = inst_21052__$1);

(statearr_21075[(9)] = inst_21054);

(statearr_21075[(8)] = inst_21053__$1);

return statearr_21075;
})();
if(cljs.core.truth_(inst_21055)){
var statearr_21076_21102 = state_21073__$1;
(statearr_21076_21102[(1)] = (8));

} else {
var statearr_21077_21103 = state_21073__$1;
(statearr_21077_21103[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21074 === (1))){
var inst_21044 = cljs.core.vec.call(null,chs);
var inst_21045 = inst_21044;
var state_21073__$1 = (function (){var statearr_21078 = state_21073;
(statearr_21078[(10)] = inst_21045);

return statearr_21078;
})();
var statearr_21079_21104 = state_21073__$1;
(statearr_21079_21104[(2)] = null);

(statearr_21079_21104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21074 === (4))){
var inst_21045 = (state_21073[(10)]);
var state_21073__$1 = state_21073;
return cljs.core.async.ioc_alts_BANG_.call(null,state_21073__$1,(7),inst_21045);
} else {
if((state_val_21074 === (6))){
var inst_21069 = (state_21073[(2)]);
var state_21073__$1 = state_21073;
var statearr_21080_21105 = state_21073__$1;
(statearr_21080_21105[(2)] = inst_21069);

(statearr_21080_21105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21074 === (3))){
var inst_21071 = (state_21073[(2)]);
var state_21073__$1 = state_21073;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21073__$1,inst_21071);
} else {
if((state_val_21074 === (2))){
var inst_21045 = (state_21073[(10)]);
var inst_21047 = cljs.core.count.call(null,inst_21045);
var inst_21048 = (inst_21047 > (0));
var state_21073__$1 = state_21073;
if(cljs.core.truth_(inst_21048)){
var statearr_21082_21106 = state_21073__$1;
(statearr_21082_21106[(1)] = (4));

} else {
var statearr_21083_21107 = state_21073__$1;
(statearr_21083_21107[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21074 === (11))){
var inst_21045 = (state_21073[(10)]);
var inst_21062 = (state_21073[(2)]);
var tmp21081 = inst_21045;
var inst_21045__$1 = tmp21081;
var state_21073__$1 = (function (){var statearr_21084 = state_21073;
(statearr_21084[(11)] = inst_21062);

(statearr_21084[(10)] = inst_21045__$1);

return statearr_21084;
})();
var statearr_21085_21108 = state_21073__$1;
(statearr_21085_21108[(2)] = null);

(statearr_21085_21108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21074 === (9))){
var inst_21053 = (state_21073[(8)]);
var state_21073__$1 = state_21073;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21073__$1,(11),out,inst_21053);
} else {
if((state_val_21074 === (5))){
var inst_21067 = cljs.core.async.close_BANG_.call(null,out);
var state_21073__$1 = state_21073;
var statearr_21086_21109 = state_21073__$1;
(statearr_21086_21109[(2)] = inst_21067);

(statearr_21086_21109[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21074 === (10))){
var inst_21065 = (state_21073[(2)]);
var state_21073__$1 = state_21073;
var statearr_21087_21110 = state_21073__$1;
(statearr_21087_21110[(2)] = inst_21065);

(statearr_21087_21110[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21074 === (8))){
var inst_21052 = (state_21073[(7)]);
var inst_21054 = (state_21073[(9)]);
var inst_21045 = (state_21073[(10)]);
var inst_21053 = (state_21073[(8)]);
var inst_21057 = (function (){var cs = inst_21045;
var vec__21050 = inst_21052;
var v = inst_21053;
var c = inst_21054;
return ((function (cs,vec__21050,v,c,inst_21052,inst_21054,inst_21045,inst_21053,state_val_21074,c__19002__auto___21101,out){
return (function (p1__21040_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__21040_SHARP_);
});
;})(cs,vec__21050,v,c,inst_21052,inst_21054,inst_21045,inst_21053,state_val_21074,c__19002__auto___21101,out))
})();
var inst_21058 = cljs.core.filterv.call(null,inst_21057,inst_21045);
var inst_21045__$1 = inst_21058;
var state_21073__$1 = (function (){var statearr_21088 = state_21073;
(statearr_21088[(10)] = inst_21045__$1);

return statearr_21088;
})();
var statearr_21089_21111 = state_21073__$1;
(statearr_21089_21111[(2)] = null);

(statearr_21089_21111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto___21101,out))
;
return ((function (switch__18890__auto__,c__19002__auto___21101,out){
return (function() {
var cljs$core$async$state_machine__18891__auto__ = null;
var cljs$core$async$state_machine__18891__auto____0 = (function (){
var statearr_21093 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21093[(0)] = cljs$core$async$state_machine__18891__auto__);

(statearr_21093[(1)] = (1));

return statearr_21093;
});
var cljs$core$async$state_machine__18891__auto____1 = (function (state_21073){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_21073);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e21094){if((e21094 instanceof Object)){
var ex__18894__auto__ = e21094;
var statearr_21095_21112 = state_21073;
(statearr_21095_21112[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21073);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21094;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21113 = state_21073;
state_21073 = G__21113;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$state_machine__18891__auto__ = function(state_21073){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18891__auto____1.call(this,state_21073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18891__auto____0;
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18891__auto____1;
return cljs$core$async$state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___21101,out))
})();
var state__19004__auto__ = (function (){var statearr_21096 = f__19003__auto__.call(null);
(statearr_21096[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___21101);

return statearr_21096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___21101,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args21114 = [];
var len__17893__auto___21163 = arguments.length;
var i__17894__auto___21164 = (0);
while(true){
if((i__17894__auto___21164 < len__17893__auto___21163)){
args21114.push((arguments[i__17894__auto___21164]));

var G__21165 = (i__17894__auto___21164 + (1));
i__17894__auto___21164 = G__21165;
continue;
} else {
}
break;
}

var G__21116 = args21114.length;
switch (G__21116) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21114.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19002__auto___21167 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___21167,out){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___21167,out){
return (function (state_21140){
var state_val_21141 = (state_21140[(1)]);
if((state_val_21141 === (7))){
var inst_21122 = (state_21140[(7)]);
var inst_21122__$1 = (state_21140[(2)]);
var inst_21123 = (inst_21122__$1 == null);
var inst_21124 = cljs.core.not.call(null,inst_21123);
var state_21140__$1 = (function (){var statearr_21142 = state_21140;
(statearr_21142[(7)] = inst_21122__$1);

return statearr_21142;
})();
if(inst_21124){
var statearr_21143_21168 = state_21140__$1;
(statearr_21143_21168[(1)] = (8));

} else {
var statearr_21144_21169 = state_21140__$1;
(statearr_21144_21169[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21141 === (1))){
var inst_21117 = (0);
var state_21140__$1 = (function (){var statearr_21145 = state_21140;
(statearr_21145[(8)] = inst_21117);

return statearr_21145;
})();
var statearr_21146_21170 = state_21140__$1;
(statearr_21146_21170[(2)] = null);

(statearr_21146_21170[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21141 === (4))){
var state_21140__$1 = state_21140;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21140__$1,(7),ch);
} else {
if((state_val_21141 === (6))){
var inst_21135 = (state_21140[(2)]);
var state_21140__$1 = state_21140;
var statearr_21147_21171 = state_21140__$1;
(statearr_21147_21171[(2)] = inst_21135);

(statearr_21147_21171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21141 === (3))){
var inst_21137 = (state_21140[(2)]);
var inst_21138 = cljs.core.async.close_BANG_.call(null,out);
var state_21140__$1 = (function (){var statearr_21148 = state_21140;
(statearr_21148[(9)] = inst_21137);

return statearr_21148;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21140__$1,inst_21138);
} else {
if((state_val_21141 === (2))){
var inst_21117 = (state_21140[(8)]);
var inst_21119 = (inst_21117 < n);
var state_21140__$1 = state_21140;
if(cljs.core.truth_(inst_21119)){
var statearr_21149_21172 = state_21140__$1;
(statearr_21149_21172[(1)] = (4));

} else {
var statearr_21150_21173 = state_21140__$1;
(statearr_21150_21173[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21141 === (11))){
var inst_21117 = (state_21140[(8)]);
var inst_21127 = (state_21140[(2)]);
var inst_21128 = (inst_21117 + (1));
var inst_21117__$1 = inst_21128;
var state_21140__$1 = (function (){var statearr_21151 = state_21140;
(statearr_21151[(10)] = inst_21127);

(statearr_21151[(8)] = inst_21117__$1);

return statearr_21151;
})();
var statearr_21152_21174 = state_21140__$1;
(statearr_21152_21174[(2)] = null);

(statearr_21152_21174[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21141 === (9))){
var state_21140__$1 = state_21140;
var statearr_21153_21175 = state_21140__$1;
(statearr_21153_21175[(2)] = null);

(statearr_21153_21175[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21141 === (5))){
var state_21140__$1 = state_21140;
var statearr_21154_21176 = state_21140__$1;
(statearr_21154_21176[(2)] = null);

(statearr_21154_21176[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21141 === (10))){
var inst_21132 = (state_21140[(2)]);
var state_21140__$1 = state_21140;
var statearr_21155_21177 = state_21140__$1;
(statearr_21155_21177[(2)] = inst_21132);

(statearr_21155_21177[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21141 === (8))){
var inst_21122 = (state_21140[(7)]);
var state_21140__$1 = state_21140;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21140__$1,(11),out,inst_21122);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto___21167,out))
;
return ((function (switch__18890__auto__,c__19002__auto___21167,out){
return (function() {
var cljs$core$async$state_machine__18891__auto__ = null;
var cljs$core$async$state_machine__18891__auto____0 = (function (){
var statearr_21159 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21159[(0)] = cljs$core$async$state_machine__18891__auto__);

(statearr_21159[(1)] = (1));

return statearr_21159;
});
var cljs$core$async$state_machine__18891__auto____1 = (function (state_21140){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_21140);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e21160){if((e21160 instanceof Object)){
var ex__18894__auto__ = e21160;
var statearr_21161_21178 = state_21140;
(statearr_21161_21178[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21140);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21160;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21179 = state_21140;
state_21140 = G__21179;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$state_machine__18891__auto__ = function(state_21140){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18891__auto____1.call(this,state_21140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18891__auto____0;
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18891__auto____1;
return cljs$core$async$state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___21167,out))
})();
var state__19004__auto__ = (function (){var statearr_21162 = f__19003__auto__.call(null);
(statearr_21162[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___21167);

return statearr_21162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___21167,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21187 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21187 = (function (map_LT_,f,ch,meta21188){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21188 = meta21188;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21187.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21189,meta21188__$1){
var self__ = this;
var _21189__$1 = this;
return (new cljs.core.async.t_cljs$core$async21187(self__.map_LT_,self__.f,self__.ch,meta21188__$1));
});

cljs.core.async.t_cljs$core$async21187.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21189){
var self__ = this;
var _21189__$1 = this;
return self__.meta21188;
});

cljs.core.async.t_cljs$core$async21187.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21187.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21187.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21187.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21187.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async21190 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21190 = (function (map_LT_,f,ch,meta21188,_,fn1,meta21191){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21188 = meta21188;
this._ = _;
this.fn1 = fn1;
this.meta21191 = meta21191;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21190.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_21192,meta21191__$1){
var self__ = this;
var _21192__$1 = this;
return (new cljs.core.async.t_cljs$core$async21190(self__.map_LT_,self__.f,self__.ch,self__.meta21188,self__._,self__.fn1,meta21191__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async21190.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_21192){
var self__ = this;
var _21192__$1 = this;
return self__.meta21191;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21190.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async21190.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21190.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21190.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__21180_SHARP_){
return f1.call(null,(((p1__21180_SHARP_ == null))?null:self__.f.call(null,p1__21180_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async21190.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21188","meta21188",-1662327393,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async21187","cljs.core.async/t_cljs$core$async21187",2081610359,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta21191","meta21191",1447634476,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21190.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21190.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21190";

cljs.core.async.t_cljs$core$async21190.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__17433__auto__,writer__17434__auto__,opt__17435__auto__){
return cljs.core._write.call(null,writer__17434__auto__,"cljs.core.async/t_cljs$core$async21190");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async21190 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21190(map_LT___$1,f__$1,ch__$1,meta21188__$1,___$2,fn1__$1,meta21191){
return (new cljs.core.async.t_cljs$core$async21190(map_LT___$1,f__$1,ch__$1,meta21188__$1,___$2,fn1__$1,meta21191));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async21190(self__.map_LT_,self__.f,self__.ch,self__.meta21188,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__16823__auto__ = ret;
if(cljs.core.truth_(and__16823__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__16823__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async21187.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21187.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async21187.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21188","meta21188",-1662327393,null)], null);
});

cljs.core.async.t_cljs$core$async21187.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21187.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21187";

cljs.core.async.t_cljs$core$async21187.cljs$lang$ctorPrWriter = (function (this__17433__auto__,writer__17434__auto__,opt__17435__auto__){
return cljs.core._write.call(null,writer__17434__auto__,"cljs.core.async/t_cljs$core$async21187");
});

cljs.core.async.__GT_t_cljs$core$async21187 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21187(map_LT___$1,f__$1,ch__$1,meta21188){
return (new cljs.core.async.t_cljs$core$async21187(map_LT___$1,f__$1,ch__$1,meta21188));
});

}

return (new cljs.core.async.t_cljs$core$async21187(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21196 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21196 = (function (map_GT_,f,ch,meta21197){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta21197 = meta21197;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21196.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21198,meta21197__$1){
var self__ = this;
var _21198__$1 = this;
return (new cljs.core.async.t_cljs$core$async21196(self__.map_GT_,self__.f,self__.ch,meta21197__$1));
});

cljs.core.async.t_cljs$core$async21196.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21198){
var self__ = this;
var _21198__$1 = this;
return self__.meta21197;
});

cljs.core.async.t_cljs$core$async21196.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21196.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21196.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21196.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21196.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21196.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async21196.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21197","meta21197",85415146,null)], null);
});

cljs.core.async.t_cljs$core$async21196.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21196.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21196";

cljs.core.async.t_cljs$core$async21196.cljs$lang$ctorPrWriter = (function (this__17433__auto__,writer__17434__auto__,opt__17435__auto__){
return cljs.core._write.call(null,writer__17434__auto__,"cljs.core.async/t_cljs$core$async21196");
});

cljs.core.async.__GT_t_cljs$core$async21196 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async21196(map_GT___$1,f__$1,ch__$1,meta21197){
return (new cljs.core.async.t_cljs$core$async21196(map_GT___$1,f__$1,ch__$1,meta21197));
});

}

return (new cljs.core.async.t_cljs$core$async21196(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async21202 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21202 = (function (filter_GT_,p,ch,meta21203){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta21203 = meta21203;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21202.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21204,meta21203__$1){
var self__ = this;
var _21204__$1 = this;
return (new cljs.core.async.t_cljs$core$async21202(self__.filter_GT_,self__.p,self__.ch,meta21203__$1));
});

cljs.core.async.t_cljs$core$async21202.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21204){
var self__ = this;
var _21204__$1 = this;
return self__.meta21203;
});

cljs.core.async.t_cljs$core$async21202.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21202.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21202.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21202.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21202.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21202.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21202.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async21202.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21203","meta21203",-97717231,null)], null);
});

cljs.core.async.t_cljs$core$async21202.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21202.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21202";

cljs.core.async.t_cljs$core$async21202.cljs$lang$ctorPrWriter = (function (this__17433__auto__,writer__17434__auto__,opt__17435__auto__){
return cljs.core._write.call(null,writer__17434__auto__,"cljs.core.async/t_cljs$core$async21202");
});

cljs.core.async.__GT_t_cljs$core$async21202 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async21202(filter_GT___$1,p__$1,ch__$1,meta21203){
return (new cljs.core.async.t_cljs$core$async21202(filter_GT___$1,p__$1,ch__$1,meta21203));
});

}

return (new cljs.core.async.t_cljs$core$async21202(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args21205 = [];
var len__17893__auto___21249 = arguments.length;
var i__17894__auto___21250 = (0);
while(true){
if((i__17894__auto___21250 < len__17893__auto___21249)){
args21205.push((arguments[i__17894__auto___21250]));

var G__21251 = (i__17894__auto___21250 + (1));
i__17894__auto___21250 = G__21251;
continue;
} else {
}
break;
}

var G__21207 = args21205.length;
switch (G__21207) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21205.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19002__auto___21253 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___21253,out){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___21253,out){
return (function (state_21228){
var state_val_21229 = (state_21228[(1)]);
if((state_val_21229 === (7))){
var inst_21224 = (state_21228[(2)]);
var state_21228__$1 = state_21228;
var statearr_21230_21254 = state_21228__$1;
(statearr_21230_21254[(2)] = inst_21224);

(statearr_21230_21254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21229 === (1))){
var state_21228__$1 = state_21228;
var statearr_21231_21255 = state_21228__$1;
(statearr_21231_21255[(2)] = null);

(statearr_21231_21255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21229 === (4))){
var inst_21210 = (state_21228[(7)]);
var inst_21210__$1 = (state_21228[(2)]);
var inst_21211 = (inst_21210__$1 == null);
var state_21228__$1 = (function (){var statearr_21232 = state_21228;
(statearr_21232[(7)] = inst_21210__$1);

return statearr_21232;
})();
if(cljs.core.truth_(inst_21211)){
var statearr_21233_21256 = state_21228__$1;
(statearr_21233_21256[(1)] = (5));

} else {
var statearr_21234_21257 = state_21228__$1;
(statearr_21234_21257[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21229 === (6))){
var inst_21210 = (state_21228[(7)]);
var inst_21215 = p.call(null,inst_21210);
var state_21228__$1 = state_21228;
if(cljs.core.truth_(inst_21215)){
var statearr_21235_21258 = state_21228__$1;
(statearr_21235_21258[(1)] = (8));

} else {
var statearr_21236_21259 = state_21228__$1;
(statearr_21236_21259[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21229 === (3))){
var inst_21226 = (state_21228[(2)]);
var state_21228__$1 = state_21228;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21228__$1,inst_21226);
} else {
if((state_val_21229 === (2))){
var state_21228__$1 = state_21228;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21228__$1,(4),ch);
} else {
if((state_val_21229 === (11))){
var inst_21218 = (state_21228[(2)]);
var state_21228__$1 = state_21228;
var statearr_21237_21260 = state_21228__$1;
(statearr_21237_21260[(2)] = inst_21218);

(statearr_21237_21260[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21229 === (9))){
var state_21228__$1 = state_21228;
var statearr_21238_21261 = state_21228__$1;
(statearr_21238_21261[(2)] = null);

(statearr_21238_21261[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21229 === (5))){
var inst_21213 = cljs.core.async.close_BANG_.call(null,out);
var state_21228__$1 = state_21228;
var statearr_21239_21262 = state_21228__$1;
(statearr_21239_21262[(2)] = inst_21213);

(statearr_21239_21262[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21229 === (10))){
var inst_21221 = (state_21228[(2)]);
var state_21228__$1 = (function (){var statearr_21240 = state_21228;
(statearr_21240[(8)] = inst_21221);

return statearr_21240;
})();
var statearr_21241_21263 = state_21228__$1;
(statearr_21241_21263[(2)] = null);

(statearr_21241_21263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21229 === (8))){
var inst_21210 = (state_21228[(7)]);
var state_21228__$1 = state_21228;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21228__$1,(11),out,inst_21210);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto___21253,out))
;
return ((function (switch__18890__auto__,c__19002__auto___21253,out){
return (function() {
var cljs$core$async$state_machine__18891__auto__ = null;
var cljs$core$async$state_machine__18891__auto____0 = (function (){
var statearr_21245 = [null,null,null,null,null,null,null,null,null];
(statearr_21245[(0)] = cljs$core$async$state_machine__18891__auto__);

(statearr_21245[(1)] = (1));

return statearr_21245;
});
var cljs$core$async$state_machine__18891__auto____1 = (function (state_21228){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_21228);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e21246){if((e21246 instanceof Object)){
var ex__18894__auto__ = e21246;
var statearr_21247_21264 = state_21228;
(statearr_21247_21264[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21228);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21246;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21265 = state_21228;
state_21228 = G__21265;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$state_machine__18891__auto__ = function(state_21228){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18891__auto____1.call(this,state_21228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18891__auto____0;
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18891__auto____1;
return cljs$core$async$state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___21253,out))
})();
var state__19004__auto__ = (function (){var statearr_21248 = f__19003__auto__.call(null);
(statearr_21248[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___21253);

return statearr_21248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___21253,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args21266 = [];
var len__17893__auto___21269 = arguments.length;
var i__17894__auto___21270 = (0);
while(true){
if((i__17894__auto___21270 < len__17893__auto___21269)){
args21266.push((arguments[i__17894__auto___21270]));

var G__21271 = (i__17894__auto___21270 + (1));
i__17894__auto___21270 = G__21271;
continue;
} else {
}
break;
}

var G__21268 = args21266.length;
switch (G__21268) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21266.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__19002__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto__){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto__){
return (function (state_21438){
var state_val_21439 = (state_21438[(1)]);
if((state_val_21439 === (7))){
var inst_21434 = (state_21438[(2)]);
var state_21438__$1 = state_21438;
var statearr_21440_21481 = state_21438__$1;
(statearr_21440_21481[(2)] = inst_21434);

(statearr_21440_21481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (20))){
var inst_21404 = (state_21438[(7)]);
var inst_21415 = (state_21438[(2)]);
var inst_21416 = cljs.core.next.call(null,inst_21404);
var inst_21390 = inst_21416;
var inst_21391 = null;
var inst_21392 = (0);
var inst_21393 = (0);
var state_21438__$1 = (function (){var statearr_21441 = state_21438;
(statearr_21441[(8)] = inst_21390);

(statearr_21441[(9)] = inst_21392);

(statearr_21441[(10)] = inst_21415);

(statearr_21441[(11)] = inst_21393);

(statearr_21441[(12)] = inst_21391);

return statearr_21441;
})();
var statearr_21442_21482 = state_21438__$1;
(statearr_21442_21482[(2)] = null);

(statearr_21442_21482[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (1))){
var state_21438__$1 = state_21438;
var statearr_21443_21483 = state_21438__$1;
(statearr_21443_21483[(2)] = null);

(statearr_21443_21483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (4))){
var inst_21379 = (state_21438[(13)]);
var inst_21379__$1 = (state_21438[(2)]);
var inst_21380 = (inst_21379__$1 == null);
var state_21438__$1 = (function (){var statearr_21444 = state_21438;
(statearr_21444[(13)] = inst_21379__$1);

return statearr_21444;
})();
if(cljs.core.truth_(inst_21380)){
var statearr_21445_21484 = state_21438__$1;
(statearr_21445_21484[(1)] = (5));

} else {
var statearr_21446_21485 = state_21438__$1;
(statearr_21446_21485[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (15))){
var state_21438__$1 = state_21438;
var statearr_21450_21486 = state_21438__$1;
(statearr_21450_21486[(2)] = null);

(statearr_21450_21486[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (21))){
var state_21438__$1 = state_21438;
var statearr_21451_21487 = state_21438__$1;
(statearr_21451_21487[(2)] = null);

(statearr_21451_21487[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (13))){
var inst_21390 = (state_21438[(8)]);
var inst_21392 = (state_21438[(9)]);
var inst_21393 = (state_21438[(11)]);
var inst_21391 = (state_21438[(12)]);
var inst_21400 = (state_21438[(2)]);
var inst_21401 = (inst_21393 + (1));
var tmp21447 = inst_21390;
var tmp21448 = inst_21392;
var tmp21449 = inst_21391;
var inst_21390__$1 = tmp21447;
var inst_21391__$1 = tmp21449;
var inst_21392__$1 = tmp21448;
var inst_21393__$1 = inst_21401;
var state_21438__$1 = (function (){var statearr_21452 = state_21438;
(statearr_21452[(8)] = inst_21390__$1);

(statearr_21452[(14)] = inst_21400);

(statearr_21452[(9)] = inst_21392__$1);

(statearr_21452[(11)] = inst_21393__$1);

(statearr_21452[(12)] = inst_21391__$1);

return statearr_21452;
})();
var statearr_21453_21488 = state_21438__$1;
(statearr_21453_21488[(2)] = null);

(statearr_21453_21488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (22))){
var state_21438__$1 = state_21438;
var statearr_21454_21489 = state_21438__$1;
(statearr_21454_21489[(2)] = null);

(statearr_21454_21489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (6))){
var inst_21379 = (state_21438[(13)]);
var inst_21388 = f.call(null,inst_21379);
var inst_21389 = cljs.core.seq.call(null,inst_21388);
var inst_21390 = inst_21389;
var inst_21391 = null;
var inst_21392 = (0);
var inst_21393 = (0);
var state_21438__$1 = (function (){var statearr_21455 = state_21438;
(statearr_21455[(8)] = inst_21390);

(statearr_21455[(9)] = inst_21392);

(statearr_21455[(11)] = inst_21393);

(statearr_21455[(12)] = inst_21391);

return statearr_21455;
})();
var statearr_21456_21490 = state_21438__$1;
(statearr_21456_21490[(2)] = null);

(statearr_21456_21490[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (17))){
var inst_21404 = (state_21438[(7)]);
var inst_21408 = cljs.core.chunk_first.call(null,inst_21404);
var inst_21409 = cljs.core.chunk_rest.call(null,inst_21404);
var inst_21410 = cljs.core.count.call(null,inst_21408);
var inst_21390 = inst_21409;
var inst_21391 = inst_21408;
var inst_21392 = inst_21410;
var inst_21393 = (0);
var state_21438__$1 = (function (){var statearr_21457 = state_21438;
(statearr_21457[(8)] = inst_21390);

(statearr_21457[(9)] = inst_21392);

(statearr_21457[(11)] = inst_21393);

(statearr_21457[(12)] = inst_21391);

return statearr_21457;
})();
var statearr_21458_21491 = state_21438__$1;
(statearr_21458_21491[(2)] = null);

(statearr_21458_21491[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (3))){
var inst_21436 = (state_21438[(2)]);
var state_21438__$1 = state_21438;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21438__$1,inst_21436);
} else {
if((state_val_21439 === (12))){
var inst_21424 = (state_21438[(2)]);
var state_21438__$1 = state_21438;
var statearr_21459_21492 = state_21438__$1;
(statearr_21459_21492[(2)] = inst_21424);

(statearr_21459_21492[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (2))){
var state_21438__$1 = state_21438;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21438__$1,(4),in$);
} else {
if((state_val_21439 === (23))){
var inst_21432 = (state_21438[(2)]);
var state_21438__$1 = state_21438;
var statearr_21460_21493 = state_21438__$1;
(statearr_21460_21493[(2)] = inst_21432);

(statearr_21460_21493[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (19))){
var inst_21419 = (state_21438[(2)]);
var state_21438__$1 = state_21438;
var statearr_21461_21494 = state_21438__$1;
(statearr_21461_21494[(2)] = inst_21419);

(statearr_21461_21494[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (11))){
var inst_21390 = (state_21438[(8)]);
var inst_21404 = (state_21438[(7)]);
var inst_21404__$1 = cljs.core.seq.call(null,inst_21390);
var state_21438__$1 = (function (){var statearr_21462 = state_21438;
(statearr_21462[(7)] = inst_21404__$1);

return statearr_21462;
})();
if(inst_21404__$1){
var statearr_21463_21495 = state_21438__$1;
(statearr_21463_21495[(1)] = (14));

} else {
var statearr_21464_21496 = state_21438__$1;
(statearr_21464_21496[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (9))){
var inst_21426 = (state_21438[(2)]);
var inst_21427 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_21438__$1 = (function (){var statearr_21465 = state_21438;
(statearr_21465[(15)] = inst_21426);

return statearr_21465;
})();
if(cljs.core.truth_(inst_21427)){
var statearr_21466_21497 = state_21438__$1;
(statearr_21466_21497[(1)] = (21));

} else {
var statearr_21467_21498 = state_21438__$1;
(statearr_21467_21498[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (5))){
var inst_21382 = cljs.core.async.close_BANG_.call(null,out);
var state_21438__$1 = state_21438;
var statearr_21468_21499 = state_21438__$1;
(statearr_21468_21499[(2)] = inst_21382);

(statearr_21468_21499[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (14))){
var inst_21404 = (state_21438[(7)]);
var inst_21406 = cljs.core.chunked_seq_QMARK_.call(null,inst_21404);
var state_21438__$1 = state_21438;
if(inst_21406){
var statearr_21469_21500 = state_21438__$1;
(statearr_21469_21500[(1)] = (17));

} else {
var statearr_21470_21501 = state_21438__$1;
(statearr_21470_21501[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (16))){
var inst_21422 = (state_21438[(2)]);
var state_21438__$1 = state_21438;
var statearr_21471_21502 = state_21438__$1;
(statearr_21471_21502[(2)] = inst_21422);

(statearr_21471_21502[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21439 === (10))){
var inst_21393 = (state_21438[(11)]);
var inst_21391 = (state_21438[(12)]);
var inst_21398 = cljs.core._nth.call(null,inst_21391,inst_21393);
var state_21438__$1 = state_21438;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21438__$1,(13),out,inst_21398);
} else {
if((state_val_21439 === (18))){
var inst_21404 = (state_21438[(7)]);
var inst_21413 = cljs.core.first.call(null,inst_21404);
var state_21438__$1 = state_21438;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21438__$1,(20),out,inst_21413);
} else {
if((state_val_21439 === (8))){
var inst_21392 = (state_21438[(9)]);
var inst_21393 = (state_21438[(11)]);
var inst_21395 = (inst_21393 < inst_21392);
var inst_21396 = inst_21395;
var state_21438__$1 = state_21438;
if(cljs.core.truth_(inst_21396)){
var statearr_21472_21503 = state_21438__$1;
(statearr_21472_21503[(1)] = (10));

} else {
var statearr_21473_21504 = state_21438__$1;
(statearr_21473_21504[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto__))
;
return ((function (switch__18890__auto__,c__19002__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__18891__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__18891__auto____0 = (function (){
var statearr_21477 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21477[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__18891__auto__);

(statearr_21477[(1)] = (1));

return statearr_21477;
});
var cljs$core$async$mapcat_STAR__$_state_machine__18891__auto____1 = (function (state_21438){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_21438);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e21478){if((e21478 instanceof Object)){
var ex__18894__auto__ = e21478;
var statearr_21479_21505 = state_21438;
(statearr_21479_21505[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21438);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21478;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21506 = state_21438;
state_21438 = G__21506;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__18891__auto__ = function(state_21438){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__18891__auto____1.call(this,state_21438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__18891__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__18891__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto__))
})();
var state__19004__auto__ = (function (){var statearr_21480 = f__19003__auto__.call(null);
(statearr_21480[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto__);

return statearr_21480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto__))
);

return c__19002__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args21507 = [];
var len__17893__auto___21510 = arguments.length;
var i__17894__auto___21511 = (0);
while(true){
if((i__17894__auto___21511 < len__17893__auto___21510)){
args21507.push((arguments[i__17894__auto___21511]));

var G__21512 = (i__17894__auto___21511 + (1));
i__17894__auto___21511 = G__21512;
continue;
} else {
}
break;
}

var G__21509 = args21507.length;
switch (G__21509) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21507.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args21514 = [];
var len__17893__auto___21517 = arguments.length;
var i__17894__auto___21518 = (0);
while(true){
if((i__17894__auto___21518 < len__17893__auto___21517)){
args21514.push((arguments[i__17894__auto___21518]));

var G__21519 = (i__17894__auto___21518 + (1));
i__17894__auto___21518 = G__21519;
continue;
} else {
}
break;
}

var G__21516 = args21514.length;
switch (G__21516) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21514.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args21521 = [];
var len__17893__auto___21572 = arguments.length;
var i__17894__auto___21573 = (0);
while(true){
if((i__17894__auto___21573 < len__17893__auto___21572)){
args21521.push((arguments[i__17894__auto___21573]));

var G__21574 = (i__17894__auto___21573 + (1));
i__17894__auto___21573 = G__21574;
continue;
} else {
}
break;
}

var G__21523 = args21521.length;
switch (G__21523) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21521.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19002__auto___21576 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___21576,out){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___21576,out){
return (function (state_21547){
var state_val_21548 = (state_21547[(1)]);
if((state_val_21548 === (7))){
var inst_21542 = (state_21547[(2)]);
var state_21547__$1 = state_21547;
var statearr_21549_21577 = state_21547__$1;
(statearr_21549_21577[(2)] = inst_21542);

(statearr_21549_21577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21548 === (1))){
var inst_21524 = null;
var state_21547__$1 = (function (){var statearr_21550 = state_21547;
(statearr_21550[(7)] = inst_21524);

return statearr_21550;
})();
var statearr_21551_21578 = state_21547__$1;
(statearr_21551_21578[(2)] = null);

(statearr_21551_21578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21548 === (4))){
var inst_21527 = (state_21547[(8)]);
var inst_21527__$1 = (state_21547[(2)]);
var inst_21528 = (inst_21527__$1 == null);
var inst_21529 = cljs.core.not.call(null,inst_21528);
var state_21547__$1 = (function (){var statearr_21552 = state_21547;
(statearr_21552[(8)] = inst_21527__$1);

return statearr_21552;
})();
if(inst_21529){
var statearr_21553_21579 = state_21547__$1;
(statearr_21553_21579[(1)] = (5));

} else {
var statearr_21554_21580 = state_21547__$1;
(statearr_21554_21580[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21548 === (6))){
var state_21547__$1 = state_21547;
var statearr_21555_21581 = state_21547__$1;
(statearr_21555_21581[(2)] = null);

(statearr_21555_21581[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21548 === (3))){
var inst_21544 = (state_21547[(2)]);
var inst_21545 = cljs.core.async.close_BANG_.call(null,out);
var state_21547__$1 = (function (){var statearr_21556 = state_21547;
(statearr_21556[(9)] = inst_21544);

return statearr_21556;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21547__$1,inst_21545);
} else {
if((state_val_21548 === (2))){
var state_21547__$1 = state_21547;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21547__$1,(4),ch);
} else {
if((state_val_21548 === (11))){
var inst_21527 = (state_21547[(8)]);
var inst_21536 = (state_21547[(2)]);
var inst_21524 = inst_21527;
var state_21547__$1 = (function (){var statearr_21557 = state_21547;
(statearr_21557[(7)] = inst_21524);

(statearr_21557[(10)] = inst_21536);

return statearr_21557;
})();
var statearr_21558_21582 = state_21547__$1;
(statearr_21558_21582[(2)] = null);

(statearr_21558_21582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21548 === (9))){
var inst_21527 = (state_21547[(8)]);
var state_21547__$1 = state_21547;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21547__$1,(11),out,inst_21527);
} else {
if((state_val_21548 === (5))){
var inst_21524 = (state_21547[(7)]);
var inst_21527 = (state_21547[(8)]);
var inst_21531 = cljs.core._EQ_.call(null,inst_21527,inst_21524);
var state_21547__$1 = state_21547;
if(inst_21531){
var statearr_21560_21583 = state_21547__$1;
(statearr_21560_21583[(1)] = (8));

} else {
var statearr_21561_21584 = state_21547__$1;
(statearr_21561_21584[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21548 === (10))){
var inst_21539 = (state_21547[(2)]);
var state_21547__$1 = state_21547;
var statearr_21562_21585 = state_21547__$1;
(statearr_21562_21585[(2)] = inst_21539);

(statearr_21562_21585[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21548 === (8))){
var inst_21524 = (state_21547[(7)]);
var tmp21559 = inst_21524;
var inst_21524__$1 = tmp21559;
var state_21547__$1 = (function (){var statearr_21563 = state_21547;
(statearr_21563[(7)] = inst_21524__$1);

return statearr_21563;
})();
var statearr_21564_21586 = state_21547__$1;
(statearr_21564_21586[(2)] = null);

(statearr_21564_21586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto___21576,out))
;
return ((function (switch__18890__auto__,c__19002__auto___21576,out){
return (function() {
var cljs$core$async$state_machine__18891__auto__ = null;
var cljs$core$async$state_machine__18891__auto____0 = (function (){
var statearr_21568 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21568[(0)] = cljs$core$async$state_machine__18891__auto__);

(statearr_21568[(1)] = (1));

return statearr_21568;
});
var cljs$core$async$state_machine__18891__auto____1 = (function (state_21547){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_21547);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e21569){if((e21569 instanceof Object)){
var ex__18894__auto__ = e21569;
var statearr_21570_21587 = state_21547;
(statearr_21570_21587[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21547);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21569;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21588 = state_21547;
state_21547 = G__21588;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$state_machine__18891__auto__ = function(state_21547){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18891__auto____1.call(this,state_21547);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18891__auto____0;
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18891__auto____1;
return cljs$core$async$state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___21576,out))
})();
var state__19004__auto__ = (function (){var statearr_21571 = f__19003__auto__.call(null);
(statearr_21571[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___21576);

return statearr_21571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___21576,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args21589 = [];
var len__17893__auto___21659 = arguments.length;
var i__17894__auto___21660 = (0);
while(true){
if((i__17894__auto___21660 < len__17893__auto___21659)){
args21589.push((arguments[i__17894__auto___21660]));

var G__21661 = (i__17894__auto___21660 + (1));
i__17894__auto___21660 = G__21661;
continue;
} else {
}
break;
}

var G__21591 = args21589.length;
switch (G__21591) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21589.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19002__auto___21663 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___21663,out){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___21663,out){
return (function (state_21629){
var state_val_21630 = (state_21629[(1)]);
if((state_val_21630 === (7))){
var inst_21625 = (state_21629[(2)]);
var state_21629__$1 = state_21629;
var statearr_21631_21664 = state_21629__$1;
(statearr_21631_21664[(2)] = inst_21625);

(statearr_21631_21664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21630 === (1))){
var inst_21592 = (new Array(n));
var inst_21593 = inst_21592;
var inst_21594 = (0);
var state_21629__$1 = (function (){var statearr_21632 = state_21629;
(statearr_21632[(7)] = inst_21593);

(statearr_21632[(8)] = inst_21594);

return statearr_21632;
})();
var statearr_21633_21665 = state_21629__$1;
(statearr_21633_21665[(2)] = null);

(statearr_21633_21665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21630 === (4))){
var inst_21597 = (state_21629[(9)]);
var inst_21597__$1 = (state_21629[(2)]);
var inst_21598 = (inst_21597__$1 == null);
var inst_21599 = cljs.core.not.call(null,inst_21598);
var state_21629__$1 = (function (){var statearr_21634 = state_21629;
(statearr_21634[(9)] = inst_21597__$1);

return statearr_21634;
})();
if(inst_21599){
var statearr_21635_21666 = state_21629__$1;
(statearr_21635_21666[(1)] = (5));

} else {
var statearr_21636_21667 = state_21629__$1;
(statearr_21636_21667[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21630 === (15))){
var inst_21619 = (state_21629[(2)]);
var state_21629__$1 = state_21629;
var statearr_21637_21668 = state_21629__$1;
(statearr_21637_21668[(2)] = inst_21619);

(statearr_21637_21668[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21630 === (13))){
var state_21629__$1 = state_21629;
var statearr_21638_21669 = state_21629__$1;
(statearr_21638_21669[(2)] = null);

(statearr_21638_21669[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21630 === (6))){
var inst_21594 = (state_21629[(8)]);
var inst_21615 = (inst_21594 > (0));
var state_21629__$1 = state_21629;
if(cljs.core.truth_(inst_21615)){
var statearr_21639_21670 = state_21629__$1;
(statearr_21639_21670[(1)] = (12));

} else {
var statearr_21640_21671 = state_21629__$1;
(statearr_21640_21671[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21630 === (3))){
var inst_21627 = (state_21629[(2)]);
var state_21629__$1 = state_21629;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21629__$1,inst_21627);
} else {
if((state_val_21630 === (12))){
var inst_21593 = (state_21629[(7)]);
var inst_21617 = cljs.core.vec.call(null,inst_21593);
var state_21629__$1 = state_21629;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21629__$1,(15),out,inst_21617);
} else {
if((state_val_21630 === (2))){
var state_21629__$1 = state_21629;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21629__$1,(4),ch);
} else {
if((state_val_21630 === (11))){
var inst_21609 = (state_21629[(2)]);
var inst_21610 = (new Array(n));
var inst_21593 = inst_21610;
var inst_21594 = (0);
var state_21629__$1 = (function (){var statearr_21641 = state_21629;
(statearr_21641[(10)] = inst_21609);

(statearr_21641[(7)] = inst_21593);

(statearr_21641[(8)] = inst_21594);

return statearr_21641;
})();
var statearr_21642_21672 = state_21629__$1;
(statearr_21642_21672[(2)] = null);

(statearr_21642_21672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21630 === (9))){
var inst_21593 = (state_21629[(7)]);
var inst_21607 = cljs.core.vec.call(null,inst_21593);
var state_21629__$1 = state_21629;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21629__$1,(11),out,inst_21607);
} else {
if((state_val_21630 === (5))){
var inst_21602 = (state_21629[(11)]);
var inst_21597 = (state_21629[(9)]);
var inst_21593 = (state_21629[(7)]);
var inst_21594 = (state_21629[(8)]);
var inst_21601 = (inst_21593[inst_21594] = inst_21597);
var inst_21602__$1 = (inst_21594 + (1));
var inst_21603 = (inst_21602__$1 < n);
var state_21629__$1 = (function (){var statearr_21643 = state_21629;
(statearr_21643[(11)] = inst_21602__$1);

(statearr_21643[(12)] = inst_21601);

return statearr_21643;
})();
if(cljs.core.truth_(inst_21603)){
var statearr_21644_21673 = state_21629__$1;
(statearr_21644_21673[(1)] = (8));

} else {
var statearr_21645_21674 = state_21629__$1;
(statearr_21645_21674[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21630 === (14))){
var inst_21622 = (state_21629[(2)]);
var inst_21623 = cljs.core.async.close_BANG_.call(null,out);
var state_21629__$1 = (function (){var statearr_21647 = state_21629;
(statearr_21647[(13)] = inst_21622);

return statearr_21647;
})();
var statearr_21648_21675 = state_21629__$1;
(statearr_21648_21675[(2)] = inst_21623);

(statearr_21648_21675[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21630 === (10))){
var inst_21613 = (state_21629[(2)]);
var state_21629__$1 = state_21629;
var statearr_21649_21676 = state_21629__$1;
(statearr_21649_21676[(2)] = inst_21613);

(statearr_21649_21676[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21630 === (8))){
var inst_21602 = (state_21629[(11)]);
var inst_21593 = (state_21629[(7)]);
var tmp21646 = inst_21593;
var inst_21593__$1 = tmp21646;
var inst_21594 = inst_21602;
var state_21629__$1 = (function (){var statearr_21650 = state_21629;
(statearr_21650[(7)] = inst_21593__$1);

(statearr_21650[(8)] = inst_21594);

return statearr_21650;
})();
var statearr_21651_21677 = state_21629__$1;
(statearr_21651_21677[(2)] = null);

(statearr_21651_21677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto___21663,out))
;
return ((function (switch__18890__auto__,c__19002__auto___21663,out){
return (function() {
var cljs$core$async$state_machine__18891__auto__ = null;
var cljs$core$async$state_machine__18891__auto____0 = (function (){
var statearr_21655 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21655[(0)] = cljs$core$async$state_machine__18891__auto__);

(statearr_21655[(1)] = (1));

return statearr_21655;
});
var cljs$core$async$state_machine__18891__auto____1 = (function (state_21629){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_21629);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e21656){if((e21656 instanceof Object)){
var ex__18894__auto__ = e21656;
var statearr_21657_21678 = state_21629;
(statearr_21657_21678[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21629);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21656;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21679 = state_21629;
state_21629 = G__21679;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$state_machine__18891__auto__ = function(state_21629){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18891__auto____1.call(this,state_21629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18891__auto____0;
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18891__auto____1;
return cljs$core$async$state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___21663,out))
})();
var state__19004__auto__ = (function (){var statearr_21658 = f__19003__auto__.call(null);
(statearr_21658[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___21663);

return statearr_21658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___21663,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args21680 = [];
var len__17893__auto___21754 = arguments.length;
var i__17894__auto___21755 = (0);
while(true){
if((i__17894__auto___21755 < len__17893__auto___21754)){
args21680.push((arguments[i__17894__auto___21755]));

var G__21756 = (i__17894__auto___21755 + (1));
i__17894__auto___21755 = G__21756;
continue;
} else {
}
break;
}

var G__21682 = args21680.length;
switch (G__21682) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21680.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19002__auto___21758 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___21758,out){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___21758,out){
return (function (state_21724){
var state_val_21725 = (state_21724[(1)]);
if((state_val_21725 === (7))){
var inst_21720 = (state_21724[(2)]);
var state_21724__$1 = state_21724;
var statearr_21726_21759 = state_21724__$1;
(statearr_21726_21759[(2)] = inst_21720);

(statearr_21726_21759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21725 === (1))){
var inst_21683 = [];
var inst_21684 = inst_21683;
var inst_21685 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21724__$1 = (function (){var statearr_21727 = state_21724;
(statearr_21727[(7)] = inst_21684);

(statearr_21727[(8)] = inst_21685);

return statearr_21727;
})();
var statearr_21728_21760 = state_21724__$1;
(statearr_21728_21760[(2)] = null);

(statearr_21728_21760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21725 === (4))){
var inst_21688 = (state_21724[(9)]);
var inst_21688__$1 = (state_21724[(2)]);
var inst_21689 = (inst_21688__$1 == null);
var inst_21690 = cljs.core.not.call(null,inst_21689);
var state_21724__$1 = (function (){var statearr_21729 = state_21724;
(statearr_21729[(9)] = inst_21688__$1);

return statearr_21729;
})();
if(inst_21690){
var statearr_21730_21761 = state_21724__$1;
(statearr_21730_21761[(1)] = (5));

} else {
var statearr_21731_21762 = state_21724__$1;
(statearr_21731_21762[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21725 === (15))){
var inst_21714 = (state_21724[(2)]);
var state_21724__$1 = state_21724;
var statearr_21732_21763 = state_21724__$1;
(statearr_21732_21763[(2)] = inst_21714);

(statearr_21732_21763[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21725 === (13))){
var state_21724__$1 = state_21724;
var statearr_21733_21764 = state_21724__$1;
(statearr_21733_21764[(2)] = null);

(statearr_21733_21764[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21725 === (6))){
var inst_21684 = (state_21724[(7)]);
var inst_21709 = inst_21684.length;
var inst_21710 = (inst_21709 > (0));
var state_21724__$1 = state_21724;
if(cljs.core.truth_(inst_21710)){
var statearr_21734_21765 = state_21724__$1;
(statearr_21734_21765[(1)] = (12));

} else {
var statearr_21735_21766 = state_21724__$1;
(statearr_21735_21766[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21725 === (3))){
var inst_21722 = (state_21724[(2)]);
var state_21724__$1 = state_21724;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21724__$1,inst_21722);
} else {
if((state_val_21725 === (12))){
var inst_21684 = (state_21724[(7)]);
var inst_21712 = cljs.core.vec.call(null,inst_21684);
var state_21724__$1 = state_21724;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21724__$1,(15),out,inst_21712);
} else {
if((state_val_21725 === (2))){
var state_21724__$1 = state_21724;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21724__$1,(4),ch);
} else {
if((state_val_21725 === (11))){
var inst_21688 = (state_21724[(9)]);
var inst_21692 = (state_21724[(10)]);
var inst_21702 = (state_21724[(2)]);
var inst_21703 = [];
var inst_21704 = inst_21703.push(inst_21688);
var inst_21684 = inst_21703;
var inst_21685 = inst_21692;
var state_21724__$1 = (function (){var statearr_21736 = state_21724;
(statearr_21736[(11)] = inst_21702);

(statearr_21736[(7)] = inst_21684);

(statearr_21736[(8)] = inst_21685);

(statearr_21736[(12)] = inst_21704);

return statearr_21736;
})();
var statearr_21737_21767 = state_21724__$1;
(statearr_21737_21767[(2)] = null);

(statearr_21737_21767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21725 === (9))){
var inst_21684 = (state_21724[(7)]);
var inst_21700 = cljs.core.vec.call(null,inst_21684);
var state_21724__$1 = state_21724;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21724__$1,(11),out,inst_21700);
} else {
if((state_val_21725 === (5))){
var inst_21688 = (state_21724[(9)]);
var inst_21685 = (state_21724[(8)]);
var inst_21692 = (state_21724[(10)]);
var inst_21692__$1 = f.call(null,inst_21688);
var inst_21693 = cljs.core._EQ_.call(null,inst_21692__$1,inst_21685);
var inst_21694 = cljs.core.keyword_identical_QMARK_.call(null,inst_21685,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_21695 = (inst_21693) || (inst_21694);
var state_21724__$1 = (function (){var statearr_21738 = state_21724;
(statearr_21738[(10)] = inst_21692__$1);

return statearr_21738;
})();
if(cljs.core.truth_(inst_21695)){
var statearr_21739_21768 = state_21724__$1;
(statearr_21739_21768[(1)] = (8));

} else {
var statearr_21740_21769 = state_21724__$1;
(statearr_21740_21769[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21725 === (14))){
var inst_21717 = (state_21724[(2)]);
var inst_21718 = cljs.core.async.close_BANG_.call(null,out);
var state_21724__$1 = (function (){var statearr_21742 = state_21724;
(statearr_21742[(13)] = inst_21717);

return statearr_21742;
})();
var statearr_21743_21770 = state_21724__$1;
(statearr_21743_21770[(2)] = inst_21718);

(statearr_21743_21770[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21725 === (10))){
var inst_21707 = (state_21724[(2)]);
var state_21724__$1 = state_21724;
var statearr_21744_21771 = state_21724__$1;
(statearr_21744_21771[(2)] = inst_21707);

(statearr_21744_21771[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21725 === (8))){
var inst_21688 = (state_21724[(9)]);
var inst_21684 = (state_21724[(7)]);
var inst_21692 = (state_21724[(10)]);
var inst_21697 = inst_21684.push(inst_21688);
var tmp21741 = inst_21684;
var inst_21684__$1 = tmp21741;
var inst_21685 = inst_21692;
var state_21724__$1 = (function (){var statearr_21745 = state_21724;
(statearr_21745[(14)] = inst_21697);

(statearr_21745[(7)] = inst_21684__$1);

(statearr_21745[(8)] = inst_21685);

return statearr_21745;
})();
var statearr_21746_21772 = state_21724__$1;
(statearr_21746_21772[(2)] = null);

(statearr_21746_21772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto___21758,out))
;
return ((function (switch__18890__auto__,c__19002__auto___21758,out){
return (function() {
var cljs$core$async$state_machine__18891__auto__ = null;
var cljs$core$async$state_machine__18891__auto____0 = (function (){
var statearr_21750 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21750[(0)] = cljs$core$async$state_machine__18891__auto__);

(statearr_21750[(1)] = (1));

return statearr_21750;
});
var cljs$core$async$state_machine__18891__auto____1 = (function (state_21724){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_21724);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e21751){if((e21751 instanceof Object)){
var ex__18894__auto__ = e21751;
var statearr_21752_21773 = state_21724;
(statearr_21752_21773[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21724);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21751;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21774 = state_21724;
state_21724 = G__21774;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
cljs$core$async$state_machine__18891__auto__ = function(state_21724){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18891__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18891__auto____1.call(this,state_21724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18891__auto____0;
cljs$core$async$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18891__auto____1;
return cljs$core$async$state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___21758,out))
})();
var state__19004__auto__ = (function (){var statearr_21753 = f__19003__auto__.call(null);
(statearr_21753[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___21758);

return statearr_21753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___21758,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map