(ns jlk.data.table)

;;
;; provide operations for acting on tables
;;
;; tables are defined as
;; [:columns [{:key :header :text "name"} {:key :header :text "name"} ...]
;;  :rows [{:header "val" :header "val"} {:header "val" :header "va;"} ... ]
;;
;; this is the same format used by seesaw in creating a table model, but is not quite so convienient as using a map
;; to use as a hash map call (apply hash-map table)
;;
;; treat a spreadsheet like a database
;; call (as-table o) on the worksheet/data first
;;

(defn select
  "select row or rows from a table based on a header comparitor value.  options are :unique, :first())()"
  [table header comparitor value & {:keys [unique first] :as opts}]
  ;; for some reason (nth rs 0) works but (first rs) throws NullPointer
  (let [table (apply hash-map table)]
    (let [rs (filter (fn [row] (comparitor (get row header) value)) (:rows table))]
      (if unique
        (if (empty? rs) nil
            (if (= (count rs) 1) (nth rs 0)
                (throw (Exception. "header comparitor value is not unique in the table"))))
        (if first
          (nth rs 0)
          rs)))))
