(ns jlk.digest.core
  (:use [clojure.java.io :only [input-stream]])
  (:import [org.apache.commons.codec.digest DigestUtils]))

;;
;; FIXME
;; these results differ from md5sum because they do not include the file EOF
;; 

(defmulti md5 class)
(defmethod md5 java.io.InputStream [is] (DigestUtils/md5Hex is))
(defmethod md5 java.io.File [f] (with-open [is (input-stream f)] (DigestUtils/md5Hex is)))

(defmulti md5-byte class)
(defmethod md5-byte java.io.InputStream [is] (DigestUtils/md5 is))
(defmethod md5-byte java.io.File [f] (with-open [is (input-stream f)] (DigestUtils/md5 is)))

(defmulti sha class)
(defmethod sha java.io.InputStream [is] (DigestUtils/shaHex is))
(defmethod sha java.io.File [f] (with-open [is (input-stream f)] (DigestUtils/shaHex is)))

;; TODO sha-byte
(defmulti sha256 class)
(defmethod sha256 java.io.InputStream [is] (DigestUtils/sha256Hex is))
(defmethod sha256 java.io.File [f] (with-open [is (input-stream f)] (DigestUtils/sha256Hex is)))

;; TODO sha256-byte
(defmulti sha512 class)
(defmethod sha512 java.io.InputStream [is] (DigestUtils/sha512Hex is))
(defmethod sha512 java.io.File [f] (with-open [is (input-stream f)] (DigestUtils/sha512Hex is)))

;; TODO sha512-byte


(defmulti calculate (fn [_ format] format))
(defmethod calculate :md5 [f _] (calculate f :md5-hex))
(defmethod calculate :md5-hex [f _] (md5 f))
(defmethod calculate :md5-byte [f _]  (md5-byte f))

(defmethod calculate :sha [f _] (calculate f :sha-hex))
(defmethod calculate :sha-hex [f _]  (sha f))

(defmethod calculate :sha256 [f _] (calculate f :sha256-hex))
(defmethod calculate :sha256-hex [f _] (sha256 f))

(defmethod calculate :sha512 [f _] (calculate f :sha512-hex))
(defmethod calculate :sha512-hex [f _] (sha512 f))


(defonce ^:dynamic *default* :md5-hex)

(defn digest
  "f - file (format is *default*), optional format: one of :md5, :sha, :sha256, :sha512 -> will return a hex string; :md5-byte, :sha-byte, :sha256-byte, :sha512-byte -> will return a byte array"
  ([f]
     (digest f *default*))
  ([f format]
     (calculate f format)))
