(ns jlk.fs.filter
  (:refer-clojure :exclude [re-matches re-find])
  (:require [jlk.fs.core :as core]))

(defn starts-with
  [s]
  (fn [x] (.startsWith (core/name x) s)))

(defn re-matches
  [re]
  (fn [x] (re-matches re (core/name x))))

(defn re-find
  [re]
  (fn [x] (re-find re (core/name x))))

;; (defn filter-type
;;   [t]
;;   (fn [x] (= (:type (type x)) t)))

(defn extension
  [ext]
  (fn [x] (= (and (not= (core/type x) "d")
                  (core/extension x)) ext)))
