(ns jlk.math.parse
  ;(:use [jlk.log.core :only [debug]])
  )

(defn token
  [^String re rank name sym]
  {:re re
   :rank rank
   :name name
   :sym sym})

(def ^:dynamic *tokens*
  {")" {:rank 1 :resolve (symbol ")")}
   "(" {:rank 2 :resolve (symbol "(")}
   "+" {:rank 3 :resolve 'clojure.core/+}
   "-" {:rank 4 :resolve 'clojure.core/-}})

(def ^:dynamic *variables*
  {:a 2})

(defn tokenize
  [s]
  (re-seq #"[(]|[)]|-?[0-9]+(?:\.[0-9]+)?|[+]|[-]|\w+" s))

(def ^:dynamic *number-format* (java.text.DecimalFormat.))

(defn -convert
  [s]
  (try
    (.parse *number-format* s)
    (catch Exception e (or (get *tokens* s)
                           (get *variables* (keyword s))))))

(defn convert
  [ts]
  (map -convert ts))

(defn parse
  [s]
  (convert (tokenize s)))
