(ns jlk.mime.core
  (:import [org.apache.tika.detect MagicDetector]
           [org.apache.tika.metadata Metadata]
           [org.apache.tika.mime MimeTypes MimeTypesFactory]
           [org.apache.tika.parser AutoDetectParser])
  (:use [jlk.system.core :only [resource-stream]]
        [clojure.java.io :only [input-stream]]))

;;
;; mime type detection using apache tika
;;

(defn mime-detector
  "create a mime detector using mimetypes xml file.  will use tike-mimetypes.xml (resource) by default"
  ([]
     (with-open [is (resource-stream "org/apache/tika/mime/tika-mimetypes.xml")]
       (MimeTypesFactory/create is)))
  ([f]
     (with-open [is (input-stream f)]
       (MimeTypesFactory/create is))))

(defn -mimetype
  [using is metadata]
  (.detect using is metadata))

(defn mimetype
  "f is a string or a file, returns [type subtype] as keywords"
  [f]
  (let [m (-mimetype (mime-detector) (input-stream f) (Metadata.))]
    [(keyword (.getType m)) (keyword (.getSubtype m))]))
