(ns jlk.repl.core
  (:refer-clojure :exclude [methods])
  (:use [clojure.reflect :only [type-reflect]]
        [clojure.pprint :only [pprint]])
  (:require [clojure.repl]))

;;
;; TODO:
;; filter :parameter-types and :return-type to only print after the last '.' in a classname
;;

(defmulti -jmembers
  "use reflection on a java class or object to get all object members"
  type)

(defmethod -jmembers
  java.lang.Class
  [o]
  (:members (type-reflect o)))

(defmethod -jmembers
  :default
  [o]
  (:members (type-reflect (class o))))

(defn classname
  "print class name"
  [o]
  (printf "%s\n" (class o)))

(defn constructors
  "use reflection on a java object to print all constructors"
  [o]
  (doseq [m (filter #(and (:parameter-types %)
                          (:exception-types %)
                          (not (:return-type %)))
                    (-jmembers o))]
    (printf "%-64.64s\n"
            (:parameter-types m))))

(defn methods
  "use reflection on a java object to print all methods"
  [o]
  (doseq [m (filter #(and (:parameter-types %)
                          (:exception-types %)
                          (:return-type %))
                    (-jmembers o))]
    (printf "%-32.32s | %-32.32s | %-16.16s\n"
            (:name m)
            (:parameter-types m)
            (:return-type m))))

(defn fields
  "use reflection on a java object to print all fields"
  [o]
  (doseq [m (filter #(:type %)
                    (-jmembers o))]
    (printf "%-32.32s | %-32.32s\n"
            (:name m)
            (:type m))))

(defn ls
  "print functions defined in this namespace"
  []
  (doseq [[k v] (ns-interns *ns*)]
    (printf "%-32.32s\n" k)))

(defmacro doc
  "alias for clojure.repl/doc so you only import one namespace"
  [name]
  `(clojure.repl/doc ~name))
