/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.ogr;

import java.util.Vector;
import org.gdal.ogr.FeatureDefn;
import org.gdal.ogr.FeatureNative;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.GeomFieldDefn;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.ogrJNI;

public class Feature
implements Cloneable {
    private long swigCPtr;
    private FeatureNative nativeObject;

    public Feature(long cPtr, boolean cMemoryOwn) {
        if (cPtr == 0L) {
            throw new RuntimeException();
        }
        this.swigCPtr = cPtr;
        if (cMemoryOwn) {
            this.nativeObject = new FeatureNative(this, cPtr);
        }
    }

    public static long getCPtr(Feature obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public void delete() {
        if (this.nativeObject != null) {
            this.nativeObject.delete();
            this.nativeObject = null;
        }
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Feature) {
            equal = this.Equal((Feature)obj);
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public Object clone() {
        return this.Clone();
    }

    public Feature(FeatureDefn feature_def) {
        this(ogrJNI.new_Feature(FeatureDefn.getCPtr(feature_def), feature_def), true);
    }

    public FeatureDefn GetDefnRef() {
        long cPtr = ogrJNI.Feature_GetDefnRef(this.swigCPtr, this);
        FeatureDefn ret = null;
        if (cPtr != 0L) {
            ret = new FeatureDefn(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public int SetGeometry(Geometry geom) {
        return ogrJNI.Feature_SetGeometry(this.swigCPtr, this, Geometry.getCPtr(geom), geom);
    }

    public int SetGeometryDirectly(Geometry geom) {
        int ret = ogrJNI.Feature_SetGeometryDirectly(this.swigCPtr, this, Geometry.getCPtrAndDisown(geom), geom);
        if (geom != null) {
            geom.addReference(this);
        }
        return ret;
    }

    public Geometry GetGeometryRef() {
        long cPtr = ogrJNI.Feature_GetGeometryRef(this.swigCPtr, this);
        Geometry ret = null;
        if (cPtr != 0L) {
            ret = new Geometry(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public int SetGeomField(int iField, Geometry geom) {
        return ogrJNI.Feature_SetGeomField__SWIG_0(this.swigCPtr, this, iField, Geometry.getCPtr(geom), geom);
    }

    public int SetGeomField(String name, Geometry geom) {
        return ogrJNI.Feature_SetGeomField__SWIG_1(this.swigCPtr, this, name, Geometry.getCPtr(geom), geom);
    }

    public int SetGeomFieldDirectly(int iField, Geometry geom) {
        return ogrJNI.Feature_SetGeomFieldDirectly__SWIG_0(this.swigCPtr, this, iField, Geometry.getCPtrAndDisown(geom), geom);
    }

    public int SetGeomFieldDirectly(String name, Geometry geom) {
        return ogrJNI.Feature_SetGeomFieldDirectly__SWIG_1(this.swigCPtr, this, name, Geometry.getCPtrAndDisown(geom), geom);
    }

    public Geometry GetGeomFieldRef(int iField) {
        long cPtr = ogrJNI.Feature_GetGeomFieldRef__SWIG_0(this.swigCPtr, this, iField);
        Geometry ret = null;
        if (cPtr != 0L) {
            ret = new Geometry(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Geometry GetGeomFieldRef(String name) {
        long cPtr = ogrJNI.Feature_GetGeomFieldRef__SWIG_1(this.swigCPtr, this, name);
        Geometry ret = null;
        if (cPtr != 0L) {
            ret = new Geometry(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Feature Clone() {
        long cPtr = ogrJNI.Feature_Clone(this.swigCPtr, this);
        return cPtr == 0L ? null : new Feature(cPtr, true);
    }

    public boolean Equal(Feature feature) {
        return ogrJNI.Feature_Equal(this.swigCPtr, this, Feature.getCPtr(feature), feature);
    }

    public int GetFieldCount() {
        return ogrJNI.Feature_GetFieldCount(this.swigCPtr, this);
    }

    public FieldDefn GetFieldDefnRef(int id) {
        long cPtr = ogrJNI.Feature_GetFieldDefnRef__SWIG_0(this.swigCPtr, this, id);
        FieldDefn ret = null;
        if (cPtr != 0L) {
            ret = new FieldDefn(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public FieldDefn GetFieldDefnRef(String name) {
        long cPtr = ogrJNI.Feature_GetFieldDefnRef__SWIG_1(this.swigCPtr, this, name);
        FieldDefn ret = null;
        if (cPtr != 0L) {
            ret = new FieldDefn(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public int GetGeomFieldCount() {
        return ogrJNI.Feature_GetGeomFieldCount(this.swigCPtr, this);
    }

    public GeomFieldDefn GetGeomFieldDefnRef(int id) {
        long cPtr = ogrJNI.Feature_GetGeomFieldDefnRef__SWIG_0(this.swigCPtr, this, id);
        return cPtr == 0L ? null : new GeomFieldDefn(cPtr, false);
    }

    public GeomFieldDefn GetGeomFieldDefnRef(String name) {
        long cPtr = ogrJNI.Feature_GetGeomFieldDefnRef__SWIG_1(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new GeomFieldDefn(cPtr, false);
    }

    public String GetFieldAsString(int id) {
        return ogrJNI.Feature_GetFieldAsString__SWIG_0(this.swigCPtr, this, id);
    }

    public String GetFieldAsString(String name) {
        return ogrJNI.Feature_GetFieldAsString__SWIG_1(this.swigCPtr, this, name);
    }

    public int GetFieldAsInteger(int id) {
        return ogrJNI.Feature_GetFieldAsInteger__SWIG_0(this.swigCPtr, this, id);
    }

    public int GetFieldAsInteger(String name) {
        return ogrJNI.Feature_GetFieldAsInteger__SWIG_1(this.swigCPtr, this, name);
    }

    public long GetFieldAsInteger64(int id) {
        return ogrJNI.Feature_GetFieldAsInteger64__SWIG_0(this.swigCPtr, this, id);
    }

    public long GetFieldAsInteger64(String name) {
        return ogrJNI.Feature_GetFieldAsInteger64__SWIG_1(this.swigCPtr, this, name);
    }

    public double GetFieldAsDouble(int id) {
        return ogrJNI.Feature_GetFieldAsDouble__SWIG_0(this.swigCPtr, this, id);
    }

    public double GetFieldAsDouble(String name) {
        return ogrJNI.Feature_GetFieldAsDouble__SWIG_1(this.swigCPtr, this, name);
    }

    public void GetFieldAsDateTime(int id, int[] pnYear, int[] pnMonth, int[] pnDay, int[] pnHour, int[] pnMinute, float[] pfSecond, int[] pnTZFlag) {
        ogrJNI.Feature_GetFieldAsDateTime(this.swigCPtr, this, id, pnYear, pnMonth, pnDay, pnHour, pnMinute, pfSecond, pnTZFlag);
    }

    public int[] GetFieldAsIntegerList(int id) {
        return ogrJNI.Feature_GetFieldAsIntegerList(this.swigCPtr, this, id);
    }

    public double[] GetFieldAsDoubleList(int id) {
        return ogrJNI.Feature_GetFieldAsDoubleList(this.swigCPtr, this, id);
    }

    public String[] GetFieldAsStringList(int id) {
        return ogrJNI.Feature_GetFieldAsStringList(this.swigCPtr, this, id);
    }

    public byte[] GetFieldAsBinary(int id) {
        return ogrJNI.Feature_GetFieldAsBinary__SWIG_0(this.swigCPtr, this, id);
    }

    public byte[] GetFieldAsBinary(String name) {
        return ogrJNI.Feature_GetFieldAsBinary__SWIG_1(this.swigCPtr, this, name);
    }

    public boolean IsFieldSet(int id) {
        return ogrJNI.Feature_IsFieldSet__SWIG_0(this.swigCPtr, this, id);
    }

    public boolean IsFieldSet(String name) {
        return ogrJNI.Feature_IsFieldSet__SWIG_1(this.swigCPtr, this, name);
    }

    public int GetFieldIndex(String name) {
        return ogrJNI.Feature_GetFieldIndex(this.swigCPtr, this, name);
    }

    public int GetGeomFieldIndex(String name) {
        return ogrJNI.Feature_GetGeomFieldIndex(this.swigCPtr, this, name);
    }

    public long GetFID() {
        return ogrJNI.Feature_GetFID(this.swigCPtr, this);
    }

    public int SetFID(long fid) {
        return ogrJNI.Feature_SetFID(this.swigCPtr, this, fid);
    }

    public void DumpReadable() {
        ogrJNI.Feature_DumpReadable(this.swigCPtr, this);
    }

    public void UnsetField(int id) {
        ogrJNI.Feature_UnsetField__SWIG_0(this.swigCPtr, this, id);
    }

    public void UnsetField(String name) {
        ogrJNI.Feature_UnsetField__SWIG_1(this.swigCPtr, this, name);
    }

    public void SetField(int id, String value) {
        ogrJNI.Feature_SetField__SWIG_0(this.swigCPtr, this, id, value);
    }

    public void SetField(String name, String value) {
        ogrJNI.Feature_SetField__SWIG_1(this.swigCPtr, this, name, value);
    }

    public void SetFieldInteger64(int id, long value) {
        ogrJNI.Feature_SetFieldInteger64(this.swigCPtr, this, id, value);
    }

    public void SetField(int id, int value) {
        ogrJNI.Feature_SetField__SWIG_2(this.swigCPtr, this, id, value);
    }

    public void SetField(String name, int value) {
        ogrJNI.Feature_SetField__SWIG_3(this.swigCPtr, this, name, value);
    }

    public void SetField(int id, double value) {
        ogrJNI.Feature_SetField__SWIG_4(this.swigCPtr, this, id, value);
    }

    public void SetField(String name, double value) {
        ogrJNI.Feature_SetField__SWIG_5(this.swigCPtr, this, name, value);
    }

    public void SetField(int id, int year, int month, int day, int hour, int minute, float second, int tzflag) {
        ogrJNI.Feature_SetField__SWIG_6(this.swigCPtr, this, id, year, month, day, hour, minute, second, tzflag);
    }

    public void SetField(String name, int year, int month, int day, int hour, int minute, float second, int tzflag) {
        ogrJNI.Feature_SetField__SWIG_7(this.swigCPtr, this, name, year, month, day, hour, minute, second, tzflag);
    }

    public void SetFieldIntegerList(int id, int[] nList) {
        ogrJNI.Feature_SetFieldIntegerList(this.swigCPtr, this, id, nList);
    }

    public void SetFieldDoubleList(int id, double[] nList) {
        ogrJNI.Feature_SetFieldDoubleList(this.swigCPtr, this, id, nList);
    }

    public void SetFieldStringList(int id, Vector pList) {
        ogrJNI.Feature_SetFieldStringList(this.swigCPtr, this, id, pList);
    }

    public void SetFieldBinaryFromHexString(int id, String pszValue) {
        ogrJNI.Feature_SetFieldBinaryFromHexString__SWIG_0(this.swigCPtr, this, id, pszValue);
    }

    public void SetFieldBinaryFromHexString(String name, String pszValue) {
        ogrJNI.Feature_SetFieldBinaryFromHexString__SWIG_1(this.swigCPtr, this, name, pszValue);
    }

    public int SetFrom(Feature other, int forgiving) {
        return ogrJNI.Feature_SetFrom__SWIG_0(this.swigCPtr, this, Feature.getCPtr(other), other, forgiving);
    }

    public int SetFrom(Feature other) {
        return ogrJNI.Feature_SetFrom__SWIG_1(this.swigCPtr, this, Feature.getCPtr(other), other);
    }

    public int SetFromWithMap(Feature other, int forgiving, int[] nList) {
        return ogrJNI.Feature_SetFromWithMap(this.swigCPtr, this, Feature.getCPtr(other), other, forgiving, nList);
    }

    public String GetStyleString() {
        return ogrJNI.Feature_GetStyleString(this.swigCPtr, this);
    }

    public void SetStyleString(String the_string) {
        ogrJNI.Feature_SetStyleString(this.swigCPtr, this, the_string);
    }

    public int GetFieldType(int id) {
        return ogrJNI.Feature_GetFieldType__SWIG_0(this.swigCPtr, this, id);
    }

    public int GetFieldType(String name) {
        return ogrJNI.Feature_GetFieldType__SWIG_1(this.swigCPtr, this, name);
    }

    public int Validate(int flags, int bEmitError) {
        return ogrJNI.Feature_Validate__SWIG_0(this.swigCPtr, this, flags, bEmitError);
    }

    public int Validate(int flags) {
        return ogrJNI.Feature_Validate__SWIG_1(this.swigCPtr, this, flags);
    }

    public int Validate() {
        return ogrJNI.Feature_Validate__SWIG_2(this.swigCPtr, this);
    }

    public void FillUnsetWithDefault(int bNotNullableOnly, Vector options) {
        ogrJNI.Feature_FillUnsetWithDefault__SWIG_0(this.swigCPtr, this, bNotNullableOnly, options);
    }

    public void FillUnsetWithDefault(int bNotNullableOnly) {
        ogrJNI.Feature_FillUnsetWithDefault__SWIG_1(this.swigCPtr, this, bNotNullableOnly);
    }

    public void FillUnsetWithDefault() {
        ogrJNI.Feature_FillUnsetWithDefault__SWIG_2(this.swigCPtr, this);
    }
}

