/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.egl;

import com.sun.gluegen.runtime.DynamicLookupHelper;
import com.sun.gluegen.runtime.NativeLibrary;
import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.NativeLibLoader;
import com.sun.opengl.impl.egl.EGL;
import com.sun.opengl.impl.egl.EGLES1DynamicLookupHelper;
import com.sun.opengl.impl.egl.EGLES2DynamicLookupHelper;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public abstract class EGLDynamicLookupHelper
implements DynamicLookupHelper {
    protected static final boolean DEBUG;
    protected static final boolean DEBUG_LOOKUP;
    private static final EGLDynamicLookupHelper eglES1DynamicLookupHelper;
    private static final EGLDynamicLookupHelper eglES2DynamicLookupHelper;
    private List glesLibraries;
    private long eglGetProcAddressHandle = 0L;

    public static EGLDynamicLookupHelper getDynamicLookupHelper(GLProfile gLProfile) {
        if (gLProfile.usesNativeGLES2()) {
            if (null == eglES2DynamicLookupHelper) {
                throw new GLException("EGLDynamicLookupHelper for ES2 not available");
            }
            return eglES2DynamicLookupHelper;
        }
        if (gLProfile.usesNativeGLES1()) {
            if (null == eglES1DynamicLookupHelper) {
                throw new GLException("EGLDynamicLookupHelper for ES1 not available");
            }
            return eglES1DynamicLookupHelper;
        }
        throw new GLException("Unsupported: " + gLProfile);
    }

    public static EGLDynamicLookupHelper getDynamicLookupHelper(int n) {
        if (2 == n) {
            if (null == eglES2DynamicLookupHelper) {
                throw new GLException("EGLDynamicLookupHelper for ES2 not available");
            }
            return eglES2DynamicLookupHelper;
        }
        if (1 == n) {
            if (null == eglES1DynamicLookupHelper) {
                throw new GLException("EGLDynamicLookupHelper for ES1 not available");
            }
            return eglES1DynamicLookupHelper;
        }
        throw new GLException("Unsupported: ES" + n);
    }

    protected EGLDynamicLookupHelper() {
        this.loadGLESLibrary(this.getESProfile());
        EGL.resetProcAddressTable(this);
    }

    protected abstract int getESProfile();

    protected abstract List getGLESLibNames();

    protected List getEGLLibNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("EGL");
        arrayList.add("libEGL");
        return arrayList;
    }

    private NativeLibrary loadFirstAvailable(List list, ClassLoader classLoader) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NativeLibrary nativeLibrary = NativeLibrary.open((String)((String)iterator.next()), (ClassLoader)classLoader, (boolean)false);
            if (nativeLibrary == null) continue;
            return nativeLibrary;
        }
        return null;
    }

    private void loadGLESLibrary(int n) {
        List list = this.getGLESLibNames();
        List list2 = this.getEGLLibNames();
        ClassLoader classLoader = this.getClass().getClassLoader();
        NativeLibrary nativeLibrary = null;
        this.glesLibraries = new ArrayList();
        nativeLibrary = this.loadFirstAvailable(list, classLoader);
        if (nativeLibrary == null) {
            throw new GLException("Unable to dynamically load OpenGL ES library for profile ES" + n);
        }
        this.glesLibraries.add(nativeLibrary);
        if (null != list2 && list2.size() > 0) {
            nativeLibrary = this.loadFirstAvailable(list2, classLoader);
            if (nativeLibrary == null) {
                throw new GLException("Unable to dynamically load EGL library for profile ES" + n);
            }
            this.glesLibraries.add(nativeLibrary);
        }
        if (n == 2) {
            NativeLibLoader.loadES2();
        } else if (n == 1) {
            NativeLibLoader.loadES1();
        } else {
            throw new GLException("Unsupported: ES" + n);
        }
    }

    private long dynamicLookupFunctionOnLibs(String string) {
        String string2 = string;
        long l = this.dynamicLookupFunctionOnLibsImpl(string2);
        if (0L == l && "Windows".equals(NativeWindowFactory.getNativeWindowType((boolean)false))) {
            for (int i = 0; 0L == l && i <= 12; ++i) {
                string2 = "_" + string + "@" + i * 4;
                l = this.dynamicLookupFunctionOnLibsImpl(string2);
            }
        }
        if (DEBUG_LOOKUP) {
            if (0L != l) {
                System.err.println("Lookup-Native: " + string + " / " + string2 + " 0x" + Long.toHexString(l));
            } else {
                System.err.println("Lookup-Native: " + string + " / " + string2 + " ** FAILED ** ");
            }
        }
        return l;
    }

    private long dynamicLookupFunctionOnLibsImpl(String string) {
        Iterator iterator = this.glesLibraries.iterator();
        while (iterator.hasNext()) {
            NativeLibrary nativeLibrary = (NativeLibrary)iterator.next();
            long l = nativeLibrary.lookupFunction(string);
            if (l == 0L) continue;
            return l;
        }
        return 0L;
    }

    public long dynamicLookupFunction(String string) {
        if (null == string) {
            return 0L;
        }
        if (0L == this.eglGetProcAddressHandle) {
            this.eglGetProcAddressHandle = this.dynamicLookupFunctionOnLibs("eglGetProcAddress");
            if (0L == this.eglGetProcAddressHandle) {
                GLException gLException = new GLException("Couldn't find eglGetProcAddress function entry");
                if (DEBUG) {
                    gLException.printStackTrace();
                }
                throw gLException;
            }
        }
        if (string.equals("eglGetProcAddress")) {
            return this.eglGetProcAddressHandle;
        }
        long l = EGL.eglGetProcAddress(this.eglGetProcAddressHandle, string);
        if (DEBUG_LOOKUP && 0L != l) {
            System.err.println("Lookup-EGL: <" + string + "> 0x" + Long.toHexString(l));
        }
        if (0L == l) {
            l = this.dynamicLookupFunctionOnLibs(string);
        }
        return l;
    }

    static {
        EGLDynamicLookupHelper eGLDynamicLookupHelper;
        block5: {
            block4: {
                DEBUG = Debug.debug((String)"EGL");
                AccessControlContext accessControlContext = AccessController.getContext();
                DEBUG_LOOKUP = Debug.isPropertyDefined((String)"jogl.debug.DynamicLookup", (boolean)true, (AccessControlContext)accessControlContext);
                eGLDynamicLookupHelper = null;
                try {
                    eGLDynamicLookupHelper = new EGLES1DynamicLookupHelper();
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block4;
                    throwable.printStackTrace();
                }
            }
            eglES1DynamicLookupHelper = eGLDynamicLookupHelper;
            eGLDynamicLookupHelper = null;
            try {
                eGLDynamicLookupHelper = new EGLES2DynamicLookupHelper();
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block5;
                throwable.printStackTrace();
            }
        }
        eglES2DynamicLookupHelper = eGLDynamicLookupHelper;
    }
}

