/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nativewindow.impl;

import com.sun.nativewindow.impl.Debug;
import com.sun.nativewindow.impl.NWReflection;
import java.lang.reflect.Constructor;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ToolkitLock;

public class NativeWindowFactoryImpl
extends NativeWindowFactory {
    protected static final boolean DEBUG = Debug.debug("NativeWindowFactoryImpl");
    private Constructor nativeWindowConstructor = null;
    private ToolkitLock toolkitLock = new ToolkitLock(){

        public void lock() {
        }

        public void unlock() {
        }
    };

    protected NativeWindow getNativeWindowImpl(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) throws IllegalArgumentException {
        if (null == object) {
            throw new IllegalArgumentException("winObj is null");
        }
        if (object instanceof NativeWindow) {
            return (NativeWindow)object;
        }
        if (null == abstractGraphicsConfiguration) {
            throw new IllegalArgumentException("AbstractGraphicsConfiguration is null with a non NativeWindow object");
        }
        if (NWReflection.isAWTComponent(object)) {
            return this.getAWTNativeWindow(object, abstractGraphicsConfiguration);
        }
        throw new IllegalArgumentException("Target window object type " + object.getClass().getName() + " is unsupported; expected " + "javax.media.nativewindow.NativeWindow or java.awt.Component");
    }

    private NativeWindow getAWTNativeWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        if (this.nativeWindowConstructor == null) {
            try {
                String string = NativeWindowFactoryImpl.getNativeWindowType(true);
                String string2 = null;
                if (string.equals("Windows")) {
                    string2 = "com.sun.nativewindow.impl.jawt.windows.WindowsJAWTWindow";
                } else if (string.equals("MacOSX")) {
                    string2 = "com.sun.nativewindow.impl.jawt.macosx.MacOSXJAWTWindow";
                } else if (string.equals("X11")) {
                    string2 = "com.sun.nativewindow.impl.jawt.x11.X11JAWTWindow";
                } else {
                    throw new IllegalArgumentException("OS " + NativeWindowFactoryImpl.getNativeOSName(false) + " not yet supported");
                }
                this.nativeWindowConstructor = NWReflection.getConstructor(string2, new Class[]{Object.class, AbstractGraphicsConfiguration.class});
            }
            catch (Exception exception) {
                throw (IllegalArgumentException)new IllegalArgumentException().initCause(exception);
            }
        }
        try {
            return (NativeWindow)this.nativeWindowConstructor.newInstance(object, abstractGraphicsConfiguration);
        }
        catch (Exception exception) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(exception);
        }
    }

    public ToolkitLock getToolkitLock() {
        return this.toolkitLock;
    }
}

