/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import com.sun.nativewindow.impl.Debug;
import com.sun.nativewindow.impl.GraphicsConfigurationFactoryImpl;
import com.sun.nativewindow.impl.NWReflection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.x11.X11GraphicsDevice;

public abstract class GraphicsConfigurationFactory {
    protected static final boolean DEBUG = Debug.debug("GraphicsConfiguration");
    private static Map registeredFactories = Collections.synchronizedMap(new HashMap());
    private static Class abstractGraphicsDeviceClass;

    protected GraphicsConfigurationFactory() {
    }

    private static void initialize() {
        Object var0 = null;
        Class clazz = abstractGraphicsDeviceClass = AbstractGraphicsDevice.class;
        if ("X11".equals(NativeWindowFactory.getNativeWindowType(true))) {
            try {
                GraphicsConfigurationFactory graphicsConfigurationFactory = (GraphicsConfigurationFactory)NWReflection.createInstance("com.sun.nativewindow.impl.x11.X11GraphicsConfigurationFactory", new Object[0]);
                GraphicsConfigurationFactory.registerFactory(X11GraphicsDevice.class, graphicsConfigurationFactory);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        GraphicsConfigurationFactory.registerFactory(abstractGraphicsDeviceClass, new GraphicsConfigurationFactoryImpl());
    }

    public static GraphicsConfigurationFactory getFactory(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (abstractGraphicsDevice == null) {
            return GraphicsConfigurationFactory.getFactory(AbstractGraphicsDevice.class);
        }
        return GraphicsConfigurationFactory.getFactory(abstractGraphicsDevice.getClass());
    }

    public static GraphicsConfigurationFactory getFactory(Class clazz) throws IllegalArgumentException, NativeWindowException {
        if (!abstractGraphicsDeviceClass.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Given class must implement AbstractGraphicsDevice");
        }
        GraphicsConfigurationFactory graphicsConfigurationFactory = null;
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            graphicsConfigurationFactory = (GraphicsConfigurationFactory)registeredFactories.get(clazz2);
            if (graphicsConfigurationFactory == null) continue;
            if (DEBUG) {
                System.err.println("GraphicsConfigurationFactory.getFactory() " + clazz + " -> " + graphicsConfigurationFactory);
            }
            return graphicsConfigurationFactory;
        }
        graphicsConfigurationFactory = (GraphicsConfigurationFactory)registeredFactories.get(abstractGraphicsDeviceClass);
        if (DEBUG) {
            System.err.println("GraphicsConfigurationFactory.getFactory() DEFAULT " + abstractGraphicsDeviceClass + " -> " + graphicsConfigurationFactory);
        }
        return graphicsConfigurationFactory;
    }

    protected static void registerFactory(Class clazz, GraphicsConfigurationFactory graphicsConfigurationFactory) throws IllegalArgumentException {
        if (!abstractGraphicsDeviceClass.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Given class must implement AbstractGraphicsDevice");
        }
        if (DEBUG) {
            System.err.println("GraphicsConfigurationFactory.registerFactory() " + clazz + " -> " + graphicsConfigurationFactory);
        }
        registeredFactories.put(clazz, graphicsConfigurationFactory);
    }

    public abstract AbstractGraphicsConfiguration chooseGraphicsConfiguration(Capabilities var1, CapabilitiesChooser var2, AbstractGraphicsScreen var3) throws IllegalArgumentException, NativeWindowException;

    static {
        GraphicsConfigurationFactory.initialize();
    }
}

