/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.newt.awt;

import com.sun.javafx.newt.Insets;
import com.sun.javafx.newt.Window;
import com.sun.javafx.newt.awt.AWTCanvas;
import com.sun.javafx.newt.awt.AWTDisplay;
import com.sun.javafx.newt.awt.AWTScreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.awt.AWTGraphicsDevice;
import javax.media.nativewindow.awt.AWTGraphicsScreen;

public class AWTWindow
extends Window {
    private boolean owningFrame;
    private Container container = null;
    private Frame frame = null;
    private AWTCanvas canvas;
    private int nfs_width;
    private int nfs_height;
    private int nfs_x;
    private int nfs_y;
    private static final int WINDOW_EVENT = 1;
    private static final int KEY_EVENT = 2;
    private static final int MOUSE_EVENT = 3;

    public AWTWindow() {
        this(null);
    }

    public static Class[] getCustomConstructorArgumentTypes() {
        return new Class[]{Container.class};
    }

    public AWTWindow(Container container) {
        this.title = "AWT NewtWindow";
        this.container = container;
        if (container instanceof Frame) {
            this.frame = (Frame)container;
        }
    }

    public void setTitle(final String string) {
        super.setTitle(string);
        AWTWindow.runOnEDT(true, new Runnable(){

            public void run() {
                if (AWTWindow.this.frame != null) {
                    AWTWindow.this.frame.setTitle(string);
                }
            }
        });
    }

    protected void createNative(long l, final Capabilities capabilities) {
        if (0L != l) {
            throw new RuntimeException("Window parenting not supported in AWT, use AWTWindow(Frame) cstr for wrapping instead");
        }
        final AWTWindow aWTWindow = this;
        AWTWindow.runOnEDT(true, new Runnable(){

            public void run() {
                if (null == AWTWindow.this.container) {
                    AWTWindow.this.frame = new Frame();
                    AWTWindow.this.container = AWTWindow.this.frame;
                    AWTWindow.this.owningFrame = true;
                } else {
                    AWTWindow.this.owningFrame = false;
                    AWTWindow.this.width = AWTWindow.this.container.getWidth();
                    AWTWindow.this.height = AWTWindow.this.container.getHeight();
                    AWTWindow.this.x = AWTWindow.this.container.getX();
                    AWTWindow.this.y = AWTWindow.this.container.getY();
                }
                if (null != AWTWindow.this.frame) {
                    AWTWindow.this.frame.setTitle(AWTWindow.this.getTitle());
                }
                AWTWindow.this.container.setLayout(new BorderLayout());
                AWTWindow.this.canvas = new AWTCanvas(capabilities);
                Listener listener = new Listener(aWTWindow);
                AWTWindow.this.canvas.addMouseListener(listener);
                AWTWindow.this.canvas.addMouseMotionListener(listener);
                AWTWindow.this.canvas.addKeyListener(listener);
                AWTWindow.this.canvas.addComponentListener(listener);
                AWTWindow.this.container.add((Component)AWTWindow.this.canvas, "Center");
                AWTWindow.this.container.setSize(AWTWindow.this.width, AWTWindow.this.height);
                AWTWindow.this.container.setLocation(AWTWindow.this.x, AWTWindow.this.y);
                AWTWindow.this.container.addComponentListener(new MoveListener(aWTWindow));
                if (null != AWTWindow.this.frame) {
                    AWTWindow.this.frame.setUndecorated(AWTWindow.this.undecorated || AWTWindow.this.fullscreen);
                    AWTWindow.this.frame.addWindowListener(new WindowEventListener(aWTWindow));
                }
            }
        });
    }

    protected void closeNative() {
        AWTWindow.runOnEDT(true, new Runnable(){

            public void run() {
                if (AWTWindow.this.owningFrame && null != AWTWindow.this.frame) {
                    AWTWindow.this.frame.dispose();
                    AWTWindow.this.owningFrame = false;
                }
                AWTWindow.this.frame = null;
            }
        });
    }

    public boolean hasDeviceChanged() {
        boolean bl = this.canvas.hasDeviceChanged();
        if (bl) {
            this.config = this.canvas.getAWTGraphicsConfiguration();
            if (this.config == null) {
                throw new NativeWindowException("Error Device change null GraphicsConfiguration: " + (Object)((Object)this));
            }
            this.updateDeviceData();
        }
        return bl;
    }

    public void setVisible(final boolean bl) {
        AWTWindow.runOnEDT(true, new Runnable(){

            public void run() {
                AWTWindow.this.container.setVisible(bl);
            }
        });
        this.config = this.canvas.getAWTGraphicsConfiguration();
        if (this.config == null) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + (Object)((Object)this));
        }
        this.updateDeviceData();
    }

    private void updateDeviceData() {
        ((AWTScreen)this.getScreen()).setAWTGraphicsScreen((AWTGraphicsScreen)this.config.getScreen());
        ((AWTDisplay)this.getScreen().getDisplay()).setAWTGraphicsDevice((AWTGraphicsDevice)this.config.getScreen().getDevice());
        DisplayMode displayMode = ((AWTGraphicsDevice)this.config.getScreen().getDevice()).getGraphicsDevice().getDisplayMode();
        int n = displayMode.getWidth();
        int n2 = displayMode.getHeight();
        ((AWTScreen)this.screen).setScreenSize(n, n2);
    }

    public void setSize(final int n, final int n2) {
        this.width = n;
        this.height = n2;
        if (!this.fullscreen) {
            this.nfs_width = n;
            this.nfs_height = n2;
        }
        AWTWindow.runOnEDT(false, new Runnable(){

            public void run() {
                java.awt.Insets insets = AWTWindow.this.container.getInsets();
                AWTWindow.this.container.setSize(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
            }
        });
    }

    public Insets getInsets() {
        final int[] nArray = new int[]{0, 0, 0, 0};
        AWTWindow.runOnEDT(true, new Runnable(){

            public void run() {
                java.awt.Insets insets = AWTWindow.this.container.getInsets();
                nArray[0] = insets.top;
                nArray[1] = insets.left;
                nArray[2] = insets.bottom;
                nArray[3] = insets.right;
            }
        });
        return new Insets(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public void setPosition(final int n, final int n2) {
        this.x = n;
        this.y = n2;
        if (!this.fullscreen) {
            this.nfs_x = n;
            this.nfs_y = n2;
        }
        AWTWindow.runOnEDT(true, new Runnable(){

            public void run() {
                AWTWindow.this.container.setLocation(n, n2);
            }
        });
    }

    public boolean setFullscreen(final boolean bl) {
        if (this.fullscreen != bl) {
            int n;
            int n2;
            int n3;
            int n4;
            this.fullscreen = bl;
            if (bl) {
                n4 = 0;
                n3 = 0;
                n2 = this.screen.getWidth();
                n = this.screen.getHeight();
            } else {
                n4 = this.nfs_x;
                n3 = this.nfs_y;
                n2 = this.nfs_width;
                n = this.nfs_height;
            }
            if (DEBUG_IMPLEMENTATION || DEBUG_WINDOW_EVENT) {
                System.err.println("AWTWindow fs: " + bl + " " + n4 + "/" + n3 + " " + n2 + "x" + n);
            }
            AWTWindow.runOnEDT(false, new Runnable(){

                public void run() {
                    if (null != AWTWindow.this.frame) {
                        if (!AWTWindow.this.container.isDisplayable()) {
                            AWTWindow.this.frame.setUndecorated(AWTWindow.this.undecorated || bl);
                        } else if (Window.DEBUG_IMPLEMENTATION || Window.DEBUG_WINDOW_EVENT) {
                            System.err.println("AWTWindow can't undecorate already created frame");
                        }
                    }
                    AWTWindow.this.container.setLocation(n4, n3);
                    AWTWindow.this.container.setSize(n2, n);
                }
            });
        }
        return true;
    }

    public Object getWrappedWindow() {
        return this.canvas;
    }

    protected void sendWindowEvent(int n) {
        super.sendWindowEvent(n);
    }

    protected void sendKeyEvent(int n, int n2, int n3, char c) {
        super.sendKeyEvent(n, n2, n3, c);
    }

    protected void sendMouseEvent(int n, int n2, int n3, int n4, int n5, int n6) {
        super.sendMouseEvent(n, n2, n3, n4, n5, n6);
    }

    private static void runOnEDT(boolean bl, Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                if (bl) {
                    EventQueue.invokeAndWait(runnable);
                } else {
                    EventQueue.invokeLater(runnable);
                }
            }
            catch (Exception exception) {
                throw new NativeWindowException((Throwable)exception);
            }
        }
    }

    class Listener
    implements ComponentListener,
    MouseListener,
    MouseMotionListener,
    KeyListener {
        private AWTWindow window;
        private AWTDisplay display;

        public Listener(AWTWindow aWTWindow2) {
            this.window = aWTWindow2;
            this.display = (AWTDisplay)this.window.getScreen().getDisplay();
        }

        public void componentResized(ComponentEvent componentEvent) {
            AWTWindow.this.width = AWTWindow.this.canvas.getWidth();
            AWTWindow.this.height = AWTWindow.this.canvas.getHeight();
            this.display.enqueueEvent(this.window, 100, null);
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.display.enqueueEvent(this.window, 201, mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.display.enqueueEvent(this.window, 202, mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.display.enqueueEvent(this.window, 203, mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.display.enqueueEvent(this.window, 204, mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.display.enqueueEvent(this.window, 205, mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.display.enqueueEvent(this.window, 206, mouseEvent);
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.display.enqueueEvent(this.window, 300, keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.display.enqueueEvent(this.window, 301, keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.display.enqueueEvent(this.window, 302, keyEvent);
        }
    }

    class MoveListener
    implements ComponentListener {
        private AWTWindow window;
        private AWTDisplay display;

        public MoveListener(AWTWindow aWTWindow2) {
            this.window = aWTWindow2;
            this.display = (AWTDisplay)this.window.getScreen().getDisplay();
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (null != AWTWindow.this.container) {
                AWTWindow.this.x = AWTWindow.this.container.getX();
                AWTWindow.this.y = AWTWindow.this.container.getY();
            }
            this.display.enqueueEvent(this.window, 101, null);
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    class WindowEventListener
    implements WindowListener {
        private AWTWindow window;
        private AWTDisplay display;

        public WindowEventListener(AWTWindow aWTWindow2) {
            this.window = aWTWindow2;
            this.display = (AWTDisplay)this.window.getScreen().getDisplay();
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.display.enqueueEvent(this.window, 102, null);
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

