(ns enviable.core
  (:require [enviable.reader :as reader]
            [clojure.string :as str]))

(def var reader/var)
(def parse-with reader/parse-with)
(def default-to reader/default-to)
(def is-optional reader/is-optional)
(def describe reader/describe)

(def error? reader/error?)
(def read-env reader/read-env)

(defn fmap [v-or-error f & args]
  (if (error? v-or-error)
    v-or-error
    (apply f v-or-error args)))

(defn lmap [v-or-error f & args]
  (if (error? v-or-error)
    (apply f v-or-error args)
    v-or-error))


;; Useful Parsers TODO move to separate ns

(defn- wrap-parser [parser]
  (fn [var]
    (parse-with var parser)))

(defn- parse-int [s]
  (Integer/parseInt s))

(defn- parse-bool [s]
  (case (str/lower-case s)
    "true" true
    "false" false
    nil))

(defn- parse-double [s]
  (Double/parseDouble s))

(def int-var (comp (wrap-parser parse-int) var))

(def double-var (comp (wrap-parser parse-double) var))

(def bool-var (comp (wrap-parser parse-bool) var))



