# joplin.dynamo

Joplin migrator implementations for Dynamo. Joplin: https://github.com/juxt/joplin

## Usage

NOTE: This migrator currently only supports the 0.2.X Joplin release.  A 0.3.X compatible release is forthcoming.

`[[joplin.dynamo "0.2.0"]]`

### Configuration

The Joplin target for Dynamo utilizes Faraday for Dynamo operations.  You'll want to take a look at the Faraday docs for specific commands: https://github.com/ptaoussanis/faraday.

Target Example:

```clojure
{:db {:type :dynamo :aws-client-opts <Faraday AWS client opts>}
 :migrator "resources/migrators/dynamo"}
```

Migration Example:

```clojure
(ns migrators.dynamo.20151030-1-create-my-table
  (:require [joplin.dynamo.database :refer :all]
            [taoensso.faraday :as dynamo]))

(defn up
  [db]
  (let [{:keys [aws-client-opts]} db]
    (dynamo/create-table aws-client-opts
                         :my_table
                         [:id :s]
                         {:range-keydef [:type :s]
                          :block? true})))

(defn down
  [db]
  (let [{:keys [aws-client-opts]} db]
    (dynamo/delete-table aws-client-opts :my_table)))


```
