# joplin.dynamo

Joplin migrator implementations for Dynamo. Joplin: https://github.com/juxt/joplin

## Usage

The 0.3.X / 0.2.X release support the respective Joplin release. 

Joplin 0.3.X:

```clojure
[joplin.dynamo "0.3.6"]
```
Joplin 0.2.X is available, but not actively supported:

```clojure
[joplin.dynamo "0.2.0"]
```

### Configuration (0.3.X)

The Joplin target for Dynamo utilizes Amazonica for Dynamo operations, which wraps the official AWS SDK in a direct manner.

Of note are the AWS authentication and DynamoDBV2 sections in the Amazonica documentation:

* https://github.com/mcohen01/amazonica#authentication
* https://github.com/mcohen01/amazonica#dynamodbv2

`joplin.dynamo` uses the standard authentication flow for AWS outline in the Amazonica docs.

Target Example:

```clojure
{:db {:type :dynamo :credentials <<Optional|Defauls to Credentials chain>> :migrations-table <<Required|name of table for migrations metadata>>}
 :migrators "resources/migrators/dynamo"}
```

Migration Example:

```clojure
(ns migrators.dynamo.20151030-1-create-my-table
  (:require [joplin.dynamo.database :refer :all]
            [amazonica.aws.dynamodbv2 :as dynamo]))

(defn up
  [db]
  (let [{:keys [credentials]} db]
    (dynamo/create-table credentials 
                         :table-name :my_table
                         :key-schema [{:attribute-name :id :key-type :HASH}]
                         :attribute-definitions [{:attribute-name :id :attribute-type :S}]
                         :provisioned-throughput {:read-capacity-units 1 :write-capacity-units 1})))

(defn down
  [db]
  (let [{:keys [credentials]} db]
    (dynamo/delete-table credentials :table-name :my_table)))

```

### Configuration (0.2.X)

The Joplin target for Dynamo utilizes Faraday for Dynamo operations.  You'll want to take a look at the Faraday docs for specific commands: https://github.com/ptaoussanis/faraday.

Target Example:

```clojure
{:db {:type :dynamo :aws-client-opts <Faraday AWS client opts>}
 :migrator "resources/migrators/dynamo"}
```

Migration Example:

```clojure
(ns migrators.dynamo.20151030-1-create-my-table
  (:require [joplin.dynamo.database :refer :all]
            [taoensso.faraday :as dynamo]))

(defn up
  [db]
  (let [{:keys [aws-client-opts]} db]
    (dynamo/create-table aws-client-opts
                         :my_table
                         [:id :s]
                         {:range-keydef [:type :s]
                          :block? true})))

(defn down
  [db]
  (let [{:keys [aws-client-opts]} db]
    (dynamo/delete-table aws-client-opts :my_table)))


```
