(ns enlive-utils.core
  (:use net.cgrand.enlive-html
        i18n.core))

(defn attr-some [attr f]
  (pred #(when-let [vs (attr-values % attr)] (some f vs))))

(defn localize-content [resname locale]
  (fn [nodes]
    (let [v (some #(resource resname locale %) (attr-values nodes :message))]
      (assoc nodes :content [v]))))

(defn localize-document [resname locale]
  (let [reskeys (set (map name (resource-keys resname locale)))]
    (transformation
      [(attr-some :message reskeys)]
      (do-> (localize-content resname locale)
            (remove-attr :message)))))

(defn format-content [& args]
  #(let [[old-content] (:content %)]
     (if (string? old-content)
       (assoc % :content [(apply format old-content args)]))))

